/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.ForeignKeyAction;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.IndexedValue;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.util.StringUtils;

public class JoinMetaData
extends MetaData
implements ColumnMetaDataContainer {
    ForeignKeyMetaData foreignKeyMetaData;
    IndexMetaData indexMetaData;
    UniqueMetaData uniqueMetaData;
    protected PrimaryKeyMetaData primaryKeyMetaData;
    final List<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
    boolean outer = false;
    String table;
    String catalog;
    String schema;
    String columnName;
    protected IndexedValue indexed = null;
    protected boolean unique;
    protected ColumnMetaData[] columnMetaData;

    public JoinMetaData(JoinMetaData joinmd) {
        this.table = joinmd.table;
        this.catalog = joinmd.catalog;
        this.schema = joinmd.schema;
        this.columnName = joinmd.columnName;
        this.outer = joinmd.outer;
        this.indexed = joinmd.indexed;
        this.unique = joinmd.unique;
        for (int i = 0; i < joinmd.columns.size(); ++i) {
            this.addColumn(new ColumnMetaData(joinmd.columns.get(i)));
        }
    }

    public JoinMetaData() {
    }

    public void initialise() {
        int i;
        if (this.table != null && this.parent instanceof AbstractMemberMetaData) {
            throw new InvalidMetaDataException(LOCALISER, "044130", (Object)((AbstractMemberMetaData)this.parent).getFullFieldName());
        }
        if (this.columns.size() == 0 && this.columnName != null) {
            this.columnMetaData = new ColumnMetaData[1];
            this.columnMetaData[0] = new ColumnMetaData(this.columnName);
            this.columnMetaData[0].parent = this;
            this.columnMetaData[0].initialise();
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = this.columns.get(i);
                this.columnMetaData[i].initialise();
            }
        }
        if (this.foreignKeyMetaData != null) {
            this.foreignKeyMetaData.initialise();
        }
        if (this.indexMetaData == null && this.columnMetaData != null && this.indexed != null && this.indexed != IndexedValue.FALSE) {
            this.indexMetaData = new IndexMetaData();
            this.indexMetaData.setUnique(this.indexed == IndexedValue.UNIQUE);
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.indexMetaData.addColumn(this.columnMetaData[i]);
            }
        }
        if (this.indexMetaData != null) {
            this.indexMetaData.initialise();
        }
        if (this.uniqueMetaData == null && this.unique) {
            this.uniqueMetaData = new UniqueMetaData();
            this.uniqueMetaData.setTable(this.columnName);
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.uniqueMetaData.addColumn(this.columnMetaData[i]);
            }
        }
        if (this.uniqueMetaData != null) {
            this.uniqueMetaData.initialise();
        }
        if (this.primaryKeyMetaData != null) {
            this.primaryKeyMetaData.initialise();
        }
        this.setInitialised();
    }

    public void addColumn(ColumnMetaData colmd) {
        this.columns.add(colmd);
        colmd.parent = this;
    }

    public final boolean isOuter() {
        return this.outer;
    }

    public void setOuter(boolean outer) {
        this.outer = outer;
    }

    public void setOuter(String outer) {
        this.outer = MetaDataUtils.getBooleanForString(outer, false);
    }

    public String getDeleteAction() {
        if (this.foreignKeyMetaData != null) {
            return this.foreignKeyMetaData.getDeleteAction().toString();
        }
        return null;
    }

    public void setDeleteAction(String deleteAction) {
        if (!StringUtils.isWhitespace(deleteAction)) {
            this.foreignKeyMetaData = new ForeignKeyMetaData();
            this.foreignKeyMetaData.setDeleteAction(ForeignKeyAction.getForeignKeyAction(deleteAction));
        }
    }

    public IndexedValue getIndexed() {
        return this.indexed;
    }

    public void setIndexed(IndexedValue indexed) {
        if (indexed != null) {
            this.indexed = indexed;
        }
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public void setUnique(String unique) {
        this.unique = MetaDataUtils.getBooleanForString(unique, false);
    }

    public final String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = StringUtils.isWhitespace(table) ? null : table;
    }

    public final String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = StringUtils.isWhitespace(catalog) ? null : catalog;
    }

    public final String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = StringUtils.isWhitespace(schema) ? null : schema;
    }

    public final String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = StringUtils.isWhitespace(columnName) ? null : columnName;
    }

    public final ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public final IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public final UniqueMetaData getUniqueMetaData() {
        return this.uniqueMetaData;
    }

    public final ForeignKeyMetaData getForeignKeyMetaData() {
        return this.foreignKeyMetaData;
    }

    public final PrimaryKeyMetaData getPrimaryKeyMetaData() {
        return this.primaryKeyMetaData;
    }

    public final void setForeignKeyMetaData(ForeignKeyMetaData foreignKeyMetaData) {
        this.foreignKeyMetaData = foreignKeyMetaData;
        foreignKeyMetaData.parent = this;
    }

    public final void setIndexMetaData(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
        indexMetaData.parent = this;
    }

    public final void setUniqueMetaData(UniqueMetaData uniqueMetaData) {
        this.uniqueMetaData = uniqueMetaData;
        uniqueMetaData.parent = this;
    }

    public final void setPrimaryKeyMetaData(PrimaryKeyMetaData primaryKeyMetaData) {
        this.primaryKeyMetaData = primaryKeyMetaData;
        primaryKeyMetaData.parent = this;
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<join");
        if (this.table != null) {
            sb.append(" table=\"" + this.table + "\"");
        }
        if (this.columnName != null) {
            sb.append(" column=\"" + this.columnName + "\"");
        }
        sb.append(" outer=\"" + this.outer + "\"");
        sb.append(">\n");
        if (this.primaryKeyMetaData != null) {
            sb.append(this.primaryKeyMetaData.toString(prefix + indent, indent));
        }
        if (this.columnMetaData != null) {
            for (int i = 0; i < this.columnMetaData.length; ++i) {
                sb.append(this.columnMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.foreignKeyMetaData != null) {
            sb.append(this.foreignKeyMetaData.toString(prefix + indent, indent));
        }
        if (this.indexMetaData != null) {
            sb.append(this.indexMetaData.toString(prefix + indent, indent));
        }
        if (this.uniqueMetaData != null) {
            sb.append(this.uniqueMetaData.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</join>\n");
        return sb.toString();
    }
}

