/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.MetaData;

public class InheritanceMetaData
extends MetaData {
    protected InheritanceStrategy strategy = null;
    protected JoinMetaData joinMetaData;
    protected DiscriminatorMetaData discriminatorMetaData;
    protected String strategyForTree = null;

    public void initialise() {
        if (this.joinMetaData != null) {
            this.joinMetaData.initialise();
        }
        if (this.discriminatorMetaData != null) {
            this.discriminatorMetaData.initialise();
        }
        this.setInitialised();
    }

    public void setStrategyForTree(String strategy) {
        this.strategyForTree = strategy;
    }

    public String getStrategyForTree() {
        return this.strategyForTree;
    }

    public InheritanceStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(InheritanceStrategy strategy) {
        this.strategy = strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = InheritanceStrategy.getInheritanceStrategy(strategy);
    }

    public JoinMetaData getJoinMetaData() {
        return this.joinMetaData;
    }

    public void setJoinMetaData(JoinMetaData joinMetaData) {
        this.joinMetaData = joinMetaData;
        if (this.joinMetaData != null) {
            this.joinMetaData.parent = this;
        }
    }

    public DiscriminatorMetaData getDiscriminatorMetaData() {
        return this.discriminatorMetaData;
    }

    public void setDiscriminatorMetaData(DiscriminatorMetaData discriminatorMetaData) {
        this.discriminatorMetaData = discriminatorMetaData;
        this.discriminatorMetaData.parent = this;
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<inheritance strategy=\"" + this.strategy + "\">\n");
        if (this.joinMetaData != null) {
            sb.append(this.joinMetaData.toString(prefix + indent, indent));
        }
        if (this.discriminatorMetaData != null) {
            sb.append(this.discriminatorMetaData.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</inheritance>\n");
        return sb.toString();
    }
}

