/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.util.StringUtils;

public class IdentityMetaData
extends MetaData
implements ColumnMetaDataContainer {
    protected String columnName;
    protected IdentityStrategy strategy;
    protected String sequence;
    final List<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
    protected String valueGeneratorName;
    protected ColumnMetaData[] columnMetaData;

    public void initialise() {
        if (this.strategy == null) {
            this.strategy = IdentityStrategy.NATIVE;
        }
        if (this.columns.size() == 0 && this.columnName != null) {
            this.columnMetaData = new ColumnMetaData[1];
            this.columnMetaData[0] = new ColumnMetaData(this.columnName);
            this.columnMetaData[0].parent = this;
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (int i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = this.columns.get(i);
                this.columnMetaData[i].initialise();
            }
        }
        this.setInitialised();
    }

    public void addColumn(ColumnMetaData colmd) {
        this.columns.add(colmd);
        colmd.parent = this;
        this.columnMetaData = new ColumnMetaData[this.columns.size()];
        for (int i = 0; i < this.columnMetaData.length; ++i) {
            this.columnMetaData[i] = this.columns.get(i);
        }
    }

    public final ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = StringUtils.isWhitespace(columnName) ? null : columnName;
    }

    public IdentityStrategy getValueStrategy() {
        return this.strategy;
    }

    public void setValueStrategy(IdentityStrategy strategy) {
        this.strategy = strategy;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        String string = this.sequence = StringUtils.isWhitespace(sequence) ? null : sequence;
        if (this.sequence != null && this.strategy == null) {
            this.strategy = IdentityStrategy.SEQUENCE;
        }
    }

    public String getValueGeneratorName() {
        return this.valueGeneratorName;
    }

    public void setValueGeneratorName(String generator) {
        this.valueGeneratorName = StringUtils.isWhitespace(generator) ? null : generator;
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        if (this.strategy != null) {
            sb.append(prefix).append("<datastore-identity strategy=\"" + this.strategy + "\"");
        } else {
            sb.append(prefix).append("<datastore-identity");
        }
        if (this.columnName != null) {
            sb.append("\n").append(prefix).append("        column=\"" + this.columnName + "\"");
        }
        if (this.sequence != null) {
            sb.append("\n").append(prefix).append("        sequence=\"" + this.sequence + "\"");
        }
        if (this.columnMetaData != null && this.columnMetaData.length > 0 || this.getNoOfExtensions() > 0) {
            sb.append(">\n");
            if (this.columnMetaData != null) {
                for (int i = 0; i < this.columnMetaData.length; ++i) {
                    sb.append(this.columnMetaData[i].toString(prefix + indent, indent));
                }
            }
            sb.append(super.toString(prefix + indent, indent));
            sb.append(prefix).append("</datastore-identity>\n");
        } else {
            sb.append("/>\n");
        }
        return sb.toString();
    }
}

