/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.util.StringUtils;

public class FetchPlanMetaData
extends MetaData {
    String name;
    protected int maxFetchDepth = -1;
    protected int fetchSize = -1;
    protected List fetchGroups = new ArrayList();

    public FetchPlanMetaData(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final int getMaxFetchDepth() {
        return this.maxFetchDepth;
    }

    public void setMaxFetchDepth(int maxFetchDepth) {
        this.maxFetchDepth = maxFetchDepth;
    }

    public void setMaxFetchDepth(String maxFetchDepth) {
        if (StringUtils.isWhitespace(maxFetchDepth)) {
            return;
        }
        try {
            int value;
            this.maxFetchDepth = value = Integer.parseInt(maxFetchDepth);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public final int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setFetchSize(String fetchSize) {
        if (StringUtils.isWhitespace(fetchSize)) {
            return;
        }
        try {
            int value;
            this.fetchSize = value = Integer.parseInt(fetchSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public final FetchGroupMetaData[] getFetchGroupMetaData() {
        return this.fetchGroups.toArray(new FetchGroupMetaData[this.fetchGroups.size()]);
    }

    public void addFetchGroup(FetchGroupMetaData fgmd) {
        this.fetchGroups.add(fgmd);
        fgmd.parent = this;
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<fetch-plan name=\"" + this.name + "\"" + " max-fetch-depth=\"" + this.maxFetchDepth + "\"" + " fetch-size=\"" + this.fetchSize + "\"\n");
        for (FetchGroupMetaData fgmd : this.fetchGroups) {
            sb.append(fgmd.toString(prefix + indent, indent));
        }
        sb.append(prefix + "</fetch-plan>\n");
        return sb.toString();
    }
}

