/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.IndexedValue;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class DiscriminatorMetaData
extends MetaData {
    protected DiscriminatorStrategy strategy = null;
    protected String columnName = null;
    protected String value = null;
    protected IndexedValue indexed = null;
    protected ColumnMetaData columnMetaData = null;
    protected IndexMetaData indexMetaData;

    public DiscriminatorMetaData(DiscriminatorMetaData dmd) {
        this.columnName = dmd.columnName;
        this.value = dmd.value;
        this.strategy = dmd.strategy;
        this.indexed = dmd.indexed;
        if (dmd.columnMetaData != null) {
            this.setColumnMetaData(new ColumnMetaData(dmd.columnMetaData));
        }
        if (dmd.indexMetaData != null) {
            this.setIndexMetaData(new IndexMetaData(dmd.indexMetaData));
        }
    }

    public DiscriminatorMetaData() {
    }

    public void initialise() {
        if (this.value != null && this.strategy == null) {
            this.strategy = DiscriminatorStrategy.VALUE_MAP;
        } else if (this.strategy == null) {
            this.strategy = DiscriminatorStrategy.CLASS_NAME;
        }
        if (this.strategy == DiscriminatorStrategy.VALUE_MAP && this.value == null) {
            String className = ((AbstractClassMetaData)this.parent.getParent()).getFullClassName();
            NucleusLogger.METADATA.warn(LOCALISER.msg("044103", (Object)className));
            this.value = className;
        }
        if (this.indexMetaData == null && this.columnMetaData != null && this.indexed != null && this.indexed != IndexedValue.FALSE) {
            this.indexMetaData = new IndexMetaData();
            this.indexMetaData.setUnique(this.indexed == IndexedValue.UNIQUE);
            this.indexMetaData.addColumn(this.columnMetaData);
        }
        if (this.indexMetaData != null) {
            this.indexMetaData.initialise();
        }
        if (this.columnMetaData == null && this.columnName != null) {
            this.columnMetaData = new ColumnMetaData(this.columnName);
            this.columnMetaData.parent = this;
            this.columnMetaData.initialise();
        }
        this.setInitialised();
    }

    public ColumnMetaData getColumnMetaData() {
        return this.columnMetaData;
    }

    public void setColumnMetaData(ColumnMetaData columnMetaData) {
        this.columnMetaData = columnMetaData;
        this.columnMetaData.parent = this;
    }

    public final IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public final void setIndexMetaData(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
        this.indexMetaData.parent = this;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (!StringUtils.isWhitespace(value)) {
            this.value = value;
        }
    }

    public String getColumnName() {
        if (this.columnMetaData != null && this.columnMetaData.getName() != null) {
            return this.columnMetaData.getName();
        }
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = StringUtils.isWhitespace(columnName) ? null : columnName;
    }

    public final DiscriminatorStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(DiscriminatorStrategy strategy) {
        this.strategy = strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = DiscriminatorStrategy.getDiscriminatorStrategy(strategy);
    }

    public IndexedValue getIndexed() {
        return this.indexed;
    }

    public void setIndexed(IndexedValue indexed) {
        this.indexed = indexed;
    }

    public void setIndexed(String indexed) {
        this.indexed = IndexedValue.getIndexedValue(indexed);
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<discriminator");
        if (this.strategy != null) {
            sb.append(" strategy=\"" + this.strategy.toString() + "\"");
        }
        if (this.columnName != null && this.columnMetaData == null) {
            sb.append(" column=\"" + this.columnName + "\"");
        }
        if (this.value != null) {
            sb.append(" value=\"" + this.value + "\"");
        }
        if (this.indexed != null) {
            sb.append(" indexed=\"" + this.indexed.toString() + "\"");
        }
        sb.append(">\n");
        if (this.columnMetaData != null) {
            sb.append(this.columnMetaData.toString(prefix + indent, indent));
        }
        if (this.indexMetaData != null) {
            sb.append(this.indexMetaData.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</discriminator>\n");
        return sb.toString();
    }
}

