/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import org.datanucleus.metadata.MetaData;
import org.datanucleus.util.StringUtils;

public class ColumnMetaData
extends MetaData {
    protected String name;
    protected String target;
    protected String targetMember;
    protected String jdbcType;
    protected String sqlType;
    protected Integer length;
    protected Integer scale;
    protected Boolean allowsNull;
    protected String defaultValue;
    protected String insertValue;
    protected boolean insertable = true;
    protected boolean updateable = true;
    protected boolean unique;

    public ColumnMetaData(ColumnMetaData colmd) {
        this.name = colmd.getName();
        this.target = colmd.getTarget();
        this.targetMember = colmd.getTargetMember();
        this.jdbcType = colmd.getJdbcType();
        this.sqlType = colmd.getSqlType();
        this.length = colmd.getLength();
        this.scale = colmd.getScale();
        this.allowsNull = colmd.allowsNull;
        this.defaultValue = colmd.getDefaultValue();
        this.insertValue = colmd.getInsertValue();
        this.insertable = colmd.getInsertable();
        this.updateable = colmd.getUpdateable();
        this.unique = colmd.getUnique();
    }

    public ColumnMetaData(String name) {
        this(name, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public ColumnMetaData(String name, String target, String targetMember, String jdbcType, String sqlType, String length, String scale, String allowsNull, String defaultValue, String insertValue, String insertable, String updateable, String unique) {
        this.name = StringUtils.isWhitespace(name) ? null : name;
        this.target = StringUtils.isWhitespace(target) ? null : target;
        this.targetMember = StringUtils.isWhitespace(targetMember) ? null : targetMember;
        this.jdbcType = StringUtils.isWhitespace(jdbcType) ? null : jdbcType;
        String string = this.sqlType = StringUtils.isWhitespace(sqlType) ? null : sqlType;
        if (length != null && length.length() > 0) {
            this.length = Integer.valueOf(length);
        }
        if (scale != null && scale.length() > 0) {
            this.scale = Integer.valueOf(scale);
        }
        if (allowsNull != null) {
            if (allowsNull.equalsIgnoreCase("true")) {
                this.allowsNull = Boolean.TRUE;
            } else if (allowsNull.equalsIgnoreCase("false")) {
                this.allowsNull = Boolean.FALSE;
            }
        }
        this.defaultValue = StringUtils.isWhitespace(defaultValue) ? null : defaultValue;
        this.insertValue = StringUtils.isWhitespace(insertValue) ? null : insertValue;
        this.insertable = insertable == null || !insertable.equalsIgnoreCase("false");
        this.updateable = updateable == null || !updateable.equalsIgnoreCase("false");
        this.unique = unique != null && unique.equalsIgnoreCase("true");
    }

    public Boolean getAllowsNull() {
        return this.allowsNull;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean getInsertable() {
        return this.insertable;
    }

    public String getInsertValue() {
        return this.insertValue;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public Integer getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public Integer getScale() {
        return this.scale;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public String getTarget() {
        return this.target;
    }

    public String getTargetMember() {
        return this.targetMember;
    }

    public boolean getUnique() {
        return this.unique;
    }

    public boolean getUpdateable() {
        return this.updateable;
    }

    public boolean isAllowsNull() {
        if (this.allowsNull == null) {
            return false;
        }
        return this.allowsNull;
    }

    public final void setAllowsNull(Boolean allowsNull) {
        this.allowsNull = allowsNull;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setInsertValue(String insertValue) {
        this.insertValue = insertValue;
    }

    public final void setJdbcType(String jdbcType) {
        this.jdbcType = jdbcType;
    }

    public final void setLength(int length) {
        this.length = new Integer(length);
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setScale(int scale) {
        this.scale = new Integer(scale);
    }

    public final void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setTargetMember(String targetMember) {
        this.targetMember = targetMember;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public void setUpdateable(boolean updateable) {
        this.updateable = updateable;
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<column");
        if (this.name != null) {
            sb.append(" name=\"" + this.name + "\"");
        }
        if (this.target != null) {
            sb.append(" target=\"" + this.target + "\"");
        }
        if (this.targetMember != null) {
            sb.append(" target-field=\"" + this.targetMember + "\"");
        }
        if (this.jdbcType != null) {
            sb.append(" jdbc-type=\"" + this.jdbcType + "\"");
        }
        if (this.sqlType != null) {
            sb.append(" sql-type=\"" + this.sqlType + "\"");
        }
        if (this.allowsNull != null) {
            sb.append(" allows-null=\"" + this.allowsNull + "\"");
        }
        if (this.length != null) {
            sb.append(" length=\"" + this.length + "\"");
        }
        if (this.scale != null) {
            sb.append(" scale=\"" + this.scale + "\"");
        }
        if (this.defaultValue != null) {
            sb.append(" default-value=\"" + this.defaultValue + "\"");
        }
        if (this.insertValue != null) {
            sb.append(" insert-value=\"" + this.insertValue + "\"");
        }
        if (this.extensions != null && this.extensions.size() > 0) {
            sb.append(">\n");
            sb.append(super.toString(prefix + indent, indent));
            sb.append(prefix).append("</column>\n");
        } else {
            sb.append("/>\n");
        }
        return sb.toString();
    }
}

