/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.ForeignKeyAction;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.IndexedValue;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.util.StringUtils;

public abstract class AbstractElementMetaData
extends MetaData
implements ColumnMetaDataContainer {
    protected final List columns = new ArrayList();
    protected IndexMetaData indexMetaData;
    protected IndexedValue indexed = null;
    protected UniqueMetaData uniqueMetaData;
    protected boolean unique;
    protected ForeignKeyMetaData foreignKeyMetaData;
    protected EmbeddedMetaData embeddedMetaData;
    protected String columnName;
    protected String mappedBy;
    protected ColumnMetaData[] columnMetaData;

    public AbstractElementMetaData(AbstractElementMetaData aemd) {
        this.columnName = aemd.columnName;
        this.unique = aemd.unique;
        this.indexed = aemd.indexed;
        this.mappedBy = aemd.mappedBy;
        if (aemd.indexMetaData != null) {
            this.setIndexMetaData(new IndexMetaData(aemd.indexMetaData));
        }
        if (aemd.uniqueMetaData != null) {
            this.setUniqueMetaData(new UniqueMetaData(aemd.uniqueMetaData));
        }
        if (aemd.foreignKeyMetaData != null) {
            this.setForeignKeyMetaData(new ForeignKeyMetaData(aemd.foreignKeyMetaData));
        }
        if (aemd.embeddedMetaData != null) {
            this.setEmbeddedMetaData(new EmbeddedMetaData(aemd.embeddedMetaData));
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            this.addColumn(new ColumnMetaData((ColumnMetaData)aemd.columns.get(i)));
        }
    }

    public AbstractElementMetaData() {
    }

    public void populate(ClassLoaderResolver clr, ClassLoader primary) {
        if (this.embeddedMetaData != null) {
            this.embeddedMetaData.populate(clr, primary);
        }
    }

    public void initialise() {
        int i;
        if (this.columns.size() == 0 && this.columnName != null) {
            this.columnMetaData = new ColumnMetaData[1];
            this.columnMetaData[0] = new ColumnMetaData(this.columnName);
            this.columnMetaData[0].parent = this;
            this.columnMetaData[0].initialise();
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = (ColumnMetaData)this.columns.get(i);
                this.columnMetaData[i].initialise();
            }
        }
        if (this.indexMetaData == null && this.columnMetaData != null && this.indexed != null && this.indexed != IndexedValue.FALSE) {
            this.indexMetaData = new IndexMetaData();
            this.indexMetaData.setUnique(this.indexed == IndexedValue.UNIQUE);
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.indexMetaData.addColumn(this.columnMetaData[i]);
            }
        }
        if (this.indexMetaData != null) {
            this.indexMetaData.initialise();
        }
        if (this.uniqueMetaData == null && this.unique) {
            this.uniqueMetaData = new UniqueMetaData();
            this.uniqueMetaData.setTable(this.columnName);
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.uniqueMetaData.addColumn(this.columnMetaData[i]);
            }
        }
        if (this.uniqueMetaData != null) {
            this.uniqueMetaData.initialise();
        }
        if (this.foreignKeyMetaData != null) {
            this.foreignKeyMetaData.initialise();
        }
        if (this.embeddedMetaData != null) {
            this.embeddedMetaData.initialise();
        }
        this.setInitialised();
    }

    public final String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = StringUtils.isWhitespace(columnName) ? null : columnName;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = StringUtils.isWhitespace(mappedBy) ? null : mappedBy;
    }

    public IndexedValue getIndexed() {
        return this.indexed;
    }

    public void setIndexed(IndexedValue indexed) {
        this.indexed = indexed;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public void setUnique(String unique) {
        this.unique = MetaDataUtils.getBooleanForString(unique, false);
    }

    public String getDeleteAction() {
        if (this.foreignKeyMetaData != null) {
            return this.foreignKeyMetaData.getDeleteAction().toString();
        }
        return null;
    }

    public void setDeleteAction(String deleteAction) {
        if (!StringUtils.isWhitespace(deleteAction)) {
            this.foreignKeyMetaData = new ForeignKeyMetaData();
            this.foreignKeyMetaData.setDeleteAction(ForeignKeyAction.getForeignKeyAction(deleteAction));
        }
    }

    public String getUpdateAction() {
        if (this.foreignKeyMetaData != null) {
            return this.foreignKeyMetaData.getUpdateAction().toString();
        }
        return null;
    }

    public void setUpdateAction(String updateAction) {
        if (!StringUtils.isWhitespace(updateAction)) {
            this.foreignKeyMetaData = new ForeignKeyMetaData();
            this.foreignKeyMetaData.setUpdateAction(ForeignKeyAction.getForeignKeyAction(updateAction));
        }
    }

    public final ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public final EmbeddedMetaData getEmbeddedMetaData() {
        return this.embeddedMetaData;
    }

    public final ForeignKeyMetaData getForeignKeyMetaData() {
        return this.foreignKeyMetaData;
    }

    public final IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public final UniqueMetaData getUniqueMetaData() {
        return this.uniqueMetaData;
    }

    public void addColumn(ColumnMetaData colmd) {
        this.columns.add(colmd);
        colmd.parent = this;
    }

    public final void setEmbeddedMetaData(EmbeddedMetaData embeddedMetaData) {
        this.embeddedMetaData = embeddedMetaData;
        embeddedMetaData.parent = this;
    }

    public final void setForeignKeyMetaData(ForeignKeyMetaData foreignKeyMetaData) {
        this.foreignKeyMetaData = foreignKeyMetaData;
        foreignKeyMetaData.parent = this;
    }

    public final void setIndexMetaData(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
        indexMetaData.parent = this;
    }

    public final void setUniqueMetaData(UniqueMetaData uniqueMetaData) {
        this.uniqueMetaData = uniqueMetaData;
        uniqueMetaData.parent = this;
    }
}

