/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.util.StringUtils;

public class AbstractConstraintMetaData
extends MetaData {
    protected String name;
    protected String table;
    protected AbstractMemberMetaData[] memberMetaData;
    protected ColumnMetaData[] columnMetaData;
    protected List members = new ArrayList();
    protected List columns = new ArrayList();

    public void initialise() {
        int i;
        if (this.isInitialised()) {
            return;
        }
        if (this.members.size() == 0) {
            this.memberMetaData = null;
        } else {
            this.memberMetaData = new AbstractMemberMetaData[this.members.size()];
            for (i = 0; i < this.memberMetaData.length; ++i) {
                this.memberMetaData[i] = (AbstractMemberMetaData)this.members.get(i);
                this.memberMetaData[i].initialise();
            }
        }
        if (this.columns.size() == 0) {
            this.columnMetaData = null;
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = (ColumnMetaData)this.columns.get(i);
                this.columnMetaData[i].initialise();
            }
        }
        this.members.clear();
        this.members = null;
        this.columns.clear();
        this.columns = null;
        this.setInitialised();
    }

    public void addMember(AbstractMemberMetaData mmd) {
        this.members.add(mmd);
        mmd.parent = this;
    }

    public void addColumn(ColumnMetaData colmd) {
        this.columns.add(colmd);
        colmd.parent = this;
    }

    public void setName(String name) {
        this.name = StringUtils.isWhitespace(name) ? null : name;
    }

    public void setTable(String table) {
        this.table = StringUtils.isWhitespace(table) ? null : table;
    }

    public final String getName() {
        return this.name;
    }

    public final String getTable() {
        return this.table;
    }

    public final AbstractMemberMetaData[] getMemberMetaData() {
        return this.memberMetaData;
    }

    public final ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public int getNumberOfMembers() {
        if (this.members != null) {
            return this.members.size();
        }
        if (this.memberMetaData != null) {
            return this.memberMetaData.length;
        }
        return 0;
    }

    public int getNumberOfColumns() {
        if (this.columns != null) {
            return this.columns.size();
        }
        if (this.columnMetaData != null) {
            return this.columnMetaData.length;
        }
        return 0;
    }
}

