/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.management.ManagementServer;
import org.datanucleus.management.runtime.QueryRuntime;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.memory.InvocationEvaluator;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class QueryManager {
    OMFContext omfCtx;
    Map<String, QueryCompilation> queryCompilationCache = new WeakHashMap<String, QueryCompilation>();
    Map<String, Collection> queryMethodEvaluatorMap = new HashMap<String, Collection>();
    QueryRuntime queryRuntime = null;

    public QueryManager(OMFContext omfContext) {
        this.omfCtx = omfContext;
        if (omfContext.getManagement() != null) {
            ManagementServer mgntServer = omfContext.getManagement().getManagementServer();
            this.queryRuntime = new QueryRuntime();
            String mbeanName = omfContext.getDomainName() + ":InstanceName=" + omfContext.getInstanceName() + ",Type=" + ClassUtils.getClassNameForClass(this.queryRuntime.getClass()) + ",Name=QueryRuntime";
            mgntServer.registerMBean(this.queryRuntime, mbeanName);
        }
    }

    public void close() {
        this.queryCompilationCache.clear();
        this.queryCompilationCache = null;
        this.queryRuntime = null;
    }

    public QueryRuntime getQueryRuntime() {
        return this.queryRuntime;
    }

    public Query newQuery(String language, ObjectManager om, Object query) {
        if (language == null) {
            return null;
        }
        try {
            if (query == null) {
                Class[] argsClass = new Class[]{ObjectManager.class};
                Object[] args = new Object[]{om};
                Query q = (Query)om.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{language, om.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException("DataNucleus doesnt currently support queries of language " + language + " for this datastore");
                }
                return q;
            }
            Query q = null;
            if (query instanceof String) {
                Class[] argsClass = new Class[]{ObjectManager.class, String.class};
                Object[] args = new Object[]{om, query};
                q = (Query)om.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{language, om.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException("DataNucleus doesnt currently support queries of language " + language + " for this datastore");
                }
            } else if (query instanceof Query) {
                Class[] argsClass = new Class[]{ObjectManager.class, query.getClass()};
                Object[] args = new Object[]{om, query};
                q = (Query)om.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{language, om.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException("DataNucleus doesnt currently support queries of language " + language + " for this datastore");
                }
            } else {
                Class[] argsClass = new Class[]{ObjectManager.class, Object.class};
                Object[] args = new Object[]{om, query};
                q = (Query)om.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{language, om.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException("DataNucleus doesnt currently support queries of language " + language + " for this datastore");
                }
            }
            return q;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new NucleusException(t.getMessage(), t).setFatal();
        }
        catch (Exception e) {
            throw new NucleusException(e.getMessage(), e).setFatal();
        }
    }

    public QueryCompilation getQueryCompilationForQuery(String language, String query) {
        return this.queryCompilationCache.get(language + ":" + query);
    }

    public void addQueryCompilation(String language, String query, QueryCompilation compilation) {
        this.queryCompilationCache.put(language + ":" + query, compilation);
    }

    public InvocationEvaluator getInMemoryEvaluatorForMethod(Class type, String methodName) {
        Collection methods = this.queryMethodEvaluatorMap.get(methodName);
        if (methods != null) {
            for (InvocationEvaluator eval : methods) {
                if (!eval.supportsType(type)) continue;
                return eval;
            }
        } else {
            String[] evaluatorNames = this.omfCtx.getPluginManager().getAttributeValuesForExtension("org.datanucleus.store_query_methods", "name", methodName, "memory-evaluator");
            if (evaluatorNames != null) {
                HashSet<InvocationEvaluator> evaluators = new HashSet<InvocationEvaluator>();
                InvocationEvaluator evalToUse = null;
                for (int i = 0; i < evaluatorNames.length; ++i) {
                    try {
                        Class evalCls = this.omfCtx.getClassLoaderResolver(null).classForName(evaluatorNames[i]);
                        InvocationEvaluator eval = (InvocationEvaluator)evalCls.newInstance();
                        evaluators.add(eval);
                        if (!eval.supportsType(type)) continue;
                        evalToUse = eval;
                        continue;
                    }
                    catch (Exception e) {
                        NucleusLogger.QUERY.warn("Extension org.datanucleus.store_query_methods has method=" + methodName + " referencing evaluator " + evaluatorNames[i] + " but an error occurred in construction : " + e.getMessage());
                    }
                }
                this.queryMethodEvaluatorMap.put(methodName, evaluators);
                return evalToUse;
            }
        }
        return null;
    }
}

