/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.jdo.JDOUserException;
import org.datanucleus.ManagedConnectionResourceListener;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.util.Localiser;

public abstract class AbstractQueryResult
extends AbstractList
implements QueryResult,
Serializable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected Query query;
    protected boolean closed = false;
    protected List<ManagedConnectionResourceListener> connectionListeners = null;

    public AbstractQueryResult(Query query) {
        this.query = query;
    }

    public void disconnect() {
        if (this.query == null) {
            return;
        }
        this.closingConnection();
        this.closeResults();
        this.query = null;
    }

    protected abstract void closingConnection();

    protected abstract void closeResults();

    public synchronized void close() {
        this.closeResults();
        this.query = null;
        this.closed = true;
        if (this.connectionListeners != null) {
            Iterator<ManagedConnectionResourceListener> iter = this.connectionListeners.iterator();
            while (iter.hasNext()) {
                iter.next().resourcePostClose();
            }
        }
    }

    public void addConnectionListener(ManagedConnectionResourceListener listener) {
        if (this.connectionListeners == null) {
            this.connectionListeners = new ArrayList<ManagedConnectionResourceListener>();
        }
        this.connectionListeners.add(listener);
    }

    protected boolean isOpen() {
        return !this.closed;
    }

    protected void assertIsOpen() {
        if (!this.isOpen()) {
            throw new JDOUserException(LOCALISER.msg("052600"));
        }
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException(LOCALISER.msg("052603"));
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException(LOCALISER.msg("052603"));
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException(LOCALISER.msg("052603"));
    }

    public void clear() {
        throw new UnsupportedOperationException(LOCALISER.msg("052603"));
    }

    public boolean contains(Object o) {
        throw new UnsupportedOperationException(LOCALISER.msg("052604"));
    }

    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException(LOCALISER.msg("052604"));
    }

    public abstract boolean equals(Object var1);

    public abstract Object get(int var1);

    public int hashCode() {
        if (this.query != null) {
            return this.query.hashCode();
        }
        return super.hashCode();
    }

    public int indexOf(Object o) {
        throw new UnsupportedOperationException(LOCALISER.msg("052604"));
    }

    public boolean isEmpty() {
        return this.size() < 1;
    }

    public abstract Iterator iterator();

    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException(LOCALISER.msg("052604"));
    }

    public abstract ListIterator listIterator();

    public Object remove(int index) {
        throw new UnsupportedOperationException(LOCALISER.msg("052603"));
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException(LOCALISER.msg("052603"));
    }

    public abstract int size();

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException(LOCALISER.msg("052604"));
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException(LOCALISER.msg("052604"));
    }

    public Object[] toArray(Object[] a) {
        throw new UnsupportedOperationException(LOCALISER.msg("052604"));
    }
}

