/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.util.Map;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.query.JPQLSingleStringParser;
import org.datanucleus.query.compiler.JPQLCompiler;
import org.datanucleus.query.compiler.JavaQueryCompiler;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractJPQLQuery
extends AbstractJavaQuery {
    public AbstractJPQLQuery(ObjectManager om) {
        super(om);
    }

    public AbstractJPQLQuery(ObjectManager om, AbstractJPQLQuery q) {
        super(om);
        if (q == null) {
            this.candidateClass = null;
            this.candidateClassName = null;
            this.filter = null;
            this.imports = null;
            this.explicitVariables = null;
            this.explicitParameters = null;
            this.grouping = null;
            this.ordering = null;
            this.result = null;
            this.resultClass = null;
            this.resultClassName = null;
            this.resultDistinct = false;
            this.range = null;
            this.fromInclNo = 0L;
            this.toExclNo = Long.MAX_VALUE;
        } else {
            this.candidateClass = q.candidateClass;
            this.candidateClassName = q.candidateClassName;
            this.filter = q.filter;
            this.imports = q.imports;
            this.explicitVariables = q.explicitVariables;
            this.explicitParameters = q.explicitParameters;
            this.grouping = q.grouping;
            this.ordering = q.ordering;
            this.result = q.result;
            this.resultClass = q.resultClass;
            this.resultClassName = q.resultClassName;
            this.resultDistinct = q.resultDistinct;
            this.range = q.range;
            this.fromInclNo = q.fromInclNo;
            this.toExclNo = q.toExclNo;
            this.ignoreCache = q.ignoreCache;
        }
    }

    public AbstractJPQLQuery(ObjectManager om, String query) {
        super(om);
        new JPQLSingleStringParser(this, query).parse();
    }

    public void setResult(String result) {
        this.discardCompiled();
        this.assertIsModifiable();
        if (result == null) {
            this.result = null;
            this.resultDistinct = false;
            return;
        }
        String str = result.trim();
        if (str.toUpperCase().startsWith("DISTINCT ")) {
            this.resultDistinct = true;
            this.result = str.substring(8).trim();
        } else {
            this.resultDistinct = false;
            this.result = str;
        }
    }

    public String getSingleStringQuery() {
        if (this.singleString != null) {
            return this.singleString;
        }
        StringBuffer str = new StringBuffer();
        if (this.type == 1) {
            str.append("UPDATE " + this.update + " ");
        } else if (this.type == 2) {
            str.append("DELETE ");
        } else {
            str.append("SELECT ");
        }
        if (this.result != null) {
            if (this.resultDistinct) {
                str.append("DISTINCT ");
            }
            str.append(this.result + " ");
        }
        if (this.from != null) {
            str.append("FROM " + this.from + " ");
        }
        if (this.filter != null) {
            str.append("WHERE " + this.filter + " ");
        }
        if (this.grouping != null) {
            str.append("GROUP BY " + this.grouping + " ");
        }
        if (this.having != null) {
            str.append("HAVING " + this.having + " ");
        }
        if (this.ordering != null) {
            str.append("ORDER BY " + this.ordering + " ");
        }
        this.singleString = str.toString().trim();
        return this.singleString;
    }

    protected void compileInternal(boolean forExecute, Map parameterValues) {
        QueryCompilation cachedCompilation;
        if (this.compilation != null) {
            return;
        }
        QueryManager queryMgr = this.om.getOMFContext().getQueryManager();
        boolean caching = true;
        String cacheVal = (String)this.getExtension("datanucleus.cachedQueries");
        if (cacheVal != null && cacheVal.equalsIgnoreCase("false")) {
            caching = false;
        }
        if (caching && (cachedCompilation = queryMgr.getQueryCompilationForQuery("JPQL", this.toString())) != null) {
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021079", (Object)this.toString(), (Object)"JPQL"));
            }
            this.compilation = cachedCompilation;
            return;
        }
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug(LOCALISER.msg("021044", (Object)"JPQL", (Object)this.getSingleStringQuery(), (Object)(forExecute ? "execution" : "compile")));
        }
        JPQLCompiler compiler = new JPQLCompiler(this.om.getMetaDataManager(), this.om.getClassLoaderResolver(), this.from, this.candidateClass, this.candidateCollection, this.filter, this.getParsedImports(), this.ordering, this.result, this.grouping, this.having, this.explicitParameters);
        this.compilation = ((JavaQueryCompiler)compiler).compile(parameterValues);
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug(LOCALISER.msg("021045", (Object)"JPQL", (Object)("" + (System.currentTimeMillis() - startTime))));
        }
        if (this.subqueries != null) {
            for (Map.Entry entry : this.subqueries.entrySet()) {
                Query.SubqueryDefinition subqueryDefinition = (Query.SubqueryDefinition)entry.getValue();
                Query subquery = subqueryDefinition.getQuery();
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    startTime = System.currentTimeMillis();
                    NucleusLogger.QUERY.debug(LOCALISER.msg("021044", (Object)"JPQL", (Object)((AbstractJPQLQuery)subquery).getSingleStringQuery(), (Object)(forExecute ? "execution" : "compile")));
                }
                compiler = new JPQLCompiler(this.om.getMetaDataManager(), this.om.getClassLoaderResolver(), subquery.from, subquery.candidateClass, null, subquery.filter, this.getParsedImports(), subquery.ordering, subquery.result, subquery.grouping, subquery.having, null);
                QueryCompilation subqueryCompilation = ((JavaQueryCompiler)compiler).compile(parameterValues);
                this.compilation.addSubqueryCompilation((String)entry.getKey(), subqueryCompilation);
                if (!NucleusLogger.QUERY.isDebugEnabled()) continue;
                NucleusLogger.QUERY.debug(LOCALISER.msg("021045", (Object)"JPQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
        }
        if (caching) {
            queryMgr.addQueryCompilation("JPQL", this.toString(), this.compilation);
        }
    }

    public Class resolveClassDeclaration(String classDecl) {
        AbstractClassMetaData acmd = this.getStoreManager().getOMFContext().getMetaDataManager().getMetaDataForEntityName(classDecl);
        if (acmd != null) {
            classDecl = acmd.getFullClassName();
        }
        return super.resolveClassDeclaration(classDecl);
    }
}

