/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.sco.backed;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.sco.NullsNotAllowedException;
import org.datanucleus.sco.SCOCollection;
import org.datanucleus.sco.SCOCollectionIterator;
import org.datanucleus.sco.SCOMtoN;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.sco.queued.AddOperation;
import org.datanucleus.sco.queued.ClearOperation;
import org.datanucleus.sco.queued.QueuedOperation;
import org.datanucleus.sco.queued.RemoveAtOperation;
import org.datanucleus.sco.queued.RemoveOperation;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.scostore.ListStore;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class PriorityQueue
extends java.util.PriorityQueue
implements SCOCollection,
SCOMtoN,
Cloneable,
Serializable {
    private static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", PriorityQueue.class.getClassLoader());
    protected StateManager ownerSM;
    protected String fieldName;
    protected int fieldNumber;
    protected boolean allowNulls;
    protected ListStore backingStore;
    protected java.util.PriorityQueue delegate;
    protected boolean useCache = true;
    protected boolean isCacheLoaded = false;
    boolean queued = false;
    private ArrayList queuedOperations = null;

    public PriorityQueue(StateManager ownerSM, String fieldName) {
        this.ownerSM = ownerSM;
        this.fieldName = fieldName;
        this.allowNulls = false;
        if (ownerSM == null) {
            this.delegate = new java.util.PriorityQueue();
        }
        if (ownerSM != null) {
            AbstractMemberMetaData fmd = ownerSM.getClassMetaData().getMetaDataForMember(fieldName);
            this.fieldNumber = fmd.getAbsoluteFieldNumber();
            this.allowNulls = SCOUtils.allowNullsInContainer(this.allowNulls, fmd);
            this.queued = SCOUtils.useContainerQueueing(ownerSM);
            this.useCache = SCOUtils.useContainerCache(ownerSM, fieldName);
            if (!SCOUtils.collectionHasSerialisedElements(fmd) && fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                try {
                    ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
                    this.backingStore = (ListStore)ownerSM.getStoreManager().getBackingStoreForField(clr, fmd, java.util.PriorityQueue.class);
                }
                catch (UnsupportedOperationException ex) {
                    // empty catch block
                }
            }
            Comparator comparator = null;
            String comparatorName = null;
            if (fmd.getCollection().hasExtension("comparatorName")) {
                comparatorName = fmd.getCollection().getValueForExtension("comparatorName");
                Class comparatorCls = null;
                try {
                    comparatorCls = ownerSM.getObjectManager().getClassLoaderResolver().classForName(comparatorName);
                    comparator = (Comparator)ClassUtils.newInstance(comparatorCls, null, null);
                }
                catch (NucleusException jpe) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023012", (Object)fmd.getFullFieldName(), (Object)comparatorName));
                }
            }
            this.delegate = comparator != null ? new java.util.PriorityQueue(5, comparator) : new java.util.PriorityQueue();
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(ownerSM, fieldName, this, this.useCache, this.queued, this.allowNulls, SCOUtils.useCachedLazyLoading(ownerSM, fieldName)));
            }
        }
    }

    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Collection c = (Collection)o;
        if (c != null) {
            AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
            if (SCOUtils.collectionHasSerialisedElements(fmd) && fmd.getCollection().getElementClassMetaData() != null) {
                ObjectManager om = this.ownerSM.getObjectManager();
                for (Object pc : c) {
                    StateManager objSM = om.findStateManager(pc);
                    if (objSM != null) continue;
                    objSM = StateManagerFactory.newStateManagerForEmbedded(om, pc, false);
                    objSM.addEmbeddedOwner(this.ownerSM, this.fieldNumber);
                }
            }
            if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
                this.isCacheLoaded = true;
            }
            if (forInsert) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName, (Object)("" + c.size())));
                }
                this.addAll(c);
            } else if (forUpdate) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023008", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName, (Object)("" + c.size())));
                }
                this.clear();
                this.addAll(c);
            } else {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName, (Object)("" + c.size())));
                }
                this.delegate.clear();
                this.delegate.addAll(c);
            }
        }
    }

    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerSM, this.fieldName)) {
            this.loadFromStore();
        }
    }

    public Object getValue() {
        this.loadFromStore();
        return this.delegate;
    }

    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    public boolean isLoaded() {
        return this.useCache ? this.isCacheLoaded : false;
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023006", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName));
            }
            this.delegate.clear();
            Iterator iter = this.backingStore.iterator(this.ownerSM);
            while (iter.hasNext()) {
                this.delegate.add(iter.next());
            }
            this.isCacheLoaded = true;
        }
    }

    public void flush() {
        if (this.queued && this.queuedOperations != null) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023005", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName));
            }
            for (QueuedOperation op : this.queuedOperations) {
                op.perform(this.backingStore, this.ownerSM);
            }
            this.queuedOperations.clear();
            this.queuedOperations = null;
        }
    }

    protected void addQueuedOperation(QueuedOperation op) {
        if (this.queuedOperations == null) {
            this.queuedOperations = new ArrayList();
        }
        this.queuedOperations.add(op);
    }

    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedElement(this.ownerSM, element, fieldNumber, value);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOwner() {
        return this.ownerSM != null ? this.ownerSM.getObject() : null;
    }

    public synchronized void unsetOwner() {
        if (this.ownerSM != null) {
            this.ownerSM = null;
            this.fieldName = null;
            this.backingStore = null;
        }
    }

    public void makeDirty() {
        if (this.ownerSM != null) {
            this.ownerSM.getObjectManager().getApiAdapter().makeFieldDirty(this.ownerSM.getObject(), this.fieldName);
        }
    }

    public Object detachCopy(FetchPlanState state) {
        java.util.PriorityQueue detached = new java.util.PriorityQueue();
        SCOUtils.detachCopyForCollection(this.ownerSM, this.toArray(), state, detached);
        return detached;
    }

    public void attachCopy(Object value) {
        Collection c = (Collection)value;
        AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(fmd);
        HashSet attachedElements = new HashSet(c.size());
        SCOUtils.attachCopyForCollection(this.ownerSM, c.toArray(), attachedElements, elementsWithoutIdentity);
        SCOUtils.updateCollectionWithCollectionElements(this, attachedElements);
    }

    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return null;
    }

    public Comparator comparator() {
        return this.delegate.comparator();
    }

    public synchronized boolean contains(Object element) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.contains(element);
        }
        if (this.backingStore != null) {
            return this.backingStore.contains(this.ownerSM, element);
        }
        return this.delegate.contains(element);
    }

    public synchronized boolean containsAll(Collection c) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            HashSet h = new HashSet(c);
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                h.remove(iter.next());
            }
            return h.isEmpty();
        }
        return this.delegate.containsAll(c);
    }

    public synchronized boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set c = (Set)o;
        return c.size() == this.size() && this.containsAll((Collection)c);
    }

    public synchronized int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.hashCode();
    }

    public synchronized boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized Iterator iterator() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOCollectionIterator(this, this.ownerSM, this.delegate, this.backingStore, this.useCache);
    }

    public synchronized Object peek() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.get(this.ownerSM, 0);
        }
        return this.delegate.peek();
    }

    public synchronized int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.size(this.ownerSM);
        }
        return this.delegate.size();
    }

    public synchronized Object[] toArray() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM);
        }
        return this.delegate.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM, a);
        }
        return this.delegate.toArray(a);
    }

    public String toString() {
        StringBuffer s = new StringBuffer("[");
        int i = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (i > 0) {
                s.append(',');
            }
            s.append(iter.next());
            ++i;
        }
        s.append("]");
        return s.toString();
    }

    public synchronized boolean add(Object element) {
        if (element == null && !this.allowNulls) {
            throw new NullsNotAllowedException(this.ownerSM, this.fieldName);
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (this.queued && !this.ownerSM.getObjectManager().isFlushing()) {
                this.addQueuedOperation(new AddOperation(element));
            } else {
                try {
                    this.backingStore.add(this.ownerSM, element, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"add", (Object)this.fieldName, (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.add(element);
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public synchronized boolean addAll(Collection elements) {
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (this.queued && !this.ownerSM.getObjectManager().isFlushing()) {
                Iterator iter = elements.iterator();
                while (iter.hasNext()) {
                    this.addQueuedOperation(new AddOperation(iter.next()));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.addAll(this.ownerSM, elements, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"addAll", (Object)this.fieldName, (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.addAll(elements);
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public synchronized void clear() {
        this.makeDirty();
        if (this.backingStore != null) {
            if (this.queued && !this.ownerSM.getObjectManager().isFlushing()) {
                this.addQueuedOperation(new ClearOperation());
            } else {
                this.backingStore.clear(this.ownerSM);
            }
        }
        this.delegate.clear();
    }

    public synchronized boolean offer(Object element) {
        return this.add(element);
    }

    public synchronized Object poll() {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        Object delegateObject = this.delegate.poll();
        Object backingObject = null;
        if (this.backingStore != null) {
            if (this.queued && !this.ownerSM.getObjectManager().isFlushing()) {
                this.addQueuedOperation(new RemoveAtOperation(0));
            } else {
                try {
                    backingObject = this.backingStore.remove(this.ownerSM, 0, size);
                }
                catch (NucleusDataStoreException dse) {
                    backingObject = null;
                }
            }
        }
        return this.backingStore != null ? backingObject : (Object)delegateObject;
    }

    public synchronized boolean remove(Object element) {
        return this.remove(element, true);
    }

    public boolean remove(Object element, boolean allowCascadeDelete) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        boolean contained = this.delegate.contains(element);
        boolean delegateSuccess = this.delegate.remove(element);
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (this.queued && !this.ownerSM.getObjectManager().isFlushing()) {
                backingSuccess = contained;
                if (backingSuccess) {
                    this.addQueuedOperation(new RemoveOperation(element, allowCascadeDelete));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.remove(this.ownerSM, element, size, allowCascadeDelete);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"remove", (Object)this.fieldName, (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public synchronized boolean removeAll(Collection elements) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            int size;
            boolean backingSuccess = true;
            int n = size = this.useCache ? this.delegate.size() : -1;
            if (this.queued && !this.ownerSM.getObjectManager().isFlushing()) {
                backingSuccess = false;
                for (Object element : elements) {
                    if (!this.contains(element)) continue;
                    backingSuccess = true;
                    this.addQueuedOperation(new RemoveOperation(element));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.removeAll(this.ownerSM, elements, size);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"removeAll", (Object)this.fieldName, (Object)dse));
                    backingSuccess = false;
                }
            }
            this.delegate.removeAll(elements);
            return backingSuccess;
        }
        return this.delegate.removeAll(elements);
    }

    public synchronized boolean retainAll(Collection c) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (c.contains(element)) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new java.util.PriorityQueue(this.delegate);
        }
        return new java.util.PriorityQueue(this.delegate);
    }
}

