/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.expression;

import java.util.List;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.PrimaryExpressionIsClassLiteralException;
import org.datanucleus.query.symbol.PropertySymbol;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.util.StringUtils;

public class PrimaryExpression
extends Expression {
    SymbolTable symtbl;
    List tuples;

    public PrimaryExpression(SymbolTable symtbl, List tuples) {
        this.symtbl = symtbl;
        this.tuples = tuples;
    }

    public PrimaryExpression(SymbolTable symtbl, Expression left, List tuples) {
        this.symtbl = symtbl;
        this.left = left;
        this.tuples = tuples;
    }

    public String getId() {
        StringBuffer id = new StringBuffer();
        for (int i = 0; i < this.tuples.size(); ++i) {
            if (id.length() > 0) {
                id.append('.');
            }
            id.append((String)this.tuples.get(i));
        }
        return id.toString();
    }

    public List getTuples() {
        return this.tuples;
    }

    public Symbol bind() {
        if (this.left != null) {
            this.left.bind();
        }
        if (this.symtbl.hasSymbol(this.getId())) {
            this.symbol = this.symtbl.getSymbol(this.getId());
        } else {
            if (this.left != null) {
                return null;
            }
            try {
                Class symbolType = this.symtbl.getType(this.tuples);
                this.symbol = new PropertySymbol(this.getId(), symbolType);
            }
            catch (NucleusUserException nue) {
                StringBuffer str = new StringBuffer();
                for (String tuple : this.tuples) {
                    if (str.length() > 0) {
                        str.append('.');
                    }
                    str.append(tuple);
                }
                try {
                    Class cls = this.symtbl.getClassLoaderResolver().classForName(str.toString());
                    throw new PrimaryExpressionIsClassLiteralException(cls);
                }
                catch (ClassNotResolvedException cnre) {
                    throw nue;
                }
            }
        }
        return this.symbol;
    }

    public String toString() {
        if (this.left != null) {
            return "PrimaryExpression {" + this.left + "." + StringUtils.collectionToString(this.tuples) + "}";
        }
        return "PrimaryExpression {" + StringUtils.collectionToString(this.tuples) + "}";
    }
}

