/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.evaluator.memory;

import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.evaluator.memory.InMemoryExpressionEvaluator;
import org.datanucleus.query.evaluator.memory.InvocationEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.util.Localiser;

public class StringSubstringMethodEvaluator
implements InvocationEvaluator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());

    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        String method = expr.getOperation();
        if (invokedValue == null) {
            return null;
        }
        if (!(invokedValue instanceof String)) {
            throw new NucleusException(LOCALISER.msg("021011", (Object)method, (Object)invokedValue.getClass().getName()));
        }
        int arg1 = -1;
        int arg2 = -1;
        Literal param1 = (Literal)expr.getParameters().get(0);
        if (param1.getLiteral() instanceof Number) {
            arg1 = ((Number)param1.getLiteral()).intValue();
        }
        String result = null;
        if (expr.getParameters().size() == 2) {
            Literal param2 = (Literal)expr.getParameters().get(1);
            if (param2.getLiteral() instanceof Number) {
                arg2 = ((Number)param2.getLiteral()).intValue();
            }
            result = ((String)invokedValue).substring(arg1, arg2);
        } else {
            result = ((String)invokedValue).substring(arg1);
        }
        return result;
    }

    public boolean supportsType(Class cls) {
        if (cls == null) {
            return false;
        }
        return String.class.isAssignableFrom(cls);
    }
}

