/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.evaluator.memory;

import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.evaluator.memory.InMemoryExpressionEvaluator;
import org.datanucleus.query.evaluator.memory.InvocationEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.util.Localiser;

public class StringMatchesMethodEvaluator
implements InvocationEvaluator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());

    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        String method = expr.getOperation();
        if (!(invokedValue instanceof String)) {
            throw new NucleusException(LOCALISER.msg("021011", (Object)method, (Object)invokedValue.getClass().getName()));
        }
        Literal param = (Literal)expr.getParameters().get(0);
        String arg = null;
        if (param.getLiteral() instanceof String) {
            arg = (String)param.getLiteral();
        } else if (param.getLiteral() instanceof Character) {
            arg = ((Character)param.getLiteral()).toString();
        } else if (param.getLiteral() instanceof Number) {
            arg = ((Number)param.getLiteral()).toString();
        }
        return ((String)invokedValue).matches(arg) ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean supportsType(Class cls) {
        if (cls == null) {
            return false;
        }
        return String.class.isAssignableFrom(cls);
    }
}

