/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.evaluator.memory;

import java.util.Collection;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.evaluator.memory.InMemoryExpressionEvaluator;
import org.datanucleus.query.evaluator.memory.InvocationEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class CollectionContainsMethodEvaluator
implements InvocationEvaluator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());

    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        String method = expr.getOperation();
        if (invokedValue == null) {
            return Boolean.FALSE;
        }
        if (!(invokedValue instanceof Collection)) {
            throw new NucleusException(LOCALISER.msg("021011", (Object)method, (Object)invokedValue.getClass().getName()));
        }
        Object param = expr.getParameters().get(0);
        if (param instanceof Literal) {
            Object paramValue = ((Literal)param).getLiteral();
            return ((Collection)invokedValue).contains(paramValue) ? Boolean.TRUE : Boolean.FALSE;
        }
        NucleusLogger.QUERY.debug(">> contains(" + param + ") NOT YET IMPLEMENTED");
        throw new NucleusException("Dont currently support use of contains(non-Literal)");
    }

    public boolean supportsType(Class cls) {
        if (cls == null) {
            return false;
        }
        return Collection.class.isAssignableFrom(cls);
    }
}

