/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.compiler.Parser;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionCompiler;
import org.datanucleus.query.node.Node;
import org.datanucleus.query.symbol.PropertySymbol;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolResolver;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Imports;
import org.datanucleus.util.NucleusLogger;

public abstract class JavaQueryCompiler
implements SymbolResolver {
    protected final MetaDataManager metaDataManager;
    protected final ClassLoaderResolver clr;
    protected Class candidateClass;
    protected String candidateAlias = "this";
    protected String from;
    protected Collection candidates;
    protected String filter;
    protected String ordering;
    protected String parameters;
    protected String variables;
    protected String grouping;
    protected String having;
    protected String result;
    protected Imports imports;
    protected SymbolTable symtbl;
    protected Parser parser;

    public JavaQueryCompiler(MetaDataManager metaDataManager, ClassLoaderResolver clr, String from, Class candidateClass, Collection candidates, String filter, Imports imports, String ordering, String result, String grouping, String having, String params, String variables) {
        this.metaDataManager = metaDataManager;
        this.clr = clr;
        this.from = from;
        this.candidateClass = candidateClass;
        this.candidates = candidates;
        this.filter = filter;
        this.result = result;
        this.grouping = grouping;
        this.having = having;
        this.ordering = ordering;
        this.parameters = params;
        this.variables = variables;
        this.imports = imports;
        if (imports == null) {
            this.imports = new Imports();
        }
    }

    public abstract QueryCompilation compile(Map var1);

    public void compileCandidatesParametersVariables(Map parameters) {
        this.compileCandidates();
        this.compileVariables();
        this.compileParameters();
        if (parameters != null) {
            for (Map.Entry entry : parameters.entrySet()) {
                Symbol symbol = null;
                if (entry.getKey() instanceof Integer) {
                    Integer paramPos = (Integer)entry.getKey();
                    String paramName = "" + paramPos;
                    symbol = this.symtbl.getSymbol(paramName);
                    if (symbol == null) {
                        if (entry.getValue() == null) {
                            this.symtbl.addSymbol(new PropertySymbol(paramName));
                        } else {
                            this.symtbl.addSymbol(new PropertySymbol(paramName, entry.getValue().getClass()));
                        }
                        symbol = this.symtbl.getSymbol(paramName);
                    } else if (symbol.getValueType() == null && entry.getValue() != null) {
                        symbol.setValueType(entry.getValue().getClass());
                    }
                } else {
                    String paramName = (String)entry.getKey();
                    symbol = this.symtbl.getSymbol(paramName);
                    if (symbol == null) {
                        if (entry.getValue() == null) {
                            this.symtbl.addSymbol(new PropertySymbol(paramName));
                        } else {
                            this.symtbl.addSymbol(new PropertySymbol(paramName, entry.getValue().getClass()));
                        }
                        symbol = this.symtbl.getSymbol(paramName);
                    } else if (symbol.getValueType() == null && entry.getValue() != null) {
                        symbol.setValueType(entry.getValue().getClass());
                    }
                }
                symbol.setValue(entry.getValue());
            }
        }
    }

    protected Expression[] compileFrom() {
        if (this.from == null) {
            return null;
        }
        Node[] node = this.parser.compileFrom(this.from);
        Expression[] expr = new Expression[node.length];
        for (int i = 0; i < node.length; ++i) {
            String className = (String)node[i].getNodeValue();
            String classAlias = null;
            Class cls = this.imports.resolveClassDeclaration(className, this.clr, null);
            List children = node[i].getChildNodes();
            for (int j = 0; j < children.size(); ++j) {
                Node child = (Node)children.get(j);
                if (child.getNodeType() != 2) continue;
                classAlias = (String)child.getNodeValue();
            }
            if (classAlias != null && this.symtbl.getSymbol(classAlias) == null) {
                this.symtbl.addSymbol(new PropertySymbol(classAlias, cls));
            }
            if (i == 0) {
                this.candidateClass = cls;
                this.candidateAlias = classAlias;
            }
            for (Node childNode : node[i].getChildNodes()) {
                if (childNode.getNodeType() != 4) continue;
                childNode.getFirstChild();
                Node aliasNode = childNode.getNextChild();
                if (aliasNode.getNodeType() != 2) continue;
                this.symtbl.addSymbol(new PropertySymbol((String)aliasNode.getNodeValue()));
            }
            ExpressionCompiler comp = new ExpressionCompiler();
            comp.setSymbolTable(this.symtbl);
            expr[i] = comp.compileFromExpression(node[i]);
            if (expr[i] == null) continue;
            expr[i].bind();
        }
        return expr;
    }

    private void compileCandidates() {
        if (this.symtbl.getSymbol(this.candidateAlias) == null) {
            PropertySymbol symbol = new PropertySymbol(this.candidateAlias, this.candidateClass);
            symbol.setValue(this.candidates);
            this.symtbl.addSymbol(symbol);
        }
    }

    public Expression compileFilter() {
        if (this.filter != null) {
            Node node = this.parser.compile(this.filter);
            ExpressionCompiler comp = new ExpressionCompiler();
            comp.setSymbolTable(this.symtbl);
            Expression compiledExpression = comp.compileExpression(node);
            compiledExpression.bind();
            return compiledExpression;
        }
        return null;
    }

    public Expression[] compileResult() {
        if (this.result == null) {
            return null;
        }
        Node[] node = this.parser.compileTupple(this.result);
        Expression[] expr = new Expression[node.length];
        for (int i = 0; i < node.length; ++i) {
            ExpressionCompiler comp = new ExpressionCompiler();
            comp.setSymbolTable(this.symtbl);
            expr[i] = comp.compileExpression(node[i]);
        }
        return expr;
    }

    public Expression[] compileGrouping() {
        if (this.grouping == null) {
            return null;
        }
        Node[] node = this.parser.compileTupple(this.grouping);
        Expression[] expr = new Expression[node.length];
        for (int i = 0; i < node.length; ++i) {
            ExpressionCompiler comp = new ExpressionCompiler();
            comp.setSymbolTable(this.symtbl);
            expr[i] = comp.compileExpression(node[i]);
        }
        return expr;
    }

    public Expression compileHaving() {
        if (this.having == null) {
            return null;
        }
        Node node = this.parser.compile(this.having);
        ExpressionCompiler comp = new ExpressionCompiler();
        comp.setSymbolTable(this.symtbl);
        Expression expr = comp.compileExpression(node);
        return expr;
    }

    private void compileVariables() {
        if (this.variables == null) {
            return;
        }
        Node[][] node = this.parser.compileVariables(this.variables);
        for (int i = 0; i < node.length; ++i) {
            String varName = (String)node[i][1].getNodeValue();
            if (this.symtbl.getSymbol(varName) != null) {
                NucleusLogger.QUERY.warn(">> compileVariables param=" + varName + " but symbol already exists in table");
            }
            PropertySymbol sym = new PropertySymbol(varName, this.imports.resolveClassDeclaration(node[i][0].getNodeChildId(), this.clr, null));
            sym.setType(2);
            this.symtbl.addSymbol(sym);
        }
    }

    private void compileParameters() {
        if (this.parameters == null) {
            return;
        }
        Node[][] node = this.parser.compileParameters(this.parameters);
        for (int i = 0; i < node.length; ++i) {
            String paramName = (String)node[i][1].getNodeValue();
            if (this.symtbl.getSymbol(paramName) != null) {
                NucleusLogger.QUERY.warn(">> compileParameters param=" + paramName + " but symbol already exists in table");
            }
            PropertySymbol sym = new PropertySymbol(paramName, this.imports.resolveClassDeclaration(node[i][0].getNodeChildId(), this.clr, null));
            sym.setType(1);
            this.symtbl.addSymbol(sym);
        }
    }

    public Expression[] compileOrdering() {
        if (this.ordering == null) {
            return null;
        }
        Node[] node = this.parser.compileOrder(this.ordering);
        Expression[] expr = new Expression[node.length];
        for (int i = 0; i < node.length; ++i) {
            ExpressionCompiler comp = new ExpressionCompiler();
            comp.setSymbolTable(this.symtbl);
            expr[i] = comp.compileOrderExpression(node[i]);
            expr[i].bind();
        }
        return expr;
    }

    public Class getType(List tuples) {
        Class type = null;
        Symbol symbol = this.symtbl.getSymbol((String)tuples.get(0));
        if (symbol != null) {
            type = symbol.getValueType();
            for (int i = 1; i < tuples.size(); ++i) {
                type = this.getType(type, (String)tuples.get(i));
            }
        } else {
            symbol = this.symtbl.getSymbol(this.candidateAlias);
            type = symbol.getValueType();
            for (int i = 0; i < tuples.size(); ++i) {
                type = this.getType(type, (String)tuples.get(i));
            }
        }
        return type;
    }

    Class getType(Class cls, String fieldName) {
        AbstractClassMetaData acmd = this.metaDataManager.getMetaDataForClass(cls, this.clr);
        if (acmd != null) {
            AbstractMemberMetaData fmd = acmd.getMetaDataForMember(fieldName);
            if (fmd == null) {
                throw new NucleusUserException("Cannot access field " + fieldName + " on type " + cls.getName());
            }
            return fmd.getType();
        }
        Field field = ClassUtils.getFieldForClass(cls, fieldName);
        if (field == null) {
            throw new NucleusUserException("Cannot access field " + fieldName + " on type " + cls.getName());
        }
        return field.getType();
    }
}

