/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.compiler.Lexer;
import org.datanucleus.query.compiler.Parser;
import org.datanucleus.query.node.Node;
import org.datanucleus.query.node.ParameterNode;
import org.datanucleus.store.query.QueryCompilerSyntaxException;

public class JPQLParser
implements Parser {
    private Lexer p;
    private Stack<Node> stack = new Stack();
    private static String paramPrefixes = ":?";
    int parameterPosition = 0;

    public JPQLParser(Map options) {
    }

    public Node compile(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        return this.compileExpression();
    }

    public Node compileVariable(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        if (!this.compileIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
        }
        if (!this.compileIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
        }
        Node nodeVariable = this.stack.pop();
        Node nodeType = this.stack.pop();
        nodeType.appendChildNode(nodeVariable);
        return nodeType;
    }

    public Node[] compileFrom(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        return this.compileFromExpression();
    }

    public Node[] compileOrder(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        return this.compileOrderExpression();
    }

    public Node[] compileTupple(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            this.compileExpression();
            Node expr = this.stack.pop();
            nodes.add(expr);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    public Node[][] compileVariables(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        do {
            this.compilePrimary();
            if (this.stack.isEmpty()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            if (!this.compileIdentifier()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            Node nodeVariable = this.stack.pop();
            Node nodeType = this.stack.pop();
            nodes.add(new Node[]{nodeType, nodeVariable});
        } while (this.p.parseString(";"));
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    public Node[][] compileParameters(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        do {
            this.compilePrimary();
            if (this.stack.isEmpty()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            if (!this.compileIdentifier()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            Node nodeVariable = this.stack.pop();
            Node nodeType = this.stack.pop();
            nodes.add(new Node[]{nodeType, nodeVariable});
        } while (this.p.parseString(","));
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    private Node[] compileFromExpression() {
        String candidateClassName = null;
        String candidateAlias = null;
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            if (this.p.parseStringIgnoreCase("IN")) {
                if (!this.p.parseChar('(')) {
                    throw new QueryCompilerSyntaxException("Expected: '(' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
                }
                String name = this.p.parseIdentifier();
                if (this.p.nextIsDot()) {
                    this.p.parseChar('.');
                    name = name + ".";
                    name = name + this.p.parseName();
                }
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("Expected: ')' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
                }
                this.p.parseStringIgnoreCase("AS");
                String alias = this.p.parseIdentifier();
                Node classNode = new Node(6, candidateClassName);
                Node classAliasNode = new Node(2, candidateAlias);
                classNode.insertChildNode(classAliasNode);
                this.stack.push(classNode);
                Node joinNode = new Node(4, "JOIN_INNER");
                Node joinedToNode = new Node(3, name);
                joinNode.appendChildNode(joinedToNode);
                Node joinAliasNode = new Node(2, alias);
                joinNode.appendChildNode(joinAliasNode);
                classNode.appendChildNode(joinNode);
                this.compileFromJoinExpression();
                nodes.add(classNode);
                continue;
            }
            this.compileExpression();
            Node id = this.stack.pop();
            String className = id.getNodeValue().toString();
            while (id.getChildNodes().size() > 0) {
                id = id.getFirstChild();
                className = className + "." + id.getNodeValue().toString();
            }
            String alias = this.p.parseIdentifier();
            if (alias != null && alias.equalsIgnoreCase("AS")) {
                alias = this.p.parseIdentifier();
            }
            if (candidateClassName == null) {
                candidateClassName = className;
                candidateAlias = alias;
            }
            Node classNode = new Node(6, className);
            Node aliasNode = new Node(2, alias);
            classNode.insertChildNode(aliasNode);
            this.stack.push(classNode);
            this.compileFromJoinExpression();
            nodes.add(classNode);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    private void compileFromJoinExpression() {
        Node candidateNode = this.stack.pop();
        boolean moreJoins = true;
        while (moreJoins) {
            boolean leftJoin = false;
            boolean innerJoin = false;
            if (this.p.parseStringIgnoreCase("INNER")) {
                innerJoin = true;
            } else if (this.p.parseStringIgnoreCase("LEFT")) {
                this.p.parseStringIgnoreCase("OUTER");
                leftJoin = true;
            }
            if (this.p.parseStringIgnoreCase("JOIN")) {
                String id;
                boolean fetch = false;
                if (this.p.parseStringIgnoreCase("FETCH")) {
                    fetch = true;
                }
                String name = id = this.p.parseIdentifier();
                if (this.p.nextIsDot()) {
                    this.p.parseChar('.');
                    name = name + ".";
                    name = name + this.p.parseName();
                }
                this.p.parseStringIgnoreCase("AS");
                String alias = this.p.parseName();
                Node joinedNode = new Node(3, name);
                String joinType = "JOIN_INNER";
                if (innerJoin && fetch) {
                    joinType = "JOIN_INNER_FETCH";
                } else if (leftJoin) {
                    joinType = fetch ? "JOIN_OUTER_FETCH" : "JOIN_OUTER";
                }
                Node joinNode = new Node(4, joinType);
                joinNode.appendChildNode(joinedNode);
                Node joinedAliasNode = new Node(2, alias);
                joinNode.appendChildNode(joinedAliasNode);
                candidateNode.appendChildNode(joinNode);
                continue;
            }
            if (innerJoin || leftJoin) {
                throw new NucleusUserException("Expected JOIN after INNER/LEFT keyword at" + this.p.remaining());
            }
            moreJoins = false;
        }
        this.stack.push(candidateNode);
    }

    private Node[] compileOrderExpression() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            Node expr;
            this.compileExpression();
            if (this.p.parseStringIgnoreCase("asc")) {
                expr = new Node(4, "ascending");
                this.stack.push(expr);
            } else if (this.p.parseStringIgnoreCase("desc")) {
                expr = new Node(4, "descending");
                this.stack.push(expr);
            }
            expr = new Node(4, "order");
            expr.insertChildNode(this.stack.pop());
            if (!this.stack.empty()) {
                expr.insertChildNode(this.stack.pop());
            }
            nodes.add(expr);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    private Node compileExpression() {
        this.compileOrExpression();
        return this.stack.peek();
    }

    private void compileOrExpression() {
        this.compileAndExpression();
        while (this.p.parseStringIgnoreCase("OR")) {
            this.compileAndExpression();
            Node expr = new Node(4, "||");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void compileAndExpression() {
        this.compileRelationalExpression();
        while (this.p.parseStringIgnoreCase("AND")) {
            this.compileRelationalExpression();
            Node expr = new Node(4, "&&");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void compileRelationalExpression() {
        this.compileAdditiveExpression();
        while (true) {
            Node betweenNode;
            Node rightNode;
            Node leftNode;
            Node upperNode;
            Node inputNode;
            Node expr;
            if (this.p.parseString("=")) {
                this.compileAdditiveExpression();
                expr = new Node(4, "==");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseString("<>")) {
                this.compileAdditiveExpression();
                expr = new Node(4, "!=");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseStringIgnoreCase("NOT")) {
                if (this.p.parseStringIgnoreCase("BETWEEN")) {
                    inputNode = this.stack.pop();
                    this.compileAdditiveExpression();
                    Node lowerNode = this.stack.pop();
                    if (this.p.parseStringIgnoreCase("AND")) {
                        this.compileAdditiveExpression();
                        upperNode = this.stack.pop();
                        leftNode = new Node(4, "<");
                        leftNode.appendChildNode(inputNode);
                        leftNode.appendChildNode(lowerNode);
                        rightNode = new Node(4, ">");
                        rightNode.appendChildNode(inputNode);
                        rightNode.appendChildNode(upperNode);
                        betweenNode = new Node(4, "&&");
                        betweenNode.appendChildNode(leftNode);
                        betweenNode.appendChildNode(rightNode);
                        this.stack.push(betweenNode);
                        continue;
                    }
                    throw new NucleusUserException("Query has BETWEEN keyword with no AND clause");
                }
                if (this.p.parseStringIgnoreCase("LIKE")) {
                    this.compileLikeExpression();
                    Node notNode = new Node(4, "!");
                    notNode.insertChildNode(this.stack.pop());
                    this.stack.push(notNode);
                    continue;
                }
                if (this.p.parseStringIgnoreCase("IN")) {
                    this.compileInExpression(true);
                    continue;
                }
                if (this.p.parseStringIgnoreCase("MEMBER")) {
                    this.compileMemberExpression(true);
                    continue;
                }
                throw new NucleusException("Unsupported query syntax NOT followed by unsupported keyword");
            }
            if (this.p.parseStringIgnoreCase("BETWEEN")) {
                inputNode = this.stack.pop();
                this.compileAdditiveExpression();
                Node lowerNode = this.stack.pop();
                if (this.p.parseStringIgnoreCase("AND")) {
                    this.compileAdditiveExpression();
                    upperNode = this.stack.pop();
                    leftNode = new Node(4, ">=");
                    leftNode.appendChildNode(inputNode);
                    leftNode.appendChildNode(lowerNode);
                    rightNode = new Node(4, "<=");
                    rightNode.appendChildNode(inputNode);
                    rightNode.appendChildNode(upperNode);
                    betweenNode = new Node(4, "&&");
                    betweenNode.appendChildNode(rightNode);
                    betweenNode.appendChildNode(leftNode);
                    this.stack.push(betweenNode);
                    continue;
                }
                throw new NucleusUserException("Query has BETWEEN keyword with no AND clause");
            }
            if (this.p.parseStringIgnoreCase("LIKE")) {
                this.compileLikeExpression();
                continue;
            }
            if (this.p.parseStringIgnoreCase("IN")) {
                this.compileInExpression(false);
                continue;
            }
            if (this.p.parseStringIgnoreCase("MEMBER")) {
                this.compileMemberExpression(false);
                continue;
            }
            if (this.p.parseStringIgnoreCase("IS")) {
                Node isNode;
                inputNode = this.stack.pop();
                boolean not = false;
                if (this.p.parseStringIgnoreCase("NOT")) {
                    not = true;
                }
                if (this.p.parseStringIgnoreCase("NULL")) {
                    isNode = new Node(4, not ? "!=" : "==");
                    Node compareNode = new Node(0, null);
                    isNode.insertChildNode(compareNode);
                    isNode.insertChildNode(inputNode);
                    this.stack.push(isNode);
                    continue;
                }
                if (this.p.parseStringIgnoreCase("EMPTY")) {
                    isNode = new Node(1, "isEmpty");
                    inputNode.insertChildNode(isNode);
                    if (not) {
                        Node notExpr = new Node(4, "!");
                        notExpr.insertChildNode(inputNode);
                        this.stack.push(notExpr);
                        continue;
                    }
                    this.stack.push(inputNode);
                    continue;
                }
                throw new NucleusException("Encountered IS " + (not ? "NOT " : " ") + " that should be followed by NULL | EMPTY but isnt");
            }
            if (this.p.parseString("<=")) {
                this.compileAdditiveExpression();
                expr = new Node(4, "<=");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseString(">=")) {
                this.compileAdditiveExpression();
                expr = new Node(4, ">=");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('<')) {
                this.compileAdditiveExpression();
                expr = new Node(4, "<");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('>')) {
                this.compileAdditiveExpression();
                expr = new Node(4, ">");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseStringIgnoreCase("instanceof")) break;
            this.compileAdditiveExpression();
            expr = new Node(4, "instanceof");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void compileLikeExpression() {
        Node inputNode = this.stack.pop();
        this.compileAdditiveExpression();
        Node likeExprNode = this.stack.pop();
        if (this.p.parseStringIgnoreCase("ESCAPE")) {
            this.compileAdditiveExpression();
            this.stack.pop();
            Node likeNode = new Node(4, "LIKE");
            likeNode.appendChildNode(inputNode);
            likeNode.appendChildNode(likeExprNode);
            this.stack.push(likeNode);
        } else {
            Node likeNode = new Node(4, "LIKE");
            likeNode.appendChildNode(inputNode);
            likeNode.appendChildNode(likeExprNode);
            this.stack.push(likeNode);
        }
    }

    private void compileInExpression(boolean not) {
        Node inputNode = this.stack.pop();
        if (!this.p.parseChar('(')) {
            throw new NucleusException("IN subquery not yet implemented for generic JPQL compiler");
        }
        Node inNode = null;
        do {
            this.compilePrimary();
            if (this.stack.peek() == null) {
                throw new QueryCompilerSyntaxException("Expected literal|parameter but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
            }
            Node valueNode = this.stack.pop();
            Node compareNode = new Node(4, not ? "!=" : "==");
            compareNode.appendChildNode(inputNode);
            compareNode.appendChildNode(valueNode);
            if (inNode == null) {
                inNode = compareNode;
                continue;
            }
            Node newInNode = new Node(4, not ? "&&" : "||");
            newInNode.appendChildNode(inNode);
            newInNode.appendChildNode(compareNode);
            inNode = newInNode;
        } while (this.p.parseChar(','));
        if (!this.p.parseChar(')')) {
            throw new QueryCompilerSyntaxException("Expected: ')' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
        }
        this.stack.push(inNode);
    }

    private void compileMemberExpression(boolean not) {
        Node inputNode = this.stack.pop();
        this.p.parseStringIgnoreCase("OF");
        this.compilePrimary();
        Node containerNode = this.stack.peek();
        if (not) {
            Node notNode = new Node(4, "!");
            this.stack.pop();
            notNode.insertChildNode(containerNode);
            this.stack.push(notNode);
        }
        Node containsNode = new Node(1, "contains");
        containsNode.insertChildNode(inputNode);
        containerNode.appendChildNode(containsNode);
    }

    protected void compileAdditiveExpression() {
        this.compileMultiplicativeExpression();
        while (true) {
            Node expr;
            if (this.p.parseChar('+')) {
                this.compileMultiplicativeExpression();
                expr = new Node(4, "+");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseChar('-')) break;
            this.compileMultiplicativeExpression();
            expr = new Node(4, "-");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void compileMultiplicativeExpression() {
        this.compileUnaryExpression();
        while (true) {
            Node expr;
            if (this.p.parseChar('*')) {
                this.compileMultiplicativeExpression();
                expr = new Node(4, "*");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('/')) {
                this.compileMultiplicativeExpression();
                expr = new Node(4, "/");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseChar('%')) break;
            this.compileMultiplicativeExpression();
            expr = new Node(4, "%");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void compileUnaryExpression() {
        if (this.p.parseString("++")) {
            throw new NucleusUserException("Unsupported operator '++'");
        }
        if (this.p.parseString("--")) {
            throw new NucleusUserException("Unsupported operator '--'");
        }
        if (this.p.parseChar('+')) {
            this.compileUnaryExpression();
        } else if (this.p.parseChar('-')) {
            this.compileUnaryExpression();
            Node expr = new Node(4, "-");
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        } else {
            this.compileUnaryExpressionNotPlusMinus();
        }
    }

    protected void compileUnaryExpressionNotPlusMinus() {
        if (this.p.parseStringIgnoreCase("NOT")) {
            this.compileUnaryExpression();
            Node expr = new Node(4, "!");
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        } else {
            this.compilePrimary();
        }
    }

    protected void compilePrimary() {
        if (this.p.parseStringIgnoreCase("CURRENT_DATE")) {
            Node expr = new Node(1, "CURRENT_DATE");
            this.stack.push(expr);
            return;
        }
        if (this.p.parseStringIgnoreCase("CURRENT_TIMESTAMP")) {
            Node expr = new Node(1, "CURRENT_TIMESTAMP");
            this.stack.push(expr);
            return;
        }
        if (this.p.parseStringIgnoreCase("CURRENT_TIME")) {
            Node expr = new Node(1, "CURRENT_TIME");
            this.stack.push(expr);
            return;
        }
        if (this.p.parseStringIgnoreCase("DISTINCT")) {
            Node distinctNode = new Node(4, "DISTINCT");
            this.compileIdentifier();
            Node identifierNode = this.stack.pop();
            distinctNode.appendChildNode(identifierNode);
            this.stack.push(distinctNode);
            return;
        }
        if (this.compileCreator()) {
            return;
        }
        if (this.compileLiteral()) {
            return;
        }
        if (this.compileMethod()) {
            return;
        }
        if (this.p.parseChar('(')) {
            this.compileExpression();
            if (!this.p.parseChar(')')) {
                throw new QueryCompilerSyntaxException("expected ')'", this.p.getIndex(), this.p.getInput());
            }
            return;
        }
        if (!this.compileIdentifier()) {
            throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
        }
        int size = this.stack.size();
        while (this.p.parseChar('.')) {
            if (this.compileMethod() || this.compileIdentifier()) continue;
            throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
        }
        while (this.stack.size() > size) {
            Node top = this.stack.pop();
            Node peek = this.stack.peek();
            peek.insertChildNode(top);
        }
    }

    private boolean compileCreator() {
        if (this.p.parseStringIgnoreCase("new")) {
            int size = this.stack.size();
            if (!this.compileMethod()) {
                if (!this.compileIdentifier()) {
                    throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
                }
                while (this.p.parseChar('.')) {
                    if (this.compileMethod() || this.compileIdentifier()) continue;
                    throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
                }
            }
            while (this.stack.size() - 1 > size) {
                Node top = this.stack.pop();
                Node peek = this.stack.peek();
                peek.insertChildNode(top);
            }
            Node expr = this.stack.pop();
            Node newExpr = new Node(5);
            newExpr.insertChildNode(expr);
            this.stack.push(newExpr);
            return true;
        }
        return false;
    }

    private boolean compileMethod() {
        String method = this.p.parseMethod();
        if (method != null) {
            this.p.skipWS();
            this.p.parseChar('(');
            if (method.equals("Object")) {
                this.compileExpression();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
                return true;
            }
            if (method.equalsIgnoreCase("EXISTS")) {
                throw new NucleusException("EXISTS is not yet supported for generic JPQL compilation");
            }
            if (method.equalsIgnoreCase("ANY")) {
                throw new NucleusException("ANY is not yet supported for generic JPQL compilation");
            }
            if (method.equalsIgnoreCase("ALL")) {
                throw new NucleusException("ALL is not yet supported for generic JPQL compilation");
            }
            if (method.equalsIgnoreCase("SOME")) {
                throw new NucleusException("SOME is not yet supported for generic JPQL compilation");
            }
            if (method.equalsIgnoreCase("TRIM")) {
                String methodName = "TRIM";
                if (this.p.parseStringIgnoreCase("LEADING")) {
                    methodName = "TRIM_LEADING";
                } else if (this.p.parseStringIgnoreCase("TRAILING")) {
                    methodName = "TRIM_TRAILING";
                } else if (this.p.parseStringIgnoreCase("BOTH")) {
                    // empty if block
                }
                Node trimCharNode = null;
                Node expr = new Node(1, methodName);
                this.compileExpression();
                Node next = this.stack.pop();
                if (next.getNodeType() == 0) {
                    Object litValue = next.getNodeValue();
                    if (litValue instanceof String && ((String)litValue).equals("FROM")) {
                        this.compileExpression();
                        next = this.stack.pop();
                    } else {
                        trimCharNode = next;
                        if (this.p.parseStringIgnoreCase("FROM")) {
                            // empty if block
                        }
                        this.compileExpression();
                        next = this.stack.pop();
                    }
                }
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
                expr.appendChildNode(next);
                if (trimCharNode != null) {
                    expr.appendChildNode(trimCharNode);
                }
                this.stack.push(expr);
                return true;
            }
            Node expr = new Node(1, method);
            if (!this.p.parseChar(')')) {
                do {
                    this.compileExpression();
                    expr.addProperty(this.stack.pop());
                } while (this.p.parseChar(','));
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
            }
            this.stack.push(expr);
            return true;
        }
        return false;
    }

    protected boolean compileLiteral() {
        Object litValue = null;
        boolean single_quote_next = this.p.nextIsSingleQuote();
        String sLiteral = this.p.parseStringLiteral();
        if (sLiteral != null) {
            litValue = sLiteral.length() == 1 && single_quote_next ? new Character(sLiteral.charAt(0)) : sLiteral;
        } else {
            BigDecimal fLiteral = this.p.parseFloatingPointLiteral();
            if (fLiteral != null) {
                litValue = fLiteral;
            } else {
                BigInteger iLiteral = this.p.parseIntegerLiteral();
                if (iLiteral != null) {
                    litValue = new Long(iLiteral.longValue());
                } else {
                    Boolean bLiteral = this.p.parseBooleanLiteralIgnoreCase();
                    if (bLiteral != null) {
                        litValue = bLiteral;
                    } else if (this.p.parseNullLiteralIgnoreCase()) {
                        litValue = null;
                    } else {
                        return false;
                    }
                }
            }
        }
        this.stack.push(new Node(0, litValue));
        return true;
    }

    private boolean compileIdentifier() {
        String id = this.p.parseIdentifier();
        if (id == null || id.length() == 0) {
            return false;
        }
        char first = id.charAt(0);
        if (first == '?') {
            String paramName = id.substring(1);
            try {
                ParameterNode expr = new ParameterNode(7, new Integer(paramName), this.parameterPosition);
                ++this.parameterPosition;
                this.stack.push(expr);
                return true;
            }
            catch (NumberFormatException nfe) {
                throw new NucleusUserException("Numbered parameter syntax starting ? but isnt followed by numeric!");
            }
        }
        if (first == ':') {
            ParameterNode expr = new ParameterNode(7, id.substring(1), this.parameterPosition);
            ++this.parameterPosition;
            this.stack.push(expr);
            return true;
        }
        Node expr = new Node(3, id);
        this.stack.push(expr);
        return true;
    }
}

