/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Stack;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.compiler.Lexer;
import org.datanucleus.query.compiler.Parser;
import org.datanucleus.query.node.Node;
import org.datanucleus.query.node.ParameterNode;
import org.datanucleus.store.query.QueryCompilerSyntaxException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class JDOQLParser
implements Parser {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    private static String[] jdoqlMethodNames = new String[]{"contains", "get", "containsKey", "containsValue", "isEmpty", "size", "toLowerCase", "toUpperCase", "indexOf", "matches", "substring", "startsWith", "endsWith", "Math.abs", "Math.sqrt", "JDOHelper.getObjectId", "JDOHelper.getVersion"};
    private String jdoqlMode = "DataNucleus";
    private Lexer p;
    private Stack<Node> stack = new Stack();
    private static String paramPrefixes = ":";
    int parameterPosition = 0;

    public JDOQLParser(Map options) {
        if (options != null && options.containsKey("jdoql.level")) {
            this.jdoqlMode = (String)options.get("jdoql.level");
        }
    }

    public Node compile(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        return this.compileExpression();
    }

    public Node compileVariable(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        if (!this.compileIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
        }
        if (!this.compileIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
        }
        Node nodeVariable = this.stack.pop();
        Node nodeType = this.stack.pop();
        nodeType.appendChildNode(nodeVariable);
        return nodeType;
    }

    public Node[] compileFrom(String expression) {
        return null;
    }

    public Node[] compileOrder(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        return this.compileOrderExpression();
    }

    public Node[] compileTupple(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            this.compileExpression();
            Node expr = this.stack.pop();
            nodes.add(expr);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    public Node[][] compileVariables(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        do {
            this.compilePrimary();
            if (this.stack.isEmpty()) {
                throw new QueryCompilerSyntaxException("Parsing variable list and expected variable type", this.p.getIndex(), this.p.getInput());
            }
            if (!this.compileIdentifier()) {
                throw new QueryCompilerSyntaxException("Parsing variable list and expected variable name", this.p.getIndex(), this.p.getInput());
            }
            Node nodeVariable = this.stack.pop();
            String varName = (String)nodeVariable.getNodeValue();
            if (!StringUtils.isValidJavaIdentifierForJDOQL(varName)) {
                throw new NucleusUserException(LOCALISER.msg("021105", (Object)varName));
            }
            Node nodeType = this.stack.pop();
            nodes.add(new Node[]{nodeType, nodeVariable});
        } while (this.p.parseString(";"));
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    public Node[][] compileParameters(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        do {
            this.compilePrimary();
            if (this.stack.isEmpty()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            if (!this.compileIdentifier()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            Node nodeVariable = this.stack.pop();
            Node nodeType = this.stack.pop();
            nodes.add(new Node[]{nodeType, nodeVariable});
        } while (this.p.parseString(","));
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    private Node[] compileOrderExpression() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            Node expr;
            this.compileExpression();
            if (this.p.parseString("asc") || this.p.parseString("ascending") || this.p.parseString("ASC") || this.p.parseString("ASCENDING")) {
                expr = new Node(4, "ascending");
                this.stack.push(expr);
            } else if (this.p.parseString("desc") || this.p.parseString("descending") || this.p.parseString("DESC") || this.p.parseString("DESCENDING")) {
                expr = new Node(4, "descending");
                this.stack.push(expr);
            }
            expr = new Node(4, "order");
            expr.insertChildNode(this.stack.pop());
            if (!this.stack.empty()) {
                expr.insertChildNode(this.stack.pop());
            }
            nodes.add(expr);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    private Node compileExpression() {
        this.compileConditionalOrExpression();
        return this.stack.peek();
    }

    private void compileConditionalOrExpression() {
        this.compileConditionalAndExpression();
        while (this.p.parseString("||")) {
            this.compileConditionalAndExpression();
            Node expr = new Node(4, "||");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void compileConditionalAndExpression() {
        this.compileInclusiveOrExpression();
        while (this.p.parseString("&&")) {
            this.compileInclusiveOrExpression();
            Node expr = new Node(4, "&&");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void compileInclusiveOrExpression() {
        this.compileExclusiveOrExpression();
        while (this.p.parseChar('|', '|')) {
            this.compileExclusiveOrExpression();
            Node expr = new Node(4, "|");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void compileExclusiveOrExpression() {
        this.compileAndExpression();
        while (this.p.parseChar('^')) {
            this.compileAndExpression();
            Node expr = new Node(4, "^");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void compileAndExpression() {
        this.compileRelationalExpression();
        while (this.p.parseChar('&', '&')) {
            this.compileRelationalExpression();
            Node expr = new Node(4, "&");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void compileRelationalExpression() {
        this.compileAdditiveExpression();
        while (true) {
            Node expr;
            if (this.p.parseString("==")) {
                this.compileAdditiveExpression();
                expr = new Node(4, "==");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseString("!=")) {
                this.compileAdditiveExpression();
                expr = new Node(4, "!=");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseString("=")) {
                throw new QueryCompilerSyntaxException("Invalid operator \"=\". Did you mean to use \"==\"?");
            }
            if (this.p.parseString("<=")) {
                this.compileAdditiveExpression();
                expr = new Node(4, "<=");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseString(">=")) {
                this.compileAdditiveExpression();
                expr = new Node(4, ">=");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('<')) {
                this.compileAdditiveExpression();
                expr = new Node(4, "<");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('>')) {
                this.compileAdditiveExpression();
                expr = new Node(4, ">");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseString("instanceof")) break;
            this.compileAdditiveExpression();
            expr = new Node(4, "instanceof");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void compileAdditiveExpression() {
        this.compileMultiplicativeExpression();
        while (true) {
            Node expr;
            if (this.p.parseChar('+')) {
                this.compileMultiplicativeExpression();
                expr = new Node(4, "+");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseChar('-')) break;
            this.compileMultiplicativeExpression();
            expr = new Node(4, "-");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void compileMultiplicativeExpression() {
        this.compileUnaryExpression();
        while (true) {
            Node expr;
            if (this.p.parseChar('*')) {
                this.compileMultiplicativeExpression();
                expr = new Node(4, "*");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('/')) {
                this.compileMultiplicativeExpression();
                expr = new Node(4, "/");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseChar('%')) break;
            this.compileMultiplicativeExpression();
            expr = new Node(4, "%");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void compileUnaryExpression() {
        if (this.p.parseString("++")) {
            throw new QueryCompilerSyntaxException("Unsupported operator '++'");
        }
        if (this.p.parseString("--")) {
            throw new QueryCompilerSyntaxException("Unsupported operator '--'");
        }
        if (this.p.parseChar('+')) {
            this.compileUnaryExpression();
        } else if (this.p.parseChar('-')) {
            this.compileUnaryExpression();
            Node expr = new Node(4, "NEG");
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        } else {
            this.compileUnaryExpressionNotPlusMinus();
        }
    }

    protected void compileUnaryExpressionNotPlusMinus() {
        if (this.p.parseChar('~')) {
            this.compileUnaryExpression();
            Node expr = new Node(4, "~");
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        } else if (this.p.parseChar('!')) {
            this.compileUnaryExpression();
            Node expr = new Node(4, "!");
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        } else {
            this.compilePrimary();
        }
    }

    protected void compilePrimary() {
        if (this.p.parseStringIgnoreCase("DISTINCT")) {
            Node distinctNode = new Node(4, "DISTINCT");
            this.compileIdentifier();
            Node identifierNode = this.stack.pop();
            distinctNode.appendChildNode(identifierNode);
            this.stack.push(distinctNode);
            return;
        }
        if (this.compileCreator()) {
            return;
        }
        if (this.compileLiteral()) {
            return;
        }
        if (this.compileMethod()) {
            return;
        }
        Node castNode = null;
        int sizeBeforeBraceProcessing = this.stack.size();
        boolean braceProcessing = false;
        if (this.compileCast()) {
            castNode = this.stack.pop();
        } else if (this.p.parseChar('(')) {
            this.compileExpression();
            if (!this.p.parseChar(')')) {
                throw new QueryCompilerSyntaxException("expected ')'", this.p.getIndex(), this.p.getInput());
            }
            if (!this.p.parseChar('.')) {
                return;
            }
            braceProcessing = true;
        }
        if (!this.compileIdentifier()) {
            throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
        }
        if (castNode != null) {
            this.stack.push(castNode);
        }
        int size = this.stack.size();
        if (braceProcessing) {
            size = sizeBeforeBraceProcessing + 1;
        }
        while (this.p.parseChar('.')) {
            if (this.compileMethod() || this.compileIdentifier()) continue;
            throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
        }
        while (this.stack.size() > size) {
            Node top = this.stack.pop();
            Node peek = this.stack.peek();
            peek.appendChildNode(top);
        }
    }

    private boolean compileCast() {
        String typeName = this.p.parseCast();
        if (typeName == null) {
            return false;
        }
        Node castNode = new Node(8, typeName);
        this.stack.push(castNode);
        return true;
    }

    private boolean compileCreator() {
        if (this.p.parseString("new")) {
            int size = this.stack.size();
            if (!this.compileMethod()) {
                if (!this.compileIdentifier()) {
                    throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
                }
                while (this.p.parseChar('.')) {
                    if (this.compileMethod() || this.compileIdentifier()) continue;
                    throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
                }
            }
            while (this.stack.size() - 1 > size) {
                Node top = this.stack.pop();
                Node peek = this.stack.peek();
                peek.insertChildNode(top);
            }
            Node expr = this.stack.pop();
            Node newExpr = new Node(5);
            newExpr.insertChildNode(expr);
            this.stack.push(newExpr);
            return true;
        }
        return false;
    }

    private boolean compileMethod() {
        String method = this.p.parseMethod();
        if (method != null) {
            this.p.skipWS();
            this.p.parseChar('(');
            if (this.stack.size() > 0) {
                Node primExprNode = this.stack.peek();
                if (primExprNode != null && primExprNode.getNodeValue().equals("JDOHelper")) {
                    if (method.equals("getObjectId")) {
                        method = "JDOHelper.getObjectId";
                        this.stack.pop();
                    } else if (method.equals("getVersion")) {
                        method = "JDOHelper.getVersion";
                        this.stack.pop();
                    }
                }
                if (primExprNode != null && primExprNode.getNodeValue().equals("Math")) {
                    if (method.equals("abs")) {
                        method = "Math.abs";
                        this.stack.pop();
                    } else if (method.equals("sqrt")) {
                        method = "Math.sqrt";
                        this.stack.pop();
                    }
                }
            }
            if (this.jdoqlMode.equals("JDO2") && Arrays.binarySearch(jdoqlMethodNames, method) < 0) {
                throw new QueryCompilerSyntaxException("Query uses method \"" + method + "\" but this is not a standard JDOQL method name");
            }
            Node expr = new Node(1, method);
            if (!this.p.parseChar(')')) {
                int numArgs = 0;
                do {
                    this.compileExpression();
                    expr.addProperty(this.stack.pop());
                    ++numArgs;
                } while (this.p.parseChar(','));
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
            }
            this.stack.push(expr);
            return true;
        }
        return false;
    }

    protected boolean compileLiteral() {
        Object litValue = null;
        boolean single_quote_next = this.p.nextIsSingleQuote();
        String sLiteral = this.p.parseStringLiteral();
        if (sLiteral != null) {
            litValue = sLiteral.length() == 1 && single_quote_next ? new Character(sLiteral.charAt(0)) : sLiteral;
        } else {
            BigDecimal fLiteral = this.p.parseFloatingPointLiteral();
            if (fLiteral != null) {
                litValue = fLiteral;
            } else {
                BigInteger iLiteral = this.p.parseIntegerLiteral();
                if (iLiteral != null) {
                    litValue = new Long(iLiteral.longValue());
                } else {
                    Boolean bLiteral = this.p.parseBooleanLiteral();
                    if (bLiteral != null) {
                        litValue = bLiteral;
                    } else if (this.p.parseNullLiteral()) {
                        litValue = null;
                    } else {
                        return false;
                    }
                }
            }
        }
        this.stack.push(new Node(0, litValue));
        return true;
    }

    private boolean compileIdentifier() {
        String id = this.p.parseIdentifier();
        if (id == null) {
            return false;
        }
        char first = id.charAt(0);
        if (first == ':') {
            ParameterNode expr = new ParameterNode(7, id.substring(1), this.parameterPosition);
            ++this.parameterPosition;
            this.stack.push(expr);
            return true;
        }
        Node expr = new Node(3, id);
        this.stack.push(expr);
        return true;
    }
}

