/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Map;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.TypeConversionHelper;

public class QueryUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected static Class[] classArrayObjectObject = new Class[]{Object.class, Object.class};

    public static boolean resultClassIsUserType(String className) {
        return !QueryUtils.resultClassIsSimple(className) && !className.equals(Map.class.getName()) && !className.equals(ClassNameConstants.Object);
    }

    public static boolean resultClassIsSimple(String className) {
        return className.equals(ClassNameConstants.JAVA_LANG_BOOLEAN) || className.equals(ClassNameConstants.JAVA_LANG_BYTE) || className.equals(ClassNameConstants.JAVA_LANG_CHARACTER) || className.equals(ClassNameConstants.JAVA_LANG_DOUBLE) || className.equals(ClassNameConstants.JAVA_LANG_FLOAT) || className.equals(ClassNameConstants.JAVA_LANG_INTEGER) || className.equals(ClassNameConstants.JAVA_LANG_LONG) || className.equals(ClassNameConstants.JAVA_LANG_SHORT) || className.equals(ClassNameConstants.JAVA_LANG_STRING) || className.equals(BigDecimal.class.getName()) || className.equals(BigInteger.class.getName()) || className.equals(java.util.Date.class.getName()) || className.equals(Date.class.getName()) || className.equals(Time.class.getName()) || className.equals(Timestamp.class.getName()) || className.equals(ClassNameConstants.Object);
    }

    public static Object createResultObjectUsingArgumentedConstructor(Class resultClass, Object[] fieldValues) {
        Object obj = null;
        Class[] ctrTypes = new Class[fieldValues.length];
        for (int i = 0; i < ctrTypes.length; ++i) {
            ctrTypes[i] = fieldValues[i] != null ? fieldValues[i].getClass() : Object.class;
        }
        Constructor ctr = ClassUtils.getConstructorWithArguments(resultClass, ctrTypes);
        if (ctr != null) {
            try {
                obj = ctr.newInstance(fieldValues);
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    String msg = "ResultObject of type " + resultClass.getName() + " created with following arguments: " + fieldValues.toString();
                    NucleusLogger.QUERY.debug(msg);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return obj;
    }

    public static Object createResultObjectUsingDefaultConstructorAndSetters(Class resultClass, String[] resultFieldNames, Map resultClassFieldNames, Object[] fieldValues) {
        Object obj = null;
        try {
            obj = resultClass.newInstance();
        }
        catch (Exception e) {
            String msg = LOCALISER.msg("021205", (Object)resultClass.getName());
            NucleusLogger.QUERY.error(msg);
            throw new NucleusUserException(msg);
        }
        for (int i = 0; i < fieldValues.length; ++i) {
            Field field = (Field)resultClassFieldNames.get(resultFieldNames[i].toUpperCase());
            if (QueryUtils.setFieldForResultObject(obj, resultFieldNames[i], field, fieldValues[i])) continue;
            String fieldType = "null";
            if (fieldValues[i] != null) {
                fieldType = fieldValues[i].getClass().getName();
            }
            String msg = LOCALISER.msg("021204", (Object)resultClass.getName(), (Object)resultFieldNames[i], (Object)fieldType);
            NucleusLogger.QUERY.error(msg);
            throw new NucleusUserException(msg);
        }
        return obj;
    }

    public static Object createResultObjectUsingDefaultConstructorAndSetters(Class resultClass, String[] resultFieldNames, Field[] resultFields, Object[] fieldValues) {
        Object obj = null;
        try {
            obj = resultClass.newInstance();
        }
        catch (Exception e) {
            String msg = LOCALISER.msg("021205", (Object)resultClass.getName());
            NucleusLogger.QUERY.error(msg);
            throw new NucleusUserException(msg);
        }
        for (int i = 0; i < fieldValues.length; ++i) {
            if (QueryUtils.setFieldForResultObject(obj, resultFieldNames[i], resultFields[i], fieldValues[i])) continue;
            String fieldType = "null";
            if (fieldValues[i] != null) {
                fieldType = fieldValues[i].getClass().getName();
            }
            String msg = LOCALISER.msg("021204", (Object)resultClass.getName(), (Object)resultFieldNames[i], (Object)fieldType);
            NucleusLogger.QUERY.error(msg);
            throw new NucleusUserException(msg);
        }
        return obj;
    }

    private static boolean setFieldForResultObject(final Object obj, String fieldName, Field field, Object value) {
        boolean fieldSet = false;
        if (!fieldSet) {
            String declaredFieldName;
            block30: {
                Field f;
                declaredFieldName = fieldName;
                if (field != null) {
                    declaredFieldName = field.getName();
                }
                if ((f = ClassUtils.getFieldForClass(obj.getClass(), declaredFieldName)) != null && Modifier.isPublic(f.getModifiers())) {
                    try {
                        f.set(obj, value);
                        fieldSet = true;
                    }
                    catch (Exception e) {
                        Object convertedValue = TypeConversionHelper.convertTo(value, f.getType());
                        if (convertedValue == value) break block30;
                        try {
                            f.set(obj, convertedValue);
                            fieldSet = true;
                            if (NucleusLogger.QUERY.isDebugEnabled()) {
                                String msg = "ResultObject set field=" + fieldName + " using reflection";
                                NucleusLogger.QUERY.debug(msg);
                            }
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                }
            }
            if (!fieldSet && NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021209", (Object)obj.getClass().getName(), (Object)declaredFieldName));
            }
        }
        if (!fieldSet) {
            String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            if (field != null) {
                setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + field.getName().substring(1);
            }
            Class<?> argType = null;
            if (value != null) {
                argType = value.getClass();
            } else if (field != null) {
                argType = field.getType();
            }
            Method m = ClassUtils.getMethodWithArgument(obj.getClass(), setMethodName, argType);
            if (m != null && Modifier.isPublic(m.getModifiers())) {
                try {
                    m.invoke(obj, value);
                    fieldSet = true;
                    if (NucleusLogger.QUERY.isDebugEnabled()) {
                        String msg = "ResultObject set field=" + fieldName + " using public " + setMethodName + "() method";
                        NucleusLogger.QUERY.debug(msg);
                    }
                }
                catch (Exception e) {}
            } else if (m == null) {
                Method[] methods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return obj.getClass().getDeclaredMethods();
                    }
                });
                for (int i = 0; i < methods.length; ++i) {
                    Class<?>[] args = methods[i].getParameterTypes();
                    if (!methods[i].getName().equals(setMethodName) || !Modifier.isPublic(methods[i].getModifiers()) || args == null || args.length != 1) continue;
                    try {
                        methods[i].invoke(obj, ClassUtils.convertValue(value, args[0]));
                        fieldSet = true;
                        if (!NucleusLogger.QUERY.isDebugEnabled()) break;
                        String msg = "ResultObject set field=" + fieldName + " using " + setMethodName + "() method";
                        NucleusLogger.QUERY.debug(msg);
                        break;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (!fieldSet && NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021207", (Object)obj.getClass().getName(), (Object)setMethodName, (Object)argType.getName()));
            }
        }
        if (!fieldSet) {
            Method m = QueryUtils.getPublicPutMethodForResultClass(obj.getClass());
            if (m != null) {
                try {
                    m.invoke(obj, fieldName, value);
                    fieldSet = true;
                    if (NucleusLogger.QUERY.isDebugEnabled()) {
                        String msg = "ResultObject set field=" + fieldName + " using put() method";
                        NucleusLogger.QUERY.debug(msg);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!fieldSet && NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021208", (Object)obj.getClass().getName(), (Object)"put"));
            }
        }
        return fieldSet;
    }

    public static Method getPublicSetMethodForFieldOfResultClass(Class resultClass, String fieldName, Class fieldType) {
        String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        Method m = ClassUtils.getMethodWithArgument(resultClass, setMethodName, fieldType);
        if (m != null && Modifier.isPublic(m.getModifiers())) {
            return m;
        }
        return null;
    }

    public static Method getPublicPutMethodForResultClass(final Class resultClass) {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return resultClass.getMethod("put", classArrayObjectObject);
                }
                catch (NoSuchMethodException ex) {
                    return null;
                }
            }
        });
    }

    public static String[] getExpressionsFromString(String str) {
        StringCharacterIterator ci = new StringCharacterIterator(str);
        int braces = 0;
        String text = "";
        ArrayList<String> exprList = new ArrayList<String>();
        while (ci.getIndex() != ci.getEndIndex()) {
            char c = ci.current();
            if (c == ',' && braces == 0) {
                exprList.add(text);
                text = "";
            } else if (c == '(') {
                ++braces;
                text = text + c;
            } else if (c == ')') {
                --braces;
                text = text + c;
            } else {
                text = text + c;
            }
            ci.next();
        }
        exprList.add(text);
        return exprList.toArray(new String[exprList.size()]);
    }

    public static Object getValueForParameterExpression(SymbolTable symtbl, ParameterExpression paramExpr) {
        Symbol symbol = symtbl.getSymbol(paramExpr.getId());
        if (symbol.getValue() != null) {
            return symbol.getValue();
        }
        symbol = symtbl.getSymbol("" + paramExpr.getPosition());
        if (symbol == null) {
            return null;
        }
        return symbol.getValue();
    }
}

