/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.plugin;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.plugin.Bundle;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.plugin.ExtensionPoint;
import org.datanucleus.plugin.PluginParser;
import org.datanucleus.plugin.PluginRegistry;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class NonManagedPluginRegistry
implements PluginRegistry {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", OMFContext.class.getClassLoader());
    private final ClassLoaderResolver clr;
    private static final String PLUGIN_DIR = "/";
    private static final FilenameFilter MANIFEST_FILE_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            if (name.equalsIgnoreCase("meta-inf")) {
                return true;
            }
            if (!dir.getName().equalsIgnoreCase("meta-inf")) {
                return false;
            }
            return name.equalsIgnoreCase("manifest.mf");
        }
    };
    private static final char JAR_SEPARATOR = '!';
    Map extensionPointsByUniqueId = new HashMap();
    Map registeredPluginBypluginId = new HashMap();
    Map registeredPluginByManifestURL = new HashMap();
    ExtensionPoint[] extensionPoints;
    private boolean registeredExtensions;
    private String bundleCheckType;

    public NonManagedPluginRegistry(ClassLoaderResolver clr, String bundleCheckType) {
        this.clr = clr;
        this.extensionPoints = new ExtensionPoint[0];
        this.bundleCheckType = bundleCheckType == null ? "EXCEPTION" : bundleCheckType;
    }

    public ExtensionPoint getExtensionPoint(String id) {
        return (ExtensionPoint)this.extensionPointsByUniqueId.get(id);
    }

    public ExtensionPoint[] getExtensionPoints() {
        return this.extensionPoints;
    }

    public void registerExtensionPoints() {
        this.registerExtensions();
    }

    public void registerPluginExtensions(URL plugin, Bundle bundle) {
        int i;
        ArrayList registeringExtensions = new ArrayList();
        List[] elements = PluginParser.parsePluginElements(this, plugin, bundle, this.clr);
        for (i = 0; i < elements[0].size(); ++i) {
            ExtensionPoint exPoint = (ExtensionPoint)elements[0].get(i);
            this.extensionPointsByUniqueId.put(exPoint.getUniqueId(), exPoint);
        }
        registeringExtensions.addAll(elements[1]);
        this.extensionPoints = this.extensionPointsByUniqueId.values().toArray(new ExtensionPoint[this.extensionPointsByUniqueId.values().size()]);
        for (i = 0; i < registeringExtensions.size(); ++i) {
            Extension extension = (Extension)registeringExtensions.get(i);
            ExtensionPoint exPoint = this.getExtensionPoint(extension.getExtensionPointId());
            if (exPoint == null) {
                NucleusLogger.PLUGIN.warn(LOCALISER.msg("024002", (Object)extension.getExtensionPointId(), (Object)extension.getPlugin().getSymbolicName(), (Object)extension.getPlugin().getManifestLocation().toString()));
                continue;
            }
            extension.setExtensionPoint(exPoint);
            exPoint.addExtension(extension);
        }
    }

    public void registerExtensions() {
        if (this.registeredExtensions) {
            return;
        }
        Set set = this.getPluginURLs();
        ArrayList registeringExtensions = new ArrayList();
        for (URL plugin : set) {
            Bundle bundle;
            URL manifest = this.getManifestURL(plugin);
            if (manifest == null || (bundle = this.registerBundle(manifest)) == null) continue;
            List[] elements = PluginParser.parsePluginElements(this, plugin, bundle, this.clr);
            for (int i = 0; i < elements[0].size(); ++i) {
                ExtensionPoint exPoint = (ExtensionPoint)elements[0].get(i);
                this.extensionPointsByUniqueId.put(exPoint.getUniqueId(), exPoint);
            }
            registeringExtensions.addAll(elements[1]);
        }
        this.extensionPoints = this.extensionPointsByUniqueId.values().toArray(new ExtensionPoint[this.extensionPointsByUniqueId.values().size()]);
        for (int i = 0; i < registeringExtensions.size(); ++i) {
            Extension extension = (Extension)registeringExtensions.get(i);
            ExtensionPoint exPoint = this.getExtensionPoint(extension.getExtensionPointId());
            if (exPoint == null) {
                NucleusLogger.PLUGIN.warn(LOCALISER.msg("024002", (Object)extension.getExtensionPointId(), (Object)extension.getPlugin().getSymbolicName(), (Object)extension.getPlugin().getManifestLocation().toString()));
                continue;
            }
            extension.setExtensionPoint(exPoint);
            exPoint.addExtension(extension);
        }
        this.registeredExtensions = true;
    }

    private Set getPluginURLs() {
        HashSet set = new HashSet();
        try {
            Enumeration paths = this.clr.getResources("/plugin.xml", JDOPersistenceManagerFactory.class.getClassLoader());
            while (paths.hasMoreElements()) {
                set.add(paths.nextElement());
            }
        }
        catch (IOException e) {
            throw new NucleusException("Error loading resource", e).setFatal();
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Bundle registerBundle(URL manifest) {
        if (manifest == null) {
            throw new IllegalArgumentException(LOCALISER.msg("024007"));
        }
        InputStream is = null;
        try {
            Manifest mf = null;
            if (manifest.getProtocol().equals("jar") || manifest.getProtocol().equals("zip") || manifest.getProtocol().equals("wsjar")) {
                File jarFile;
                int index;
                String path;
                String jarPath;
                if (manifest.getPath().startsWith("http://")) {
                    JarURLConnection jarConnection = (JarURLConnection)manifest.openConnection();
                    URL url = jarConnection.getJarFileURL();
                    mf = jarConnection.getManifest();
                    if (mf == null) {
                        Bundle bundle = null;
                        return bundle;
                    }
                    Bundle bundle = this.registerBundle(mf, url);
                    return bundle;
                }
                int begin = 4;
                if (manifest.getProtocol().equals("wsjar")) {
                    begin = 6;
                }
                if ((jarPath = (path = StringUtils.getDecodedStringFromURLString(manifest.toExternalForm())).substring(begin, index = path.indexOf(33))).startsWith("file:")) {
                    jarPath = jarPath.substring(5);
                }
                if ((mf = new JarFile(jarFile = new File(jarPath)).getManifest()) == null) {
                    Bundle bundle = null;
                    return bundle;
                }
                Bundle bundle = this.registerBundle(mf, jarFile.toURI().toURL());
                return bundle;
            }
            if (manifest.getProtocol().equals("rar") || manifest.getProtocol().equals("war")) {
                String path = StringUtils.getDecodedStringFromURLString(manifest.toExternalForm());
                int index = path.indexOf(33);
                String rarPath = path.substring(4, index);
                File file = new File(rarPath);
                URL rarUrl = file.toURI().toURL();
                JarFile rarFile = new JarFile(file);
                String jarPath = path.substring(index + 1, path.indexOf(33, index + 1));
                mf = new JarInputStream(rarFile.getInputStream(rarFile.getEntry(jarPath))).getManifest();
                if (mf == null) {
                    Bundle bundle = null;
                    return bundle;
                }
                Bundle bundle = this.registerBundle(mf, rarUrl);
                return bundle;
            }
            if (manifest.getProtocol().equals("vfsfile") || manifest.getProtocol().equals("vfsjar") || manifest.getProtocol().equals("vfszip")) {
                int index;
                String path = StringUtils.getDecodedStringFromURLString(manifest.toExternalForm());
                String jarPath = path.substring(0, index = path.indexOf(33));
                URL jarUrl = new URL(jarPath);
                JarInputStream jis = new JarInputStream(jarUrl.openConnection().getInputStream());
                mf = jis.getManifest();
                if (mf == null) {
                    Bundle bundle = null;
                    return bundle;
                }
                Bundle bundle = this.registerBundle(mf, jarUrl);
                return bundle;
            }
            is = manifest.openStream();
            mf = new Manifest(is);
            Bundle bundle = this.registerBundle(mf, manifest);
            return bundle;
        }
        catch (IOException e) {
            throw new NucleusException(LOCALISER.msg("024008", manifest), e).setFatal();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected Bundle registerBundle(Manifest mf, URL manifest) {
        Bundle bundle = PluginParser.parseManifest(mf, manifest);
        if (this.registeredPluginBypluginId.get(bundle.getSymbolicName()) == null) {
            if (NucleusLogger.PLUGIN.isDebugEnabled()) {
                NucleusLogger.PLUGIN.debug("Registering bundle " + bundle.getSymbolicName() + " version " + bundle.getVersion() + " at URL " + bundle.getManifestLocation() + ".");
            }
            this.registeredPluginBypluginId.put(bundle.getSymbolicName(), bundle);
            this.registeredPluginByManifestURL.put(bundle.getManifestLocation(), bundle);
        } else {
            Bundle previousBundle = (Bundle)this.registeredPluginBypluginId.get(bundle.getSymbolicName());
            if (!bundle.getManifestLocation().toExternalForm().equals(previousBundle.getManifestLocation().toExternalForm())) {
                String msg = LOCALISER.msg("024009", (Object)bundle.getSymbolicName(), (Object)bundle.getManifestLocation(), (Object)previousBundle.getManifestLocation());
                if (this.bundleCheckType.equalsIgnoreCase("EXCEPTION")) {
                    throw new NucleusException(msg);
                }
                if (this.bundleCheckType.equalsIgnoreCase("LOG")) {
                    NucleusLogger.PLUGIN.warn(msg);
                }
            }
        }
        return bundle;
    }

    private URL getManifestURL(URL plugin) {
        if (plugin == null) {
            return null;
        }
        if (plugin.toString().startsWith("jar") || plugin.toString().startsWith("zip") || plugin.toString().startsWith("rar") || plugin.toString().startsWith("war") || plugin.toString().startsWith("wsjar")) {
            return plugin;
        }
        if (plugin.toString().startsWith("vfsfile") || plugin.toString().startsWith("vfsjar") || plugin.toString().startsWith("vfszip")) {
            String urlStr = plugin.toString().replaceAll("\\.jar/", ".jar!/");
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException e) {
                NucleusLogger.PLUGIN.warn(LOCALISER.msg("024010", (Object)urlStr), e);
                return null;
            }
        }
        if (plugin.toString().startsWith("jndi")) {
            String urlStr = plugin.toString().substring(5);
            urlStr = urlStr.replaceAll("\\.jar/", ".jar!/");
            urlStr = "jar:file:" + urlStr;
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException e) {
                NucleusLogger.PLUGIN.warn(LOCALISER.msg("024010", (Object)urlStr), e);
                return null;
            }
        }
        if (plugin.toString().startsWith("code-source")) {
            String urlStr = plugin.toString().substring(12);
            urlStr = "jar:file:" + urlStr;
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException e) {
                NucleusLogger.PLUGIN.warn(LOCALISER.msg("024010", (Object)urlStr), e);
                return null;
            }
        }
        try {
            File[] files;
            File file = new File(new URI(plugin.toString()).getPath());
            File[] dirs = new File(file.getParent()).listFiles(MANIFEST_FILE_FILTER);
            if (dirs != null && dirs.length > 0 && (files = dirs[0].listFiles(MANIFEST_FILE_FILTER)) != null && files.length > 0) {
                try {
                    return files[0].toURI().toURL();
                }
                catch (MalformedURLException e) {
                    NucleusLogger.PLUGIN.warn(LOCALISER.msg("024011", plugin), e);
                    return null;
                }
            }
        }
        catch (URISyntaxException use) {
            use.printStackTrace();
            NucleusLogger.PLUGIN.warn(LOCALISER.msg("024011", plugin), use);
            return null;
        }
        NucleusLogger.PLUGIN.warn(LOCALISER.msg("024012", plugin));
        return null;
    }

    public Object createExecutableExtension(ConfigurationElement confElm, String name, Class[] argsClass, Object[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class cls = this.clr.classForName(confElm.getAttribute(name), OMFContext.class.getClassLoader());
        Constructor constructor = cls.getConstructor(argsClass);
        return constructor.newInstance(args);
    }

    public Class loadClass(String pluginId, String className) throws ClassNotFoundException {
        return this.clr.classForName(className, OMFContext.class.getClassLoader());
    }

    public URL resolveURLAsFileURL(URL url) throws IOException {
        return url;
    }

    public void resolveConstraints() {
        for (Bundle bundle : this.registeredPluginBypluginId.values()) {
            List set = bundle.getRequireBundle();
            for (Bundle.BundleDescription bd : set) {
                String symbolicName = bd.getBundleSymbolicName();
                Bundle requiredBundle = (Bundle)this.registeredPluginBypluginId.get(symbolicName);
                if (requiredBundle == null) {
                    if (bd.getParameter("resolution") != null && bd.getParameter("resolution").equalsIgnoreCase("optional")) {
                        NucleusLogger.PLUGIN.info(LOCALISER.msg("024013", (Object)bundle.getSymbolicName(), (Object)symbolicName));
                    } else {
                        NucleusLogger.PLUGIN.error(LOCALISER.msg("024014", (Object)bundle.getSymbolicName(), (Object)symbolicName));
                    }
                }
                if (bd.getParameter("bundle-version") == null || requiredBundle == null || this.isVersionInInterval(requiredBundle.getVersion(), bd.getParameter("bundle-version"))) continue;
                NucleusLogger.PLUGIN.error(LOCALISER.msg("024015", (Object)bundle.getSymbolicName(), (Object)symbolicName, (Object)bd.getParameter("bundle-version"), (Object)bundle.getVersion()));
            }
        }
    }

    private boolean isVersionInInterval(String version, String interval) {
        Bundle.BundleVersionRange versionRange = PluginParser.parseVersionRange(version);
        Bundle.BundleVersionRange intervalRange = PluginParser.parseVersionRange(interval);
        int compare_floor = versionRange.floor.compareTo(intervalRange.floor);
        boolean result = true;
        if (intervalRange.floor_inclusive) {
            result = compare_floor >= 0;
        } else {
            boolean bl = result = compare_floor > 0;
        }
        if (intervalRange.ceiling != null) {
            int compare_ceiling = versionRange.floor.compareTo(intervalRange.ceiling);
            result = intervalRange.ceiling_inclusive ? compare_ceiling <= 0 : compare_ceiling < 0;
        }
        return result;
    }

    public Bundle[] getBundles() {
        return this.registeredPluginBypluginId.values().toArray(new Bundle[this.registeredPluginBypluginId.values().size()]);
    }
}

