/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata.xml;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.xml.AbstractMetaDataHandler;
import org.datanucleus.util.EntityResolverFactory;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MetaDataParser
extends DefaultHandler {
    protected static Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected final MetaDataManager mgr;
    protected final boolean validate;
    SAXParser parser = null;

    public MetaDataParser(MetaDataManager mgr, boolean validate) {
        this.mgr = mgr;
        this.validate = validate;
    }

    public MetaData parseMetaDataURL(URL url, String handlerName) {
        if (url == null) {
            String msg = LOCALISER.msg("044031");
            NucleusLogger.METADATA.error(msg);
            throw new NucleusException(msg);
        }
        InputStream in = null;
        try {
            in = url.openStream();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (in == null) {
            try {
                in = new FileInputStream(StringUtils.getFileForFilename(url.getFile()));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (in == null) {
            NucleusLogger.METADATA.error(LOCALISER.msg("044032", (Object)url.toString()));
            throw new NucleusException(LOCALISER.msg("044032", (Object)url.toString()));
        }
        return this.parseMetaDataStream(in, url.toString(), handlerName);
    }

    public MetaData parseMetaDataFile(String fileName, String handlerName) {
        InputStream in = null;
        try {
            in = new URL(fileName).openStream();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (in == null) {
            try {
                in = new FileInputStream(StringUtils.getFileForFilename(fileName));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (in == null) {
            NucleusLogger.ENHANCER.error(LOCALISER.msg("044032", (Object)fileName));
            throw new NucleusException(LOCALISER.msg("044032", (Object)fileName));
        }
        return this.parseMetaDataStream(in, fileName, handlerName);
    }

    public synchronized MetaData parseMetaDataStream(InputStream in, String filename, String handlerName) {
        if (in == null) {
            throw new NullPointerException("input stream is null");
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044030", (Object)filename, (Object)handlerName, (Object)(this.validate ? "true" : "false")));
        }
        try {
            if (this.parser == null) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(this.validate);
                factory.setNamespaceAware(this.validate);
                if (this.validate) {
                    try {
                        factory.setFeature("http://apache.org/xml/features/validation/schema", true);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.parser = factory.newSAXParser();
            }
            DefaultHandler handler = null;
            EntityResolver entityResolver = null;
            try {
                entityResolver = EntityResolverFactory.getInstance(this.mgr.getOMFContext().getPluginManager(), handlerName);
                if (entityResolver != null) {
                    this.parser.getXMLReader().setEntityResolver(entityResolver);
                }
                Class[] argTypes = new Class[]{MetaDataManager.class, String.class, EntityResolver.class};
                Object[] argValues = new Object[]{this.mgr, filename, entityResolver};
                handler = (DefaultHandler)this.mgr.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.metadata_handler", "name", handlerName, "class-name", argTypes, argValues);
                if (handler == null) {
                    throw new NucleusUserException(LOCALISER.msg("044028", (Object)handlerName)).setFatal();
                }
            }
            catch (Exception e) {
                String msg = LOCALISER.msg("044029", (Object)handlerName, (Object)e.getMessage());
                throw new NucleusException(msg, e);
            }
            this.parser.parse(in, handler);
            MetaData e = ((AbstractMetaDataHandler)handler).getMetaData();
            return e;
        }
        catch (NucleusException e) {
            throw e;
        }
        catch (Exception e) {
            Exception cause = e;
            if (e instanceof SAXException) {
                SAXException se = (SAXException)e;
                cause = se.getException();
            }
            cause = e.getCause() == null ? cause : e.getCause();
            NucleusLogger.METADATA.error(LOCALISER.msg("044040", (Object)filename, (Object)cause));
            if (cause instanceof InvalidMetaDataException) {
                throw (InvalidMetaDataException)cause;
            }
            String message = LOCALISER.msg("044033", e);
            throw new NucleusException(message, cause);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ignore) {}
        }
    }
}

