/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.util.StringUtils;

public class TableGeneratorMetaData
extends MetaData {
    protected final String name;
    protected String tableName;
    protected String catalogName;
    protected String schemaName;
    protected String pkColumnName;
    protected String valueColumnName;
    protected String pkColumnValue;
    protected long initialValue = 0L;
    protected long allocationSize = 50L;

    public TableGeneratorMetaData(MetaData parent, String name, String tableName, String catalogName, String schemaName, String pkColumnName, String valueColumnName, String pkColumnValue, String initialValue, String allocationSize) {
        super(parent);
        if (StringUtils.isWhitespace(name)) {
            throw new InvalidMetaDataException(LOCALISER, "044155");
        }
        this.name = name;
        this.tableName = StringUtils.isWhitespace(tableName) ? null : tableName;
        this.catalogName = StringUtils.isWhitespace(catalogName) ? null : catalogName;
        this.schemaName = StringUtils.isWhitespace(schemaName) ? null : schemaName;
        this.pkColumnName = StringUtils.isWhitespace(pkColumnName) ? null : pkColumnName;
        this.valueColumnName = StringUtils.isWhitespace(valueColumnName) ? null : valueColumnName;
        String string = this.pkColumnValue = StringUtils.isWhitespace(pkColumnValue) ? null : pkColumnValue;
        if (!StringUtils.isWhitespace(initialValue)) {
            this.initialValue = new Long(initialValue);
        }
        if (!StringUtils.isWhitespace(allocationSize)) {
            this.allocationSize = new Long(allocationSize);
        }
    }

    public String getFullyQualifiedName() {
        PackageMetaData pmd = (PackageMetaData)this.getParent();
        return pmd.getName() + "." + this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getPKColumnName() {
        return this.pkColumnName;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public String getPKColumnValue() {
        return this.pkColumnValue;
    }

    public long getInitialValue() {
        return this.initialValue;
    }

    public long getAllocationSize() {
        return this.allocationSize;
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<table-generator name=\"" + this.name + "\"\n");
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix + "</table-generator>\n");
        return sb.toString();
    }
}

