/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.util.StringUtils;

public class QueryMetaData
extends MetaData {
    protected String scope;
    protected final String name;
    protected String language;
    protected boolean unmodifiable = false;
    protected String query;
    protected String resultClass = null;
    protected String resultMetaDataName = null;
    protected boolean unique = false;
    protected String fetchPlanName = null;

    public QueryMetaData(MetaData parent, String scope, String name, String language, String unmodifiable, String resultClass, String resultMetaDataName, String unique, String fetchPlanName) {
        super(parent);
        if (StringUtils.isWhitespace(name)) {
            throw new InvalidMetaDataException(LOCALISER, "044154");
        }
        this.scope = StringUtils.isWhitespace(scope) ? null : scope;
        this.name = name;
        this.unmodifiable = unmodifiable != null && unmodifiable.equalsIgnoreCase("true");
        this.language = language;
        if (this.language != null) {
            if (this.language.equals("javax.jdo.query.JDOQL")) {
                this.language = QueryLanguage.JDOQL.toString();
            } else if (this.language.equals("javax.jdo.query.SQL")) {
                this.language = QueryLanguage.SQL.toString();
            } else if (this.language.equals("javax.jdo.query.JPQL")) {
                this.language = QueryLanguage.JPQL.toString();
            }
        }
        this.resultClass = StringUtils.isWhitespace(resultClass) ? null : resultClass;
        this.resultMetaDataName = resultMetaDataName;
        if (unique != null && unique.equalsIgnoreCase("true")) {
            this.unique = true;
        }
        if (!StringUtils.isWhitespace(fetchPlanName)) {
            this.fetchPlanName = fetchPlanName;
        }
    }

    public String getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public String getLanguage() {
        if (this.language == null) {
            this.language = QueryLanguage.JDOQL.toString();
        }
        return this.language;
    }

    public boolean isUnmodifiable() {
        return this.unmodifiable;
    }

    public String getQuery() {
        return this.query;
    }

    public String getResultClass() {
        return this.resultClass;
    }

    public String getResultMetaDataName() {
        return this.resultMetaDataName;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getFetchPlanName() {
        return this.fetchPlanName;
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<query name=\"" + this.name + "\"\n");
        sb.append(prefix).append("       language=\"" + this.language + "\"\n");
        if (this.unique) {
            sb.append(prefix).append("       unique=\"true\"\n");
        }
        if (this.resultClass != null) {
            sb.append(prefix).append("       result-class=\"" + this.resultClass + "\"\n");
        }
        if (this.fetchPlanName != null) {
            sb.append(prefix).append("       fetch-plan=\"" + this.fetchPlanName + "\"\n");
        }
        sb.append(prefix).append("       unmodifiable=\"" + this.unmodifiable + "\">\n");
        sb.append(prefix).append(this.query).append("\n");
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix + "</query>\n");
        return sb.toString();
    }
}

