/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class MetaDataUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    private static MetaDataUtils instance;

    public static synchronized MetaDataUtils getInstance() {
        if (instance == null) {
            instance = new MetaDataUtils();
        }
        return instance;
    }

    protected MetaDataUtils() {
    }

    public boolean arrayStorableAsByteArrayInSingleColumn(AbstractMemberMetaData fmd) {
        if (fmd == null || !fmd.hasArray()) {
            return false;
        }
        String arrayComponentType = fmd.getType().getComponentType().getName();
        return arrayComponentType.equals(ClassNameConstants.BOOLEAN) || arrayComponentType.equals(ClassNameConstants.BYTE) || arrayComponentType.equals(ClassNameConstants.CHAR) || arrayComponentType.equals(ClassNameConstants.DOUBLE) || arrayComponentType.equals(ClassNameConstants.FLOAT) || arrayComponentType.equals(ClassNameConstants.INT) || arrayComponentType.equals(ClassNameConstants.LONG) || arrayComponentType.equals(ClassNameConstants.SHORT) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_BOOLEAN) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_BYTE) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_CHARACTER) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_DOUBLE) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_FLOAT) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_INTEGER) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_LONG) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_SHORT) || arrayComponentType.equals(ClassNameConstants.JAVA_MATH_BIGDECIMAL) || arrayComponentType.equals(ClassNameConstants.JAVA_MATH_BIGINTEGER);
    }

    public boolean storesPersistable(AbstractMemberMetaData fmd, ClassLoaderResolver clr) {
        if (fmd == null) {
            return false;
        }
        MetaDataManager mgr = fmd.getAbstractClassMetaData().getMetaDataManager();
        if (fmd.hasCollection()) {
            if (fmd.getCollection().getElementClassMetaData() != null) {
                return true;
            }
            String elementType = fmd.getCollection().getElementType();
            Class elementCls = clr.classForName(elementType);
            if (elementCls != null && ClassUtils.isReferenceType(elementCls) && mgr.getMetaDataForImplementationOfReference(elementCls, null, clr) != null) {
                return true;
            }
        } else if (fmd.hasMap()) {
            if (fmd.getMap().getKeyClassMetaData() != null) {
                return true;
            }
            String keyType = fmd.getMap().getKeyType();
            Class keyCls = clr.classForName(keyType);
            if (keyCls != null && ClassUtils.isReferenceType(keyCls) && mgr.getMetaDataForImplementationOfReference(keyCls, null, clr) != null) {
                return true;
            }
            if (fmd.getMap().getValueClassMetaData() != null) {
                return true;
            }
            String valueType = fmd.getMap().getValueType();
            Class valueCls = clr.classForName(valueType);
            if (valueCls != null && ClassUtils.isReferenceType(valueCls) && mgr.getMetaDataForImplementationOfReference(valueCls, null, clr) != null) {
                return true;
            }
        } else {
            if (fmd.hasArray() && fmd.getMetaDataManager().getApiAdapter().isPersistable(fmd.getType().getComponentType())) {
                return true;
            }
            if (ClassUtils.isReferenceType(fmd.getType()) && mgr.getMetaDataForImplementationOfReference(fmd.getType(), null, clr) != null) {
                return true;
            }
            if (mgr.getMetaDataForClass(fmd.getType(), clr) != null) {
                return true;
            }
        }
        return false;
    }

    public boolean storesFCO(AbstractMemberMetaData fmd, ClassLoaderResolver clr) {
        if (fmd == null) {
            return false;
        }
        MetaDataManager mgr = fmd.getAbstractClassMetaData().getMetaDataManager();
        if (fmd.isSerialized() || fmd.isEmbedded()) {
            return false;
        }
        if (fmd.hasCollection() && !fmd.getCollection().isSerializedElement() && !fmd.getCollection().isEmbeddedElement()) {
            if (fmd.getCollection().getElementClassMetaData() != null) {
                return true;
            }
            String elementType = fmd.getCollection().getElementType();
            Class elementCls = clr.classForName(elementType);
            if (elementCls != null && ClassUtils.isReferenceType(elementCls) && mgr.getMetaDataForImplementationOfReference(elementCls, null, clr) != null) {
                return true;
            }
        } else if (fmd.hasMap()) {
            if (fmd.getMap().getKeyClassMetaData() != null && !fmd.getMap().isEmbeddedKey() && !fmd.getMap().isSerializedKey()) {
                return true;
            }
            String keyType = fmd.getMap().getKeyType();
            Class keyCls = clr.classForName(keyType);
            if (keyCls != null && ClassUtils.isReferenceType(keyCls) && mgr.getMetaDataForImplementationOfReference(keyCls, null, clr) != null) {
                return true;
            }
            if (fmd.getMap().getValueClassMetaData() != null && !fmd.getMap().isEmbeddedValue() && !fmd.getMap().isSerializedValue()) {
                return true;
            }
            String valueType = fmd.getMap().getValueType();
            Class valueCls = clr.classForName(valueType);
            if (valueCls != null && ClassUtils.isReferenceType(valueCls) && mgr.getMetaDataForImplementationOfReference(valueCls, null, clr) != null) {
                return true;
            }
        } else if (fmd.hasArray() && !fmd.getArray().isSerializedElement() && !fmd.getArray().isEmbeddedElement()) {
            if (fmd.getMetaDataManager().getApiAdapter().isPersistable(fmd.getType().getComponentType())) {
                return true;
            }
        } else {
            if (ClassUtils.isReferenceType(fmd.getType()) && mgr.getMetaDataForImplementationOfReference(fmd.getType(), null, clr) != null) {
                return true;
            }
            if (mgr.getMetaDataForClass(fmd.getType(), clr) != null) {
                return true;
            }
        }
        return false;
    }

    public String[] getValuesForCommaSeparatedAttribute(String attr) {
        if (attr == null || attr.length() == 0) {
            return null;
        }
        String[] values = StringUtils.split(attr, ",");
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
            }
        }
        return values;
    }

    public String[] getImplementationNamesForReferenceField(AbstractMemberMetaData fmd, int fieldRole, ClassLoaderResolver clr) {
        Class implCls;
        String[] implTypes = null;
        if (4 == fieldRole) {
            String implTypeStr = fmd.getArray().getElementType();
            if (implTypeStr != null) {
                implTypes = this.getValuesForCommaSeparatedAttribute(implTypeStr);
            }
        } else {
            implTypes = fmd.getFieldTypes();
        }
        if (implTypes != null && implTypes.length == 1 && (implCls = clr.classForName(implTypes[0].trim())).isInterface()) {
            implTypes = fmd.getAbstractClassMetaData().getMetaDataManager().getClassesImplementingInterface(implTypes[0], clr);
        }
        if (implTypes == null) {
            implTypes = 3 == fieldRole ? fmd.getValuesForExtension("implementation-classes") : (5 == fieldRole ? fmd.getValuesForExtension("key-implementation-classes") : (6 == fieldRole ? fmd.getValuesForExtension("value-implementation-classes") : (4 == fieldRole ? fmd.getValuesForExtension("implementation-classes") : fmd.getValuesForExtension("implementation-classes"))));
        }
        if (implTypes == null) {
            String type = null;
            type = fmd.hasCollection() && fieldRole == 3 ? fmd.getCollection().getElementType() : (fmd.hasMap() && fieldRole == 5 ? fmd.getMap().getKeyType() : (fmd.hasMap() && fieldRole == 6 ? fmd.getMap().getValueType() : (fmd.hasArray() && fieldRole == 4 ? fmd.getType().getComponentType().getName() : fmd.getTypeName())));
            if (!type.equals(ClassNameConstants.Object)) {
                implTypes = fmd.getAbstractClassMetaData().getMetaDataManager().getClassesImplementingInterface(type, clr);
            }
            if (implTypes == null) {
                throw new NucleusUserException(LOCALISER.msg("044161", (Object)fmd.getFullFieldName(), (Object)type));
            }
        }
        int noOfDups = 0;
        block0: for (int i = 0; i < implTypes.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (!implTypes[j].equals(implTypes[i])) continue;
                ++noOfDups;
                continue block0;
            }
        }
        String[] impls = new String[implTypes.length - noOfDups];
        int n = 0;
        for (int i = 0; i < implTypes.length; ++i) {
            boolean dup = false;
            for (int j = 0; j < i; ++j) {
                if (!implTypes[j].equals(implTypes[i])) continue;
                dup = true;
                break;
            }
            if (dup) continue;
            impls[n++] = implTypes[i];
        }
        return impls;
    }
}

