/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import org.datanucleus.metadata.AbstractConstraintMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.ForeignKeyAction;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.PropertyMetaData;

public class ForeignKeyMetaData
extends AbstractConstraintMetaData
implements ColumnMetaDataContainer {
    protected boolean unique;
    protected boolean deferred;
    protected ForeignKeyAction deleteAction;
    protected ForeignKeyAction updateAction;

    public ForeignKeyMetaData(ForeignKeyMetaData fkmd) {
        block8: {
            int i;
            block7: {
                int i2;
                super(null, fkmd.name, fkmd.table);
                this.deferred = fkmd.deferred;
                this.deleteAction = fkmd.deleteAction;
                this.updateAction = fkmd.updateAction;
                this.unique = fkmd.unique;
                if (!fkmd.isInitialised()) break block7;
                if (fkmd.getMemberMetaData() != null) {
                    for (i2 = 0; i2 < fkmd.getMemberMetaData().length; ++i2) {
                        if (fkmd.getMemberMetaData()[i2] instanceof PropertyMetaData) {
                            this.addMember(new PropertyMetaData((MetaData)this, (PropertyMetaData)fkmd.getMemberMetaData()[i2]));
                            continue;
                        }
                        this.addMember(new FieldMetaData((MetaData)this, fkmd.getMemberMetaData()[i2]));
                    }
                }
                if (fkmd.getColumnMetaData() == null) break block8;
                for (i2 = 0; i2 < fkmd.getColumnMetaData().length; ++i2) {
                    this.addColumn(new ColumnMetaData((MetaData)this, fkmd.getColumnMetaData()[i2]));
                }
                break block8;
            }
            for (i = 0; i < fkmd.members.size(); ++i) {
                if (fkmd.members.get(i) instanceof PropertyMetaData) {
                    this.addMember(new PropertyMetaData((MetaData)this, (PropertyMetaData)fkmd.members.get(i)));
                    continue;
                }
                this.addMember(new FieldMetaData((MetaData)this, (AbstractMemberMetaData)fkmd.members.get(i)));
            }
            for (i = 0; i < fkmd.columns.size(); ++i) {
                this.addColumn(new ColumnMetaData((MetaData)this, (ColumnMetaData)fkmd.columns.get(i)));
            }
        }
    }

    public ForeignKeyMetaData(String name, String table, String unique, String deferred, String delete_action, String update_action) {
        super(null, name, table);
        if (unique != null) {
            if (unique.equalsIgnoreCase("true")) {
                this.unique = true;
            } else if (unique.equalsIgnoreCase("false")) {
                this.unique = false;
            }
        }
        if (deferred != null) {
            if (deferred.equalsIgnoreCase("true")) {
                this.deferred = true;
            } else if (deferred.equalsIgnoreCase("false")) {
                this.deferred = false;
            }
        }
        this.deleteAction = ForeignKeyAction.getForeignKeyAction(delete_action);
        this.updateAction = ForeignKeyAction.getForeignKeyAction(update_action);
    }

    public void initialise() {
        int i;
        if (this.isInitialised()) {
            return;
        }
        if (this.members.size() == 0) {
            this.memberMetaData = null;
        } else {
            this.memberMetaData = new AbstractMemberMetaData[this.members.size()];
            for (i = 0; i < this.memberMetaData.length; ++i) {
                this.memberMetaData[i] = (AbstractMemberMetaData)this.members.get(i);
                this.memberMetaData[i].initialise();
            }
        }
        if (this.columns.size() == 0) {
            this.columnMetaData = null;
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = (ColumnMetaData)this.columns.get(i);
                this.columnMetaData[i].initialise();
            }
        }
        this.columns.clear();
        this.columns = null;
        this.members.clear();
        this.members = null;
        this.setInitialised();
    }

    public final boolean isDeferred() {
        return this.deferred;
    }

    public final ForeignKeyAction getDeleteAction() {
        return this.deleteAction;
    }

    public final boolean isUnique() {
        return this.unique;
    }

    public final ForeignKeyAction getUpdateAction() {
        return this.updateAction;
    }

    public String toString(String prefix, String indent) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<foreign-key deferred=\"" + this.deferred + "\"\n");
        sb.append(prefix).append("       unique=\"" + this.unique + "\"");
        if (this.updateAction != null) {
            sb.append("\n").append(prefix).append("       update-action=\"" + this.updateAction + "\"");
        }
        if (this.deleteAction != null) {
            sb.append("\n").append(prefix).append("       delete-action=\"" + this.deleteAction + "\"");
        }
        if (this.table != null) {
            sb.append("\n").append(prefix).append("       table=\"" + this.table + "\"");
        }
        if (this.name != null) {
            sb.append("\n").append(prefix).append("       name=\"" + this.name + "\"");
        }
        sb.append(">\n");
        if (this.memberMetaData != null) {
            for (i = 0; i < this.memberMetaData.length; ++i) {
                sb.append(this.memberMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.columnMetaData != null) {
            for (i = 0; i < this.columnMetaData.length; ++i) {
                sb.append(this.columnMetaData[i].toString(prefix + indent, indent));
            }
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</foreign-key>\n");
        return sb.toString();
    }
}

