/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.EventListenerMetaData;
import org.datanucleus.metadata.FetchPlanMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.QueryResultMetaData;

public class FileMetaData
extends MetaData {
    public static final int JDO_FILE = 1;
    public static final int ORM_FILE = 2;
    public static final int JDOQUERY_FILE = 3;
    public static final int ANNOTATIONS = 4;
    public static final int JPA_FILE = 5;
    protected final transient MetaDataManager metaDataManager;
    protected int type;
    protected String filename;
    protected String catalog;
    protected String schema;
    protected Collection queries = null;
    protected Collection queryResultMetaData = null;
    protected Collection fetchPlans = null;
    protected List packages = null;
    protected List listeners = null;

    public FileMetaData(String filename, MetaDataManager metaDataManager, String catalog, String schema) {
        super(null);
        this.filename = filename;
        this.metaDataManager = metaDataManager;
    }

    public int getType() {
        return this.type;
    }

    public int getNoOfQueries() {
        return this.queries != null ? this.queries.size() : 0;
    }

    public QueryMetaData[] getQueries() {
        return this.queries == null ? null : this.queries.toArray(new QueryMetaData[this.queries.size()]);
    }

    public int getNoOfFetchPlans() {
        return this.fetchPlans != null ? this.fetchPlans.size() : 0;
    }

    public FetchPlanMetaData[] getFetchPlans() {
        return this.fetchPlans == null ? null : this.fetchPlans.toArray(new FetchPlanMetaData[this.fetchPlans.size()]);
    }

    public MetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public int getNoOfPackages() {
        return this.packages != null ? this.packages.size() : 0;
    }

    public PackageMetaData getPackage(int i) {
        if (this.packages == null) {
            return null;
        }
        return (PackageMetaData)this.packages.get(i);
    }

    public PackageMetaData getPackage(String name) {
        if (this.packages == null) {
            return null;
        }
        for (PackageMetaData p : this.packages) {
            if (!p.name.equals(name)) continue;
            return p;
        }
        return null;
    }

    public ClassMetaData getClass(String pkg_name, String class_name) {
        if (pkg_name == null || class_name == null) {
            return null;
        }
        PackageMetaData pmd = this.getPackage(pkg_name);
        if (pmd != null) {
            return pmd.getClass(class_name);
        }
        return null;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void addQuery(QueryMetaData qmd) {
        if (qmd == null) {
            return;
        }
        if (this.queries == null) {
            this.queries = new HashSet();
        }
        this.queries.add(qmd);
    }

    public void addFetchPlan(FetchPlanMetaData fpmd) {
        if (fpmd == null) {
            return;
        }
        if (this.fetchPlans == null) {
            this.fetchPlans = new HashSet();
        }
        this.fetchPlans.add(fpmd);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void addPackage(PackageMetaData pkg) {
        if (pkg == null) {
            return;
        }
        if (this.packages == null) {
            this.packages = new ArrayList();
        } else {
            for (PackageMetaData p : this.packages) {
                if (!pkg.getName().equals(p.getName())) continue;
                return;
            }
        }
        this.packages.add(pkg);
    }

    public String toString(String prefix, String indent) {
        Iterator iter;
        if (indent == null) {
            indent = "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<jdo");
        if (this.catalog != null) {
            sb.append(" catalog=\"" + this.catalog + "\"");
        }
        if (this.schema != null) {
            sb.append(" schema=\"" + this.schema + "\"");
        }
        sb.append(">\n");
        if (this.packages != null) {
            iter = this.packages.iterator();
            while (iter.hasNext()) {
                sb.append(((PackageMetaData)iter.next()).toString(indent, indent));
            }
        }
        if (this.queries != null) {
            iter = this.queries.iterator();
            while (iter.hasNext()) {
                sb.append(((QueryMetaData)iter.next()).toString(indent, indent));
            }
        }
        if (this.fetchPlans != null) {
            iter = this.fetchPlans.iterator();
            while (iter.hasNext()) {
                sb.append(((FetchPlanMetaData)iter.next()).toString(indent, indent));
            }
        }
        sb.append(super.toString(indent, indent));
        sb.append("</jdo>");
        return sb.toString();
    }

    public void addListener(EventListenerMetaData listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public List getListeners() {
        return this.listeners;
    }

    public void addQueryResultMetaData(QueryResultMetaData resultMetaData) {
        if (this.queryResultMetaData == null) {
            this.queryResultMetaData = new HashSet();
        }
        if (!this.queryResultMetaData.contains(resultMetaData)) {
            this.queryResultMetaData.add(resultMetaData);
        }
    }

    public QueryResultMetaData[] getQueryResultMetaData() {
        if (this.queryResultMetaData == null) {
            return null;
        }
        return this.queryResultMetaData.toArray(new QueryResultMetaData[this.queryResultMetaData.size()]);
    }
}

