/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.util.StringUtils;

public class FetchPlanMetaData
extends MetaData {
    final String name;
    protected int maxFetchDepth = -1;
    protected int fetchSize = -1;
    protected List fetchGroups = new ArrayList();

    public FetchPlanMetaData(MetaData parent, String name, String depth, String size) {
        super(parent);
        this.name = name;
        if (!StringUtils.isWhitespace(depth)) {
            try {
                this.maxFetchDepth = new Integer(depth);
            }
            catch (NumberFormatException nfe) {
                this.maxFetchDepth = -1;
            }
        }
        if (!StringUtils.isWhitespace(size)) {
            try {
                this.fetchSize = new Integer(size);
            }
            catch (NumberFormatException nfe) {
                this.fetchSize = -1;
            }
        }
    }

    public final String getName() {
        return this.name;
    }

    public final int getMaxFetchDepth() {
        return this.maxFetchDepth;
    }

    public final int getFetchSize() {
        return this.fetchSize;
    }

    public final FetchGroupMetaData[] getFetchGroupMetaData() {
        return this.fetchGroups.toArray(new FetchGroupMetaData[this.fetchGroups.size()]);
    }

    public void addFetchGroup(FetchGroupMetaData fgmd) {
        this.fetchGroups.add(fgmd);
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<fetch-plan name=\"" + this.name + "\"" + " max-fetch-depth=\"" + this.maxFetchDepth + "\"" + " fetch-size=\"" + this.fetchSize + "\"\n");
        for (FetchGroupMetaData fgmd : this.fetchGroups) {
            sb.append(fgmd.toString(prefix + indent, indent));
        }
        sb.append(prefix + "</fetch-plan>\n");
        return sb.toString();
    }
}

