/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.evaluator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.query.evaluator.memory.InMemoryExpressionEvaluator;
import org.datanucleus.query.expression.CreatorExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.symbol.PropertySymbol;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class JavaQueryEvaluator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = JavaQueryEvaluator.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    protected final String language;
    protected String candidateAlias = "this";
    protected Expression filter;
    protected Expression[] result;
    protected Expression[] ordering;
    protected Expression[] grouping;
    protected Expression having;
    protected SymbolTable symtbl;
    protected InMemoryExpressionEvaluator evaluator;
    protected Map parameterValues;
    protected List sourceObjects;
    protected Query query;
    protected ClassLoaderResolver clr;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public JavaQueryEvaluator(String language) {
        this.language = language;
    }

    public Collection execute(boolean applyFilter, boolean applyOrdering, boolean applyResult, boolean applyResultClass, boolean applyRange) {
        List resultSet = null;
        if (this.sourceObjects.size() == 0) {
            return this.sourceObjects;
        }
        resultSet = new ArrayList(this.sourceObjects);
        if (applyFilter && this.filter != null) {
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021012", (Object)"filter", (Object)this.language, (Object)this.filter));
            }
            resultSet = this.handleFilter(resultSet);
        }
        if (applyOrdering && this.ordering != null) {
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021012", (Object)"ordering", (Object)this.language, (Object)StringUtils.objectArrayToString(this.ordering)));
            }
            resultSet = this.ordering(resultSet);
        }
        if (applyRange && (this.query.getRangeFromIncl() != 0L || this.query.getRangeToExcl() != Long.MAX_VALUE || this.query.getRange() != null)) {
            long fromIncl = this.query.getRangeFromIncl();
            long toExcl = this.query.getRangeToExcl();
            if (this.query.getRange() != null) {
                int sepPos = this.query.getRange().indexOf(44);
                if (sepPos > 0) {
                    fromIncl = new Long(this.query.getRange().substring(0, sepPos).trim());
                    toExcl = new Long(this.query.getRange().substring(sepPos + 1).trim());
                } else {
                    fromIncl = new Long(this.query.getRange().trim());
                }
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021012", (Object)"range", (Object)this.language, (Object)("" + fromIncl + "," + toExcl)));
            }
            resultSet = this.handleRange(resultSet, fromIncl, toExcl);
        }
        if (applyResult && this.result != null) {
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021012", (Object)"result", (Object)this.language, (Object)StringUtils.objectArrayToString(this.result)));
            }
            List aggregateList = new ArrayList();
            List s = resultSet;
            if (this.grouping != null) {
                s = this.sortByGrouping(resultSet);
            }
            aggregateList = s;
            if (this.grouping != null) {
                aggregateList = this.handleAggregates(s);
            }
            resultSet = this.handleResult(aggregateList);
            if (this.query.getResultDistinct()) {
                ArrayList tmpList = new ArrayList();
                Iterator iter = resultSet.iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (tmpList.contains(obj)) continue;
                    tmpList.add(obj);
                }
                resultSet = tmpList;
            }
        }
        if (applyResultClass && this.query.getResultClass() != null) {
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021012", (Object)"resultClass", (Object)this.language, (Object)this.query.getResultClass().getName()));
            }
            if (!(this.result[0] instanceof CreatorExpression)) {
                return this.mapResultClass(resultSet);
            }
        }
        return resultSet;
    }

    private List handleFilter(List set) {
        if (this.filter == null) {
            return set;
        }
        ArrayList result = new ArrayList();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            this.symtbl.getSymbol(this.candidateAlias).setValue(obj);
            if (this.filter.evaluate(new InMemoryExpressionEvaluator(this.query.getObjectManager().getOMFContext().getQueryManager(), this.symtbl, this.query.getParsedImports(), this.clr, this.candidateAlias)) != Boolean.TRUE) continue;
            result.add(obj);
        }
        return result;
    }

    private List handleRange(List set, long fromIncl, long toExcl) {
        long l;
        if (toExcl - fromIncl <= 0L) {
            return Collections.EMPTY_LIST;
        }
        ArrayList resultList = new ArrayList();
        Iterator it = set.iterator();
        for (l = 0L; l < fromIncl && it.hasNext(); ++l) {
            it.next();
        }
        for (l = 0L; l < toExcl - fromIncl && it.hasNext(); ++l) {
            resultList.add(it.next());
        }
        return resultList;
    }

    private List sortByGrouping(List set) {
        Object[] o = set.toArray();
        Arrays.sort(o, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                for (int i = 0; i < JavaQueryEvaluator.this.grouping.length; ++i) {
                    JavaQueryEvaluator.this.symtbl.getSymbol(JavaQueryEvaluator.this.candidateAlias).setValue(arg0);
                    Object a = JavaQueryEvaluator.this.grouping[i].evaluate(JavaQueryEvaluator.this.evaluator);
                    JavaQueryEvaluator.this.symtbl.getSymbol(JavaQueryEvaluator.this.candidateAlias).setValue(arg1);
                    Object b = JavaQueryEvaluator.this.grouping[i].evaluate(JavaQueryEvaluator.this.evaluator);
                    int result = ((Comparable)a).compareTo(b);
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }
        });
        return Arrays.asList(o);
    }

    private List ordering(List set) {
        if (this.ordering == null) {
            return set;
        }
        Symbol symbol = new PropertySymbol("DATANUCLEUS_RESULTS_SET");
        if (this.symtbl.hasSymbol("DATANUCLEUS_RESULTS_SET")) {
            symbol = this.symtbl.getSymbol("DATANUCLEUS_RESULTS_SET");
        } else {
            this.symtbl.addSymbol(symbol);
        }
        symbol.setValue(set);
        Object[] o = set.toArray();
        Arrays.sort(o, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                for (int i = 0; i < JavaQueryEvaluator.this.ordering.length; ++i) {
                    JavaQueryEvaluator.this.symtbl.getSymbol(JavaQueryEvaluator.this.candidateAlias).setValue(arg0);
                    Object a = JavaQueryEvaluator.this.ordering[i].evaluate(new InMemoryExpressionEvaluator(JavaQueryEvaluator.this.query.getObjectManager().getOMFContext().getQueryManager(), JavaQueryEvaluator.this.symtbl, JavaQueryEvaluator.this.query.getParsedImports(), JavaQueryEvaluator.this.clr, JavaQueryEvaluator.this.candidateAlias));
                    JavaQueryEvaluator.this.symtbl.getSymbol(JavaQueryEvaluator.this.candidateAlias).setValue(arg1);
                    Object b = JavaQueryEvaluator.this.ordering[i].evaluate(new InMemoryExpressionEvaluator(JavaQueryEvaluator.this.query.getObjectManager().getOMFContext().getQueryManager(), JavaQueryEvaluator.this.symtbl, JavaQueryEvaluator.this.query.getParsedImports(), JavaQueryEvaluator.this.clr, JavaQueryEvaluator.this.candidateAlias));
                    int result = ((Comparable)a).compareTo(b);
                    if (result == 0) continue;
                    OrderExpression orderExpr = (OrderExpression)JavaQueryEvaluator.this.ordering[i];
                    if (orderExpr.getSortOrder() == null || orderExpr.getSortOrder().equals("ascending")) {
                        return result;
                    }
                    return -1 * result;
                }
                return 0;
            }
        });
        return Arrays.asList(o);
    }

    private List handleAggregates(List resultSet) {
        Comparator c = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                for (int i = 0; i < JavaQueryEvaluator.this.grouping.length; ++i) {
                    JavaQueryEvaluator.this.symtbl.getSymbol(JavaQueryEvaluator.this.candidateAlias).setValue(arg0);
                    Object a = JavaQueryEvaluator.this.grouping[i].evaluate(JavaQueryEvaluator.this.evaluator);
                    JavaQueryEvaluator.this.symtbl.getSymbol(JavaQueryEvaluator.this.candidateAlias).setValue(arg1);
                    Object b = JavaQueryEvaluator.this.grouping[i].evaluate(JavaQueryEvaluator.this.evaluator);
                    int result = ((Comparable)a).compareTo(b);
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }
        };
        ArrayList groups = new ArrayList();
        ArrayList group = new ArrayList();
        groups.add(group);
        for (int i = 0; i < resultSet.size(); ++i) {
            if (i > 0 && c.compare(resultSet.get(i - 1), resultSet.get(i)) != 0) {
                group = new ArrayList();
                groups.add(group);
            }
            group.add(resultSet.get(i));
        }
        ArrayList result = new ArrayList();
        if (this.having != null) {
            for (int i = 0; i < groups.size(); ++i) {
                if (!this.satisfiesHavingClause((List)groups.get(i))) continue;
                result.addAll((Collection)groups.get(i));
            }
        } else {
            for (int i = 0; i < groups.size(); ++i) {
                result.addAll((Collection)groups.get(i));
            }
        }
        return result;
    }

    private boolean satisfiesHavingClause(List set) {
        Symbol symbol = new PropertySymbol("DATANUCLEUS_RESULTS_SET");
        if (this.symtbl.hasSymbol("DATANUCLEUS_RESULTS_SET")) {
            symbol = this.symtbl.getSymbol("DATANUCLEUS_RESULTS_SET");
        } else {
            this.symtbl.addSymbol(symbol);
        }
        symbol.setValue(set);
        return this.having.evaluate(this.evaluator) == Boolean.TRUE;
    }

    private List handleResult(List resultSet) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.grouping != null) {
            int i;
            Comparator c = new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    if (JavaQueryEvaluator.this.grouping != null) {
                        for (int i = 0; i < JavaQueryEvaluator.this.grouping.length; ++i) {
                            JavaQueryEvaluator.this.symtbl.getSymbol(JavaQueryEvaluator.this.candidateAlias).setValue(arg0);
                            Object a = JavaQueryEvaluator.this.grouping[i].evaluate(JavaQueryEvaluator.this.evaluator);
                            JavaQueryEvaluator.this.symtbl.getSymbol(JavaQueryEvaluator.this.candidateAlias).setValue(arg1);
                            Object b = JavaQueryEvaluator.this.grouping[i].evaluate(JavaQueryEvaluator.this.evaluator);
                            int result = ((Comparable)a).compareTo(b);
                            if (result == 0) continue;
                            return result;
                        }
                    }
                    return 0;
                }
            };
            ArrayList groups = new ArrayList();
            List group = new ArrayList();
            if (resultSet.size() > 0) {
                groups.add(group);
            }
            for (i = 0; i < resultSet.size(); ++i) {
                if (i > 0 && c.compare(resultSet.get(i - 1), resultSet.get(i)) != 0) {
                    group = new ArrayList();
                    groups.add(group);
                }
                group.add(resultSet.get(i));
            }
            for (i = 0; i < groups.size(); ++i) {
                group = (List)groups.get(i);
                result.add(this.result(group));
            }
        } else {
            boolean aggregates = false;
            if (this.result.length > 0 && this.result[0] instanceof CreatorExpression) {
                Expression[] resExpr = ((CreatorExpression)this.result[0]).getParameters().toArray(new Expression[((CreatorExpression)this.result[0]).getParameters().size()]);
                for (int i = 0; i < resExpr.length; ++i) {
                    String method;
                    if (!(resExpr[i] instanceof InvokeExpression) || !(method = ((InvokeExpression)resExpr[i]).getOperation().toLowerCase()).equals("count") && !method.equals("sum") && !method.equals("avg") && !method.equals("min") && !method.equals("max")) continue;
                    aggregates = true;
                }
            } else {
                for (int i = 0; i < this.result.length; ++i) {
                    String method;
                    if (!(this.result[i] instanceof InvokeExpression) || !(method = ((InvokeExpression)this.result[i]).getOperation().toLowerCase()).equals("count") && !method.equals("sum") && !method.equals("avg") && !method.equals("min") && !method.equals("max")) continue;
                    aggregates = true;
                }
            }
            if (aggregates) {
                result.add(this.result(resultSet));
            } else {
                for (int i = 0; i < resultSet.size(); ++i) {
                    result.add(this.result(resultSet.get(i)));
                }
            }
        }
        if (result.size() > 0 && ((Object[])result.get(0)).length == 1) {
            ArrayList<Object> r = result;
            result = new ArrayList();
            for (int i = 0; i < r.size(); ++i) {
                result.add(((Object[])r.get(i))[0]);
            }
        }
        return result;
    }

    private Object[] result(Object obj) {
        Symbol symbol = this.symtbl.getSymbol(this.candidateAlias);
        symbol.setValue(obj);
        Object[] r = new Object[this.result.length];
        for (int i = 0; i < this.result.length; ++i) {
            r[i] = this.result[i].evaluate(this.evaluator);
        }
        return r;
    }

    private Object[] result(List set) {
        Symbol setSymbol = null;
        if (this.symtbl.hasSymbol("DATANUCLEUS_RESULTS_SET")) {
            setSymbol = this.symtbl.getSymbol("DATANUCLEUS_RESULTS_SET");
        } else {
            setSymbol = new PropertySymbol("DATANUCLEUS_RESULTS_SET");
            this.symtbl.addSymbol(setSymbol);
        }
        setSymbol.setValue(set);
        Symbol candidateSymbol = null;
        if (this.symtbl.hasSymbol(this.candidateAlias)) {
            candidateSymbol = this.symtbl.getSymbol(this.candidateAlias);
        } else {
            candidateSymbol = new PropertySymbol(this.candidateAlias);
            this.symtbl.addSymbol(candidateSymbol);
        }
        Object[] r = new Object[this.result.length];
        for (int j = 0; j < this.result.length; ++j) {
            Object element = set.get(0);
            candidateSymbol.setValue(element);
            r[j] = this.result[j].evaluate(this.evaluator);
        }
        return r;
    }

    abstract Collection mapResultClass(Collection var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

