/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata.xml;

import java.io.IOException;
import java.util.Stack;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AbstractMetaDataHandler
extends DefaultHandler {
    protected static Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = AbstractMetaDataHandler.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    protected final MetaDataManager mgr;
    protected final String filename;
    protected MetaData metadata;
    protected final EntityResolver entityResolver;
    protected StringBuffer charactersBuffer = new StringBuffer();
    protected Stack stack = new Stack();
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public AbstractMetaDataHandler(MetaDataManager mgr, String filename, EntityResolver resolver) {
        this.mgr = mgr;
        this.filename = filename;
        this.entityResolver = resolver;
    }

    public MetaData getMetaData() {
        return this.metadata;
    }

    public void error(SAXParseException e) throws SAXException {
        if (e.getColumnNumber() >= 0) {
            NucleusLogger.METADATA.warn(LOCALISER.msg("044039", (Object)this.filename, (Object)("" + e.getLineNumber()), (Object)("" + e.getColumnNumber()), (Object)e.getMessage()));
        } else {
            NucleusLogger.METADATA.warn(LOCALISER.msg("044038", (Object)this.filename, (Object)("" + e.getLineNumber()), (Object)e.getMessage()));
        }
    }

    protected String getAttr(Attributes attrs, String key, String defaultValue) {
        String result = attrs.getValue(key);
        if (result == null) {
            return defaultValue;
        }
        if (result.length() == 0) {
            return defaultValue;
        }
        return result;
    }

    protected String getAttr(Attributes attrs, String key) {
        return this.getAttr(attrs, key, null);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource source = null;
        if (this.entityResolver != null) {
            try {
                source = this.entityResolver.resolveEntity(publicId, systemId);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (source == null) {
            // empty if block
        }
        return source;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.charactersBuffer.append(ch, start, length);
    }

    public String getString() {
        String result = this.charactersBuffer.toString();
        this.charactersBuffer = new StringBuffer();
        return result;
    }

    protected MetaData getStack() {
        Object o = this.stack.lastElement();
        if (o != null) {
            return (MetaData)o;
        }
        return null;
    }

    protected MetaData popStack() {
        return (MetaData)this.stack.pop();
    }

    protected void pushStack(MetaData md) {
        this.stack.push(md);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

