/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ContainerComponent;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.StringUtils;

public class ArrayMetaData
extends ContainerMetaData {
    protected ContainerComponent element;
    protected boolean mayContainPersistenceCapableElements;
    static /* synthetic */ Class class$java$lang$Object;

    public ArrayMetaData(AbstractMemberMetaData parent, ArrayMetaData arrmd) {
        super(parent);
        this.element = new ContainerComponent();
        this.element.embedded = arrmd.element.embedded;
        this.element.serialized = arrmd.element.serialized;
        this.element.dependent = arrmd.element.dependent;
        this.element.type = arrmd.element.type;
        this.element.classMetaData = arrmd.element.classMetaData;
    }

    public ArrayMetaData(AbstractMemberMetaData parent, String elementType, String embeddedElement, String dependentElement, String serializedElement) {
        super(parent);
        if (!StringUtils.isWhitespace(elementType) && elementType.indexOf(44) > 0) {
            throw new InvalidMetaDataException(MetaData.LOCALISER, "044140", (Object)parent.getName(), parent.getClassName());
        }
        this.element = new ContainerComponent(parent.getAbstractClassMetaData().getPackageName(), elementType, embeddedElement, serializedElement, dependentElement);
        if (StringUtils.isWhitespace(elementType)) {
            this.element.type = null;
        }
    }

    public void populate(ClassLoaderResolver clr, ClassLoader primary) {
        String arrayComponentType;
        Class<?> component_type;
        ApiAdapter api = this.getMetaDataManager().getApiAdapter();
        Class field_type = this.getMemberMetaData().getType();
        if (!field_type.isArray()) {
            throw new InvalidMetaDataException(MetaData.LOCALISER, "044141", (Object)this.getFieldName(), this.getMemberMetaData().getClassName(false));
        }
        if (this.element.embedded == null) {
            component_type = field_type.getComponentType();
            this.element.embedded = this.getMetaDataManager().getOMFContext().getTypeManager().isDefaultEmbeddedType(component_type) ? Boolean.TRUE : (api.isPersistable(component_type) || (class$java$lang$Object == null ? (class$java$lang$Object = ArrayMetaData.class$("java.lang.Object")) : class$java$lang$Object).isAssignableFrom(component_type) || component_type.isInterface() ? Boolean.FALSE : Boolean.TRUE);
        }
        if (this.element.embedded == Boolean.FALSE && !api.isPersistable(component_type = field_type.getComponentType()) && !component_type.isInterface() && component_type != (class$java$lang$Object == null ? (class$java$lang$Object = ArrayMetaData.class$("java.lang.Object")) : class$java$lang$Object)) {
            this.element.embedded = Boolean.TRUE;
        }
        if (!(this.getMemberMetaData().getAbstractClassMetaData().getMetaDataManager().isEnhancing() || this.getMemberMetaData().isSerialized() || this.getMemberMetaData().getJoinMetaData() != null || api.isPersistable(this.getMemberMetaData().getType().getComponentType()) || !this.getMetaDataManager().supportsORM() || (arrayComponentType = this.getMemberMetaData().getType().getComponentType().getName()).equals(ClassNameConstants.BOOLEAN) || arrayComponentType.equals(ClassNameConstants.BYTE) || arrayComponentType.equals(ClassNameConstants.CHAR) || arrayComponentType.equals(ClassNameConstants.DOUBLE) || arrayComponentType.equals(ClassNameConstants.FLOAT) || arrayComponentType.equals(ClassNameConstants.INT) || arrayComponentType.equals(ClassNameConstants.LONG) || arrayComponentType.equals(ClassNameConstants.SHORT) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_BOOLEAN) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_BYTE) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_CHARACTER) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_DOUBLE) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_FLOAT) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_INTEGER) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_LONG) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_SHORT) || arrayComponentType.equals(ClassNameConstants.JAVA_MATH_BIGDECIMAL) || arrayComponentType.equals(ClassNameConstants.JAVA_MATH_BIGINTEGER))) {
            throw new InvalidMetaDataException(MetaData.LOCALISER, "044142", (Object)this.getFieldName(), this.getMemberMetaData().getType().getComponentType().getName());
        }
        MetaDataManager mmgr = this.getMemberMetaData().getAbstractClassMetaData().getMetaDataManager();
        if (this.element.type != null) {
            Class elementCls = clr.classForName(this.element.type, primary);
            if (api.isPersistable(elementCls)) {
                this.mayContainPersistenceCapableElements = true;
            }
            this.element.classMetaData = mmgr.getMetaDataForClassInternal(elementCls, clr);
        } else {
            this.element.type = field_type.getComponentType().getName();
            this.element.classMetaData = mmgr.getMetaDataForClassInternal(field_type.getComponentType(), clr);
        }
        if (this.element.classMetaData != null) {
            this.mayContainPersistenceCapableElements = true;
        }
        this.setPopulated();
    }

    public String getElementType() {
        return this.element.type;
    }

    public boolean elementIsPersistent() {
        return this.element.classMetaData != null;
    }

    public AbstractClassMetaData getElementClassMetaData() {
        if (this.element.classMetaData != null && !this.element.classMetaData.isInitialised()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ArrayMetaData.this.element.classMetaData.initialise();
                    return null;
                }
            });
        }
        return this.element.classMetaData;
    }

    public boolean mayContainPersistenceCapableElements() {
        return this.mayContainPersistenceCapableElements;
    }

    public boolean isEmbeddedElement() {
        if (this.element.embedded == null) {
            return false;
        }
        return this.element.embedded;
    }

    public boolean isSerializedElement() {
        if (this.element.serialized == null) {
            return false;
        }
        return this.element.serialized;
    }

    public boolean isDependentElement() {
        if (this.element.dependent == null) {
            return false;
        }
        return this.element.dependent;
    }

    void getReferencedClassMetaData(List orderedCMDs, Set referencedCMDs, String dba_vendor_id, ClassLoaderResolver clr) {
        AbstractClassMetaData element_cmd = this.getMetaDataManager().getMetaDataForClass(this.getMemberMetaData().getType().getComponentType(), clr);
        if (element_cmd != null) {
            element_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, clr);
        }
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<array");
        if (this.element.type != null) {
            sb.append(" element-type=\"").append(this.element.type).append("\"");
        }
        if (this.element.embedded != null) {
            sb.append(" embedded-element=\"").append(this.element.embedded).append("\"");
        }
        if (this.element.serialized != null) {
            sb.append(" serialized-element=\"").append(this.element.serialized).append("\"");
        }
        if (this.element.dependent != null) {
            sb.append(" dependent-element=\"").append(this.element.dependent).append("\"");
        }
        if (this.getNoOfExtensions() > 0) {
            sb.append(">\n");
            sb.append(super.toString(prefix + indent, indent));
            sb.append(prefix).append("</array>\n");
        } else {
            sb.append(prefix).append("/>\n");
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

