/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManagerHelper;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.WeakValueMap;

public class DefaultLevel2Cache
implements Level2Cache {
    private static Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerImpl == null ? (class$org$datanucleus$ObjectManagerImpl = DefaultLevel2Cache.class$("org.datanucleus.ObjectManagerImpl")) : class$org$datanucleus$ObjectManagerImpl).getClassLoader());
    protected Collection pinnedClasses;
    protected Collection pinnedIds;
    protected Map pinnedCache;
    protected Map unpinnedCache;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerImpl;

    protected DefaultLevel2Cache() {
    }

    public DefaultLevel2Cache(OMFContext omfCtx) {
        this.pinnedCache = new HashMap();
        this.unpinnedCache = new WeakValueMap();
    }

    public void close() {
        this.clear();
        this.pinnedCache = null;
        this.unpinnedCache = null;
    }

    public synchronized void evict(Object oid) {
        if (oid == null) {
            return;
        }
        this.unpinnedCache.remove(oid);
        this.pinnedCache.remove(oid);
    }

    public synchronized void evictAll() {
        this.unpinnedCache.clear();
        this.pinnedCache.clear();
    }

    public synchronized void evictAll(Class pcClass, boolean subclasses) {
        if (pcClass == null) {
            return;
        }
        HashSet oidsToEvict = new HashSet();
        Set pinnedObjects = this.pinnedCache.entrySet();
        Iterator pinnedIter = pinnedObjects.iterator();
        while (pinnedIter.hasNext()) {
            Map.Entry entry = (Map.Entry)pinnedIter.next();
            CachedPC pc = (CachedPC)entry.getValue();
            if (!pcClass.getName().equals(pc.getPCClass().getName()) && (!subclasses || !pcClass.isAssignableFrom(pc.getPCClass()))) continue;
            oidsToEvict.add(entry.getKey());
        }
        Set unpinnedObjects = this.unpinnedCache.entrySet();
        Iterator unpinnedIter = unpinnedObjects.iterator();
        while (unpinnedIter.hasNext()) {
            Map.Entry entry = (Map.Entry)unpinnedIter.next();
            CachedPC pc = (CachedPC)entry.getValue();
            if ((pc == null || !pcClass.getName().equals(pc.getPCClass().getName())) && (!subclasses || !pcClass.isAssignableFrom(pc.getPCClass()))) continue;
            oidsToEvict.add(entry.getKey());
        }
        if (!oidsToEvict.isEmpty()) {
            this.evictAll(oidsToEvict);
        }
    }

    public synchronized void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public synchronized void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    public synchronized void pin(Object oid) {
        if (oid == null) {
            return;
        }
        if (this.pinnedIds == null) {
            this.pinnedIds = new HashSet();
        } else if (!this.pinnedIds.contains(oid)) {
            this.pinnedIds.add(oid);
        }
        Object pc = this.unpinnedCache.get(oid);
        if (pc != null) {
            this.pinnedCache.put(oid, pc);
            this.unpinnedCache.remove(oid);
        }
    }

    public synchronized void pinAll(Class cls, boolean subs) {
        Level2Cache.PinnedClass pinnedCls;
        if (cls == null) {
            return;
        }
        if (this.pinnedClasses == null) {
            this.pinnedClasses = new HashSet();
        }
        if (this.pinnedClasses.contains(pinnedCls = new Level2Cache.PinnedClass(cls, subs))) {
            return;
        }
        this.pinnedClasses.add(pinnedCls);
        Collection unpinnedObjects = this.unpinnedCache.values();
        Iterator unpinnedIter = unpinnedObjects.iterator();
        while (unpinnedIter.hasNext()) {
            CachedPC obj = (CachedPC)unpinnedIter.next();
            if ((!subs || !cls.isInstance(obj.getPCClass())) && !cls.getName().equals(obj.getPCClass().getName())) continue;
            this.pin(obj);
        }
    }

    public synchronized void pinAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.pin(iter.next());
        }
    }

    public synchronized void pinAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.pin(oids[i]);
        }
    }

    public synchronized void unpin(Object oid) {
        if (oid == null) {
            return;
        }
        Object pc = this.pinnedCache.get(oid);
        if (pc != null) {
            this.unpinnedCache.put(oid, pc);
            this.pinnedCache.remove(oid);
        }
        if (this.pinnedIds != null && this.pinnedIds.contains(oid)) {
            this.pinnedIds.remove(oid);
        }
    }

    public synchronized void unpinAll(Class cls, boolean subs) {
        if (cls == null) {
            return;
        }
        if (this.pinnedClasses != null) {
            Level2Cache.PinnedClass pinnedCls = new Level2Cache.PinnedClass(cls, subs);
            this.pinnedClasses.remove(pinnedCls);
        }
        Collection pinnedObjects = this.pinnedCache.values();
        Iterator pinnedIter = pinnedObjects.iterator();
        while (pinnedIter.hasNext()) {
            CachedPC obj = (CachedPC)pinnedIter.next();
            if ((!subs || !cls.isInstance(obj.getPCClass())) && !cls.getName().equals(obj.getPCClass().getName())) continue;
            this.unpin(obj);
        }
    }

    public synchronized void unpinAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.unpin(iter.next());
        }
    }

    public synchronized void unpinAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.unpin(oids[i]);
        }
    }

    public void clear() {
        this.pinnedCache.clear();
        this.unpinnedCache.clear();
    }

    public synchronized CachedPC get(Object oid) {
        if (oid == null) {
            return null;
        }
        CachedPC pc = (CachedPC)this.pinnedCache.get(oid);
        if (pc != null) {
            return pc;
        }
        pc = (CachedPC)this.unpinnedCache.get(oid);
        return pc;
    }

    public int getNumberOfPinnedObjects() {
        return this.pinnedCache.size();
    }

    public int getNumberOfUnpinnedObjects() {
        return this.unpinnedCache.size();
    }

    public int getSize() {
        return this.getNumberOfPinnedObjects() + this.getNumberOfUnpinnedObjects();
    }

    public synchronized CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            NucleusLogger.CACHE.warn(LOCALISER.msg("004011"));
            return null;
        }
        if (ObjectManagerHelper.getObjectManager(pc.getPersistableObject()) != null) {
            NucleusLogger.CACHE.error(LOCALISER.msg("004012", oid));
            return null;
        }
        boolean toBePinned = false;
        if (this.pinnedClasses != null) {
            Iterator pinnedClsIter = this.pinnedClasses.iterator();
            while (pinnedClsIter.hasNext()) {
                Level2Cache.PinnedClass pinCls = (Level2Cache.PinnedClass)pinnedClsIter.next();
                if (!pinCls.cls.getName().equals(pc.getPCClass().getName()) && (!pinCls.subclasses || !pinCls.cls.isAssignableFrom(pc.getPCClass()))) continue;
                toBePinned = true;
                break;
            }
        }
        if (this.pinnedIds != null && this.pinnedIds.contains(oid)) {
            toBePinned = true;
        }
        CachedPC obj = null;
        if (this.pinnedCache.get(oid) != null) {
            obj = this.pinnedCache.put(oid, pc);
            if (obj != null) {
                return obj;
            }
        } else if (toBePinned) {
            this.pinnedCache.put(oid, pc);
            this.unpinnedCache.remove(oid);
        } else {
            obj = this.unpinnedCache.put(oid, pc);
            if (obj != null) {
                return obj;
            }
        }
        return null;
    }

    public boolean containsOid(Object oid) {
        return this.pinnedCache.containsKey(oid) || this.unpinnedCache.containsKey(oid);
    }

    public boolean isEmpty() {
        return this.pinnedCache.isEmpty() && this.unpinnedCache.isEmpty();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

