/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.transaction.Synchronization;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.TransactionActiveOnBeginException;
import org.datanucleus.exceptions.TransactionNotActiveException;
import org.datanucleus.transaction.HeuristicMixedException;
import org.datanucleus.transaction.HeuristicRollbackException;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.transaction.RollbackException;
import org.datanucleus.transaction.Transaction;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class TransactionImpl
implements org.datanucleus.Transaction {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = TransactionImpl.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    ObjectManager om;
    Transaction tx;
    boolean active = false;
    boolean committing;
    Synchronization sync;
    protected boolean retainValues;
    protected boolean restoreValues;
    protected boolean optimistic;
    protected boolean nontransactionalRead;
    protected boolean nontransactionalWrite;
    protected boolean rollbackOnly = false;
    private Set listeners = new HashSet();
    private Map options = new HashMap();
    long beginTime;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    TransactionImpl(ObjectManager om) {
        this.om = om;
        PersistenceConfiguration config = om.getOMFContext().getPersistenceConfiguration();
        this.optimistic = config.getBooleanProperty("datanucleus.Optimistic");
        this.retainValues = config.getBooleanProperty("datanucleus.RetainValues");
        this.restoreValues = config.getBooleanProperty("datanucleus.RestoreValues");
        this.nontransactionalRead = config.getBooleanProperty("datanucleus.NontransactionalRead");
        this.nontransactionalWrite = config.getBooleanProperty("datanucleus.NontransactionalWrite");
        int isolationLevel = TransactionUtils.getTransactionIsolationLevelForName(config.getStringProperty("datanucleus.transactionIsolation"));
        this.setOption("transaction.isolation", isolationLevel);
        this.setOption("transaction.serializeReadObjects", config.getBooleanProperty("datanucleus.rdbms.useUpdateLock"));
    }

    public void begin() {
        this.om.getOMFContext().getTransactionManager().begin(this.om);
        this.tx = this.om.getOMFContext().getTransactionManager().getTransaction(this.om);
        this.internalBegin();
    }

    protected void internalBegin() {
        if (this.active) {
            throw new TransactionActiveOnBeginException(this);
        }
        this.active = true;
        this.beginTime = System.currentTimeMillis();
        if (this.om.getOMFContext().getTransactionManager().getTransactionRuntime() != null) {
            this.om.getOMFContext().getTransactionManager().getTransactionRuntime().transactionStarted();
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015000", this.om, (Object)("" + this.optimistic)));
        }
        TransactionEventListener[] tel = this.listeners.toArray(new TransactionEventListener[this.listeners.size()]);
        for (int i = 0; i < tel.length; ++i) {
            tel[i].transactionStarted();
        }
        this.om.postBegin();
    }

    public void flush() {
        try {
            TransactionEventListener[] tel = this.listeners.toArray(new TransactionEventListener[this.listeners.size()]);
            for (int i = 0; i < tel.length; ++i) {
                tel[i].transactionFlushed();
            }
        }
        catch (Throwable ex) {
            if (ex instanceof NucleusException) {
                throw (NucleusException)ex;
            }
            throw new NucleusTransactionException(LOCALISER.msg("015005"), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        try {
            this.flush();
        }
        finally {
            TransactionEventListener[] tel = this.listeners.toArray(new TransactionEventListener[this.listeners.size()]);
            for (int i = 0; i < tel.length; ++i) {
                tel[i].transactionEnded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (!this.isActive()) {
            throw new TransactionNotActiveException();
        }
        if (this.rollbackOnly) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015020"));
            }
            throw new NucleusDataStoreException(LOCALISER.msg("015020")).setFatal();
        }
        long startTime = System.currentTimeMillis();
        boolean success = false;
        boolean canComplete = true;
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.flush();
            this.internalPreCommit();
            this.internalCommit();
            success = true;
        }
        catch (RollbackException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        catch (HeuristicRollbackException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        catch (HeuristicMixedException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        catch (NucleusUserException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            canComplete = false;
            throw e;
        }
        catch (NucleusException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        finally {
            if (canComplete) {
                try {
                    if (!success) {
                        this.rollback();
                    } else {
                        this.internalPostCommit();
                    }
                }
                catch (Throwable e) {
                    errors.add(e);
                }
                this.tx = null;
            }
        }
        if (errors.size() > 0) {
            throw new NucleusTransactionException(LOCALISER.msg("015007"), errors.toArray(new Throwable[errors.size()]));
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015022", System.currentTimeMillis() - startTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalPreCommit() {
        this.committing = true;
        try {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015001", this.om));
            }
            if (this.sync != null) {
                this.sync.beforeCompletion();
            }
            this.om.preCommit();
        }
        finally {
            TransactionEventListener[] tel = this.listeners.toArray(new TransactionEventListener[this.listeners.size()]);
            for (int i = 0; i < tel.length; ++i) {
                tel[i].transactionPreCommit();
            }
        }
    }

    protected void internalCommit() {
        this.om.getOMFContext().getTransactionManager().commit(this.om);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void rollback() {
        block41: {
            if (!this.isActive()) {
                throw new TransactionNotActiveException();
            }
            startTime = System.currentTimeMillis();
            try {
                canComplete = true;
                this.committing = true;
                try {
                    this.flush();
                    var5_5 = null;
                }
                catch (Throwable var4_15) {
                    var5_6 = null;
                    try {
                        try {
                            this.internalPreRollback();
                        }
                        catch (NucleusUserException e) {
                            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
                            }
                            canComplete = false;
                            throw e;
                        }
                        var8_9 = null;
                        if (canComplete) {
                            this.internalRollback();
                        }
                    }
                    catch (Throwable var7_14) {
                        var8_10 = null;
                        if (canComplete) {
                            this.internalRollback();
                        }
                        throw var7_14;
                    }
                    throw var4_15;
                }
                try {
                    try {
                        this.internalPreRollback();
                    }
                    catch (NucleusUserException e) {
                        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                            NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
                        }
                        canComplete = false;
                        throw e;
                    }
                    var8_7 = null;
                    if (canComplete) {
                        this.internalRollback();
                    }
                }
                catch (Throwable var7_13) {
                    var8_8 = null;
                    if (canComplete) {
                        this.internalRollback();
                    }
                    throw var7_13;
                }
                var10_16 = null;
                try {
                    if (canComplete) {
                        try {
                            this.active = false;
                            if (this.om.getOMFContext().getTransactionManager().getTransactionRuntime() != null) {
                                this.om.getOMFContext().getTransactionManager().getTransactionRuntime().transactionRolledBack(System.currentTimeMillis() - this.beginTime);
                            }
                            tel = this.listeners.toArray(new TransactionEventListener[this.listeners.size()]);
                            for (i = 0; i < tel.length; ++i) {
                                tel[i].transactionRolledBack();
                            }
                            var14_22 = null;
                            this.listeners.clear();
                            this.rollbackOnly = false;
                            this.tx = null;
                            ** if (this.sync == null) goto lbl-1000
                        }
                        catch (Throwable var13_26) {
                            var14_23 = null;
                            this.listeners.clear();
                            this.rollbackOnly = false;
                            this.tx = null;
                            if (this.sync != null) {
                                this.sync.afterCompletion(4);
                            }
                            throw var13_26;
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.sync.afterCompletion(4);
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                    v0 = null;
                }
                catch (Throwable var15_28) {
                    v0 = null;
                }
                var16_30 = v0;
                this.committing = false;
                {
                    break block41;
                }
                catch (Throwable var9_32) {
                    var10_17 = null;
                    try {
                        if (canComplete) {
                            try {
                                this.active = false;
                                if (this.om.getOMFContext().getTransactionManager().getTransactionRuntime() != null) {
                                    this.om.getOMFContext().getTransactionManager().getTransactionRuntime().transactionRolledBack(System.currentTimeMillis() - this.beginTime);
                                }
                                tel = this.listeners.toArray(new TransactionEventListener[this.listeners.size()]);
                                for (i = 0; i < tel.length; ++i) {
                                    tel[i].transactionRolledBack();
                                }
                                var14_24 = null;
                                this.listeners.clear();
                                this.rollbackOnly = false;
                                this.tx = null;
                                ** if (this.sync == null) goto lbl-1000
                            }
                            catch (Throwable var13_27) {
                                var14_25 = null;
                                this.listeners.clear();
                                this.rollbackOnly = false;
                                this.tx = null;
                                if (this.sync != null) {
                                    this.sync.afterCompletion(4);
                                }
                                throw var13_27;
                            }
lbl-1000:
                            // 1 sources

                            {
                                this.sync.afterCompletion(4);
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                        }
                        v1 = null;
                    }
                    catch (Throwable var15_29) {
                        v1 = null;
                    }
                    var16_31 = v1;
                    this.committing = false;
                    throw var9_32;
                }
            }
            catch (NucleusUserException e) {
                throw e;
            }
            catch (NucleusException e) {
                throw new NucleusDataStoreException(TransactionImpl.LOCALISER.msg("015009"), e);
            }
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(TransactionImpl.LOCALISER.msg("015023", System.currentTimeMillis() - startTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalPreRollback() {
        TransactionEventListener[] tel2;
        try {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015002", this.om));
            }
            this.om.preRollback();
            Object var2_1 = null;
            tel2 = this.listeners.toArray(new TransactionEventListener[this.listeners.size()]);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            TransactionEventListener[] tel2 = this.listeners.toArray(new TransactionEventListener[this.listeners.size()]);
            for (int i = 0; i < tel2.length; ++i) {
                tel2[i].transactionPreRollBack();
            }
            throw throwable;
        }
        for (int i = 0; i < tel2.length; ++i) {
            tel2[i].transactionPreRollBack();
        }
    }

    protected void internalRollback() {
        Transaction tx = this.om.getOMFContext().getTransactionManager().getTransaction(this.om);
        if (tx != null) {
            this.om.getOMFContext().getTransactionManager().rollback(this.om);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void internalPostCommit() {
        block22: {
            Object v0;
            this.active = false;
            if (this.om.getOMFContext().getTransactionManager().getTransactionRuntime() != null) {
                this.om.getOMFContext().getTransactionManager().getTransactionRuntime().transactionCommitted(System.currentTimeMillis() - this.beginTime);
            }
            Object var2_1 = null;
            this.om.postCommit();
            Object var4_3 = null;
            this.committing = false;
            try {
                TransactionEventListener[] tel = this.listeners.toArray(new TransactionEventListener[this.listeners.size()]);
                for (int i = 0; i < tel.length; ++i) {
                    tel[i].transactionCommitted();
                }
                v0 = null;
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var8_19 = v0;
            this.listeners.clear();
            if (this.sync != null) {
                this.sync.afterCompletion(3);
            }
            break block22;
            catch (Throwable throwable) {
                Object v1;
                Object var4_4 = null;
                this.committing = false;
                try {
                    TransactionEventListener[] tel = this.listeners.toArray(new TransactionEventListener[this.listeners.size()]);
                    for (int i = 0; i < tel.length; ++i) {
                        tel[i].transactionCommitted();
                    }
                    v1 = null;
                }
                catch (Throwable throwable2) {
                    v1 = null;
                }
                Object var8_20 = v1;
                this.listeners.clear();
                if (this.sync != null) {
                    this.sync.afterCompletion(3);
                }
                throw throwable;
            }
            catch (Throwable throwable) {
                block23: {
                    Object v2;
                    Object var2_2 = null;
                    this.om.postCommit();
                    Object var4_5 = null;
                    this.committing = false;
                    try {
                        TransactionEventListener[] tel = this.listeners.toArray(new TransactionEventListener[this.listeners.size()]);
                        for (int i = 0; i < tel.length; ++i) {
                            tel[i].transactionCommitted();
                        }
                        v2 = null;
                    }
                    catch (Throwable throwable3) {
                        v2 = null;
                    }
                    Object var8_21 = v2;
                    this.listeners.clear();
                    if (this.sync != null) {
                        this.sync.afterCompletion(3);
                    }
                    break block23;
                    catch (Throwable throwable4) {
                        Object v3;
                        Object var4_6 = null;
                        this.committing = false;
                        try {
                            TransactionEventListener[] tel = this.listeners.toArray(new TransactionEventListener[this.listeners.size()]);
                            for (int i = 0; i < tel.length; ++i) {
                                tel[i].transactionCommitted();
                            }
                            v3 = null;
                        }
                        catch (Throwable throwable5) {
                            v3 = null;
                        }
                        Object var8_22 = v3;
                        this.listeners.clear();
                        if (this.sync != null) {
                            this.sync.afterCompletion(3);
                        }
                        throw throwable4;
                    }
                }
                throw throwable;
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isCommitting() {
        return this.committing;
    }

    public boolean getNontransactionalRead() {
        return this.nontransactionalRead;
    }

    public boolean getNontransactionalWrite() {
        return this.nontransactionalWrite;
    }

    public boolean getOptimistic() {
        return this.optimistic;
    }

    public boolean getRestoreValues() {
        return this.restoreValues;
    }

    public boolean getRetainValues() {
        return this.retainValues;
    }

    public boolean getRollbackOnly() {
        return this.rollbackOnly;
    }

    public Synchronization getSynchronization() {
        return this.sync;
    }

    public void setNontransactionalRead(boolean nontransactionalRead) {
        this.nontransactionalRead = nontransactionalRead;
    }

    public synchronized void setNontransactionalWrite(boolean nontransactionalWrite) {
        this.nontransactionalWrite = nontransactionalWrite;
    }

    public synchronized void setOptimistic(boolean optimistic) {
        this.optimistic = optimistic;
    }

    public synchronized void setRestoreValues(boolean restoreValues) {
        this.restoreValues = restoreValues;
    }

    public synchronized void setRetainValues(boolean retainValues) {
        this.retainValues = retainValues;
        if (retainValues) {
            this.nontransactionalRead = true;
        }
    }

    public void setRollbackOnly() {
        if (this.active) {
            this.rollbackOnly = true;
        }
    }

    public synchronized void setSynchronization(Synchronization sync) {
        this.sync = sync;
    }

    public void addTransactionEventListener(TransactionEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeTransactionEventListener(TransactionEventListener listener) {
        this.listeners.remove(listener);
    }

    public Map getOptions() {
        return this.options;
    }

    public void setOption(String option, int value) {
        this.options.put(option, new Integer(value));
    }

    public void setOption(String option, boolean value) {
        this.options.put(option, new Boolean(value));
    }

    public void setOption(String option, String value) {
        this.options.put(option, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

