/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.NotSupportedException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.datanucleus.ObjectManager;
import org.datanucleus.TransactionImpl;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.util.NucleusLogger;

public class JTATransactionImpl
extends TransactionImpl
implements Synchronization {
    private static final int JOIN_STATUS_NO_TXN = 0;
    private static final int JOIN_STATUS_IMPOSSIBLE = 1;
    private static final int JOIN_STATUS_JOINED = 2;
    private TransactionManager tm;
    private Transaction jtaTx;
    protected int joinStatus = 0;
    private UserTransaction userTransaction;
    private static boolean INSIDE_JBOSS = System.getProperty("jboss.server.name") != null;

    JTATransactionImpl(ObjectManager om) {
        super(om);
        om.getOMFContext().getTransactionManager().setContainerManagedConnections(true);
        this.tm = this.obtainTransactionManager();
        this.checkTransactionJoin();
    }

    protected void checkTransactionJoin() {
        if (this.joinStatus != 2) {
            try {
                Transaction txn = this.tm.getTransaction();
                int txnstat = this.tm.getStatus();
                if (this.jtaTx != null && !this.jtaTx.equals(txn)) {
                    if (this.joinStatus != 1) {
                        throw new InternalError("JTA Transaction changed without being notified");
                    }
                    this.jtaTx = null;
                    this.joinStatus = 0;
                    this.checkTransactionJoin();
                } else if (this.jtaTx == null) {
                    this.jtaTx = txn;
                    boolean allow_join = this.canJoinTransaction(txnstat);
                    if (allow_join) {
                        this.joinStatus = 1;
                        this.execJoinTransaction();
                        this.joinStatus = 2;
                    } else if (this.jtaTx != null) {
                        this.joinStatus = 1;
                    }
                }
            }
            catch (SystemException e) {
                throw new NucleusTransactionException(TransactionImpl.LOCALISER.msg("015026"), e);
            }
        }
    }

    private void execJoinTransaction() {
        try {
            this.jtaTx.registerSynchronization((Synchronization)this);
            boolean was_active = super.isActive();
            if (!was_active) {
                this.internalBegin();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NucleusTransactionException("Cannot register Synchronization to a valid JTA Transaction");
        }
    }

    private boolean canJoinTransaction(int txnstat) {
        return txnstat == 0;
    }

    public boolean isActive() {
        this.checkTransactionJoin();
        boolean is_active = super.isActive();
        return is_active || this.jtaTx != null && this.joinStatus == 1;
    }

    public void begin() {
        UserTransaction utx;
        this.checkTransactionJoin();
        if (this.joinStatus != 0) {
            throw new NucleusTransactionException("JTA Transaction is already active");
        }
        try {
            utx = this.getUserTransaction();
        }
        catch (NamingException e) {
            throw this.om.getApiAdapter().getExceptionForException("Failed to obtain UserTransaction", e);
        }
        try {
            utx.begin();
        }
        catch (NotSupportedException e) {
            throw this.om.getApiAdapter().getExceptionForException("Failed to begin UserTransaction", (Exception)((Object)e));
        }
        catch (SystemException e) {
            throw this.om.getApiAdapter().getExceptionForException("Failed to begin UserTransaction", (Exception)((Object)e));
        }
        this.checkTransactionJoin();
        if (this.joinStatus != 2) {
            throw new NucleusTransactionException("Cannot join an auto started UserTransaction");
        }
        this.userTransaction = utx;
    }

    public void commit() {
        if (this.userTransaction == null) {
            throw new NucleusTransactionException("No internal UserTransaction");
        }
        try {
            try {
                this.userTransaction.commit();
            }
            catch (Exception e) {
                throw this.om.getApiAdapter().getExceptionForException("Failed to commit UserTransaction", e);
            }
            Object var3_1 = null;
            this.userTransaction = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.userTransaction = null;
            throw throwable;
        }
    }

    public void rollback() {
        if (this.userTransaction == null) {
            throw new NucleusTransactionException("No internal UserTransaction");
        }
        try {
            try {
                this.userTransaction.rollback();
            }
            catch (Exception e) {
                throw this.om.getApiAdapter().getExceptionForException("Failed to rollback UserTransaction", e);
            }
            Object var3_1 = null;
            this.userTransaction = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.userTransaction = null;
            throw throwable;
        }
    }

    public void setRollbackOnly() {
        if (this.userTransaction == null) {
            throw new NucleusTransactionException("No internal UserTransaction");
        }
        try {
            this.userTransaction.setRollbackOnly();
        }
        catch (Exception e) {
            throw this.om.getApiAdapter().getExceptionForException("Failed to rollback-only UserTransaction", e);
        }
    }

    private TransactionManager obtainTransactionManager() {
        TransactionManager tm = this.om.getOMFContext().getJtaTransactionManager();
        if (tm == null) {
            throw new NucleusTransactionException(TransactionImpl.LOCALISER.msg("015030"));
        }
        return tm;
    }

    private UserTransaction getUserTransaction() throws NamingException {
        InitialContext ctx = new InitialContext();
        UserTransaction ut = INSIDE_JBOSS ? (UserTransaction)ctx.lookup("UserTransaction") : (UserTransaction)ctx.lookup("java:comp/UserTransaction");
        return ut;
    }

    public void beforeCompletion() {
        try {
            this.flush();
            this.internalPreCommit();
        }
        catch (Throwable th) {
            NucleusLogger.TRANSACTION.error("Exception flushing work in JTA transaction. Mark for rollback", th);
            try {
                this.jtaTx.setRollbackOnly();
            }
            catch (Exception e) {
                NucleusLogger.TRANSACTION.fatal("Cannot mark transaction for rollback after exception in beforeCompletion. PersistenceManager might be in inconsistent state", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterCompletion(int status) {
        try {
            block7: {
                try {
                    if (status == 4) {
                        super.rollback();
                        break block7;
                    }
                    if (status == 3) {
                        this.internalPostCommit();
                        break block7;
                    }
                    NucleusLogger.TRANSACTION.fatal("Received unexpected transaction status + " + status);
                }
                catch (Throwable th) {
                    NucleusLogger.TRANSACTION.error("Exception during afterCompletion in JTA transaction. PersistenceManager might be in inconsistent state", th);
                    Object var4_3 = null;
                    this.jtaTx = null;
                    this.joinStatus = 0;
                }
            }
            Object var4_2 = null;
            this.jtaTx = null;
            this.joinStatus = 0;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.jtaTx = null;
            this.joinStatus = 0;
            throw throwable;
        }
        if (this.active) {
            throw new NucleusTransactionException("internal error, must not be active after afterCompletion()!");
        }
    }
}

