/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.sco.backed;

import java.io.ObjectStreamException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.sco.NullsNotAllowedException;
import org.datanucleus.sco.SCOMap;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.sco.backed.Set;
import org.datanucleus.sco.queued.ClearOperation;
import org.datanucleus.sco.queued.PutOperation;
import org.datanucleus.sco.queued.QueuedOperation;
import org.datanucleus.sco.queued.RemoveOperation;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class TreeMap
extends java.util.TreeMap
implements SCOMap,
Cloneable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = TreeMap.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    private transient Object owner;
    private transient StateManager ownerSM;
    private transient String fieldName;
    private transient int fieldNumber;
    private transient boolean allowNulls;
    protected MapStore backingStore;
    protected java.util.TreeMap delegate;
    protected boolean useCache = true;
    protected boolean isCacheLoaded = false;
    boolean queued = false;
    private ArrayList queuedOperations = null;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;
    static /* synthetic */ Class class$java$util$TreeMap;

    public TreeMap(StateManager ownerSM, String fieldName) {
        this.ownerSM = ownerSM;
        this.fieldName = fieldName;
        this.allowNulls = false;
        if (ownerSM == null) {
            this.delegate = new java.util.TreeMap();
        }
        if (ownerSM != null) {
            Comparator comparator;
            AbstractMemberMetaData fmd = ownerSM.getClassMetaData().getMetaDataForMember(fieldName);
            this.owner = ownerSM.getObject();
            this.fieldNumber = fmd.getAbsoluteFieldNumber();
            this.allowNulls = SCOUtils.allowNullsInContainer(this.allowNulls, fmd);
            this.queued = SCOUtils.useContainerQueueing(ownerSM);
            this.useCache = SCOUtils.useContainerCache(ownerSM, fieldName);
            if (!SCOUtils.mapHasSerialisedKeysAndValues(fmd) && fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                try {
                    ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
                    this.backingStore = (MapStore)ownerSM.getStoreManager().getBackingStoreForField(clr, fmd, class$java$util$TreeMap == null ? (class$java$util$TreeMap = TreeMap.class$("java.util.TreeMap")) : class$java$util$TreeMap);
                }
                catch (UnsupportedOperationException ex) {
                    // empty catch block
                }
            }
            this.delegate = (comparator = SCOUtils.getComparator(fmd, ownerSM.getObjectManager().getClassLoaderResolver())) != null ? new java.util.TreeMap(comparator) : new java.util.TreeMap();
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(ownerSM, fieldName, this, this.useCache, this.queued, this.allowNulls, SCOUtils.useCachedLazyLoading(ownerSM, fieldName)));
            }
        }
    }

    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Map m = (Map)o;
        if (m != null) {
            AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
            if (SCOUtils.mapHasSerialisedKeysAndValues(fmd) && (fmd.getMap().getKeyClassMetaData() != null || fmd.getMap().getValueClassMetaData() != null)) {
                ObjectManager om = this.ownerSM.getObjectManager();
                Iterator iter = m.entrySet().iterator();
                while (iter.hasNext()) {
                    StateManager objSM;
                    Map.Entry entry = iter.next();
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (fmd.getMap().getKeyClassMetaData() != null && (objSM = om.findStateManager(key)) == null) {
                        objSM = StateManagerFactory.newStateManagerForEmbedded(om, key, false);
                        objSM.addEmbeddedOwner(this.ownerSM, this.fieldNumber);
                    }
                    if (fmd.getMap().getValueClassMetaData() == null || (objSM = om.findStateManager(value)) != null) continue;
                    objSM = StateManagerFactory.newStateManagerForEmbedded(om, value, false);
                    objSM.addEmbeddedOwner(this.ownerSM, this.fieldNumber);
                }
            }
            if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
                this.isCacheLoaded = true;
            }
            if (forInsert) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName, (Object)("" + m.size())));
                }
                this.putAll(m);
            } else if (forUpdate) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023008", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName, (Object)("" + m.size())));
                }
                this.clear();
                this.putAll(m);
            } else {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName, (Object)("" + m.size())));
                }
                this.delegate.clear();
                this.delegate.putAll(m);
            }
        }
    }

    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerSM, this.fieldName)) {
            this.loadFromStore();
        }
    }

    public Object getValue() {
        this.loadFromStore();
        return this.delegate;
    }

    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    public boolean isLoaded() {
        return this.useCache ? this.isCacheLoaded : false;
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023006", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName));
            }
            this.delegate.clear();
            SCOUtils.populateMapDelegateWithStoreData(this.delegate, this.backingStore, this.ownerSM);
            this.isCacheLoaded = true;
        }
    }

    public void flush() {
        if (this.queued && this.queuedOperations != null) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023005", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName));
            }
            Iterator iter = ((AbstractList)this.queuedOperations).iterator();
            while (iter.hasNext()) {
                QueuedOperation op = (QueuedOperation)iter.next();
                op.perform(this.backingStore, this.ownerSM);
            }
            this.queuedOperations.clear();
            this.queuedOperations = null;
        }
    }

    protected void addQueuedOperation(QueuedOperation op) {
        if (this.queuedOperations == null) {
            this.queuedOperations = new ArrayList();
        }
        this.queuedOperations.add(op);
    }

    public void updateEmbeddedKey(Object key, int fieldNumber, Object newValue) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedKey(this.ownerSM, key, fieldNumber, newValue);
        }
    }

    public void updateEmbeddedValue(Object value, int fieldNumber, Object newValue) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedValue(this.ownerSM, value, fieldNumber, newValue);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOwner() {
        return this.owner;
    }

    public synchronized void unsetOwner() {
        if (this.ownerSM != null) {
            this.owner = null;
            this.ownerSM = null;
            this.fieldName = null;
            this.backingStore = null;
        }
    }

    public void makeDirty() {
        if (this.ownerSM != null) {
            this.ownerSM.getObjectManager().getApiAdapter().makeFieldDirty(this.owner, this.fieldName);
        }
    }

    public Object detachCopy(FetchPlanState state) {
        java.util.TreeMap detached = new java.util.TreeMap();
        SCOUtils.detachCopyForMap(this.ownerSM, this.entrySet(), state, detached);
        return detached;
    }

    public void attachCopy(Object value) {
        Map m = (Map)value;
        AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
        boolean keysWithoutIdentity = SCOUtils.mapHasKeysWithoutIdentity(fmd);
        boolean valuesWithoutIdentity = SCOUtils.mapHasValuesWithoutIdentity(fmd);
        java.util.TreeMap attachedKeysValues = new java.util.TreeMap();
        SCOUtils.attachCopyForMap(this.ownerSM, m.entrySet(), attachedKeysValues, keysWithoutIdentity, valuesWithoutIdentity);
        SCOUtils.updateMapWithMapKeysValues(this.ownerSM.getObjectManager().getApiAdapter(), this, attachedKeysValues);
    }

    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.clone();
    }

    public Comparator comparator() {
        return this.delegate.comparator();
    }

    public boolean containsKey(Object key) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsKey(key);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsKey(this.ownerSM, key);
        }
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsValue(value);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsValue(this.ownerSM, value);
        }
        return this.delegate.containsValue(value);
    }

    public java.util.Set entrySet() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerSM, this.fieldName, false, this.backingStore.entrySetStore());
        }
        return this.delegate.entrySet();
    }

    public synchronized boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        return ((Object)this.entrySet()).equals(m.entrySet());
    }

    public Object firstKey() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.firstKey();
        }
        if (!this.useCache) {
            java.util.Set keys = this.keySet();
            Iterator keysIter = keys.iterator();
            return keysIter.next();
        }
        this.loadFromStore();
        return this.delegate.firstKey();
    }

    public Object lastKey() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.lastKey();
        }
        if (!this.useCache) {
            java.util.Set keys = this.keySet();
            Iterator keysIter = keys.iterator();
            Object last = null;
            while (keysIter.hasNext()) {
                last = keysIter.next();
            }
            return last;
        }
        this.loadFromStore();
        return this.delegate.lastKey();
    }

    public SortedMap headMap(Object toKey) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.headMap(toKey);
        }
        if (!this.useCache) {
            throw new NucleusUserException("JPOX doesn't currently support TreeMap.headMap() when not using cached containers");
        }
        this.loadFromStore();
        return this.delegate.headMap(toKey);
    }

    public SortedMap subMap(Object fromKey, Object toKey) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.subMap(fromKey, toKey);
        }
        if (!this.useCache) {
            throw new NucleusUserException("JPOX doesn't currently support TreeMap.subMap() when not using cached container");
        }
        this.loadFromStore();
        return this.delegate.subMap(fromKey, toKey);
    }

    public SortedMap tailMap(Object fromKey) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.headMap(fromKey);
        }
        if (!this.useCache) {
            throw new NucleusUserException("JPOX doesn't currently support TreeMap.tailMap() when not using cached containers");
        }
        this.loadFromStore();
        return this.delegate.headMap(fromKey);
    }

    public Object get(Object key) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.get(this.ownerSM, key);
        }
        return this.delegate.get(key);
    }

    public synchronized int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            int h = 0;
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                h += i.next().hashCode();
            }
            return h;
        }
        return this.delegate.hashCode();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public java.util.Set keySet() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerSM, this.fieldName, false, this.backingStore.keySetStore(this.ownerSM.getObjectManager().getClassLoaderResolver()));
        }
        return this.delegate.keySet();
    }

    public int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.entrySetStore().size(this.ownerSM);
        }
        return this.delegate.size();
    }

    public Collection values() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerSM, this.fieldName, true, this.backingStore.valueSetStore(this.ownerSM.getObjectManager().getClassLoaderResolver()));
        }
        return this.delegate.values();
    }

    public void clear() {
        this.makeDirty();
        if (this.backingStore != null) {
            if (this.queued && !this.ownerSM.getObjectManager().isFlushing()) {
                this.addQueuedOperation(new ClearOperation());
            } else {
                this.backingStore.clear(this.ownerSM);
            }
        }
        this.delegate.clear();
    }

    public Object put(Object key, Object value) {
        if (value == null && !this.allowNulls) {
            throw new NullsNotAllowedException(this.ownerSM, this.fieldName);
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        this.makeDirty();
        Object oldValue = null;
        if (this.backingStore != null) {
            if (this.queued && !this.ownerSM.getObjectManager().isFlushing()) {
                this.addQueuedOperation(new PutOperation(key, value));
            } else {
                oldValue = this.backingStore.put(this.ownerSM, key, value);
            }
        }
        Object delegateOldValue = this.delegate.put(key, value);
        if (this.backingStore == null) {
            oldValue = delegateOldValue;
        } else if (this.queued && !this.ownerSM.getObjectManager().isFlushing()) {
            oldValue = delegateOldValue;
        }
        return oldValue;
    }

    public void putAll(Map m) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            if (this.queued && !this.ownerSM.getObjectManager().isFlushing()) {
                Iterator iter = m.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    this.addQueuedOperation(new PutOperation(entry.getKey(), entry.getValue()));
                }
            } else {
                this.backingStore.putAll(this.ownerSM, m);
            }
        }
        this.delegate.putAll(m);
    }

    public Object remove(Object key) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        Object removed = null;
        Object delegateRemoved = this.delegate.remove(key);
        if (this.backingStore != null) {
            if (this.queued && !this.ownerSM.getObjectManager().isFlushing()) {
                this.addQueuedOperation(new RemoveOperation(key));
                removed = delegateRemoved;
            } else {
                removed = this.backingStore.remove(this.ownerSM, key);
            }
        } else {
            removed = delegateRemoved;
        }
        return removed;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new java.util.TreeMap(this.delegate);
        }
        return new java.util.TreeMap(this.delegate);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

