/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.evaluator.memory;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Stack;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.evaluator.AbstractExpressionEvaluator;
import org.datanucleus.query.evaluator.memory.InvocationEvaluator;
import org.datanucleus.query.evaluator.memory.SetExpression;
import org.datanucleus.query.expression.CreatorExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.util.Imports;
import org.datanucleus.util.Localiser;

public class InMemoryExpressionEvaluator
extends AbstractExpressionEvaluator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = InMemoryExpressionEvaluator.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    Stack stack = new Stack();
    SymbolTable symtbl;
    Imports imports;
    ClassLoaderResolver clr;
    QueryManager queryMgr;
    final String candidateAlias;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public InMemoryExpressionEvaluator(QueryManager queryMgr, SymbolTable symtbl, Imports imports, ClassLoaderResolver clr, String candidateAlias) {
        this.queryMgr = queryMgr;
        this.symtbl = symtbl;
        this.imports = imports;
        this.clr = clr;
        this.candidateAlias = candidateAlias;
    }

    public SymbolTable getSymbolTable() {
        return this.symtbl;
    }

    protected Object processAndExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        this.stack.push(left == Boolean.TRUE && right == Boolean.TRUE ? Boolean.TRUE : Boolean.FALSE);
        return this.stack.peek();
    }

    protected Object processEqExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        Boolean result = this.compareValues(left, right, expr.getOperator()) ? Boolean.TRUE : Boolean.FALSE;
        this.stack.push(result);
        return this.stack.peek();
    }

    protected Object processLikeExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (!(left instanceof String)) {
            throw new NucleusUserException("LIKE expression can only be used on a String expression, but found on " + left.getClass().getName());
        }
        if (right instanceof String) {
            Boolean result = ((String)left).matches((String)right) ? Boolean.TRUE : Boolean.FALSE;
            this.stack.push(result);
            return result;
        }
        throw new NucleusUserException("Dont currently support expression on right of LIKE to be other than String but was " + right.getClass().getName());
    }

    protected Object processNoteqExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        Boolean result = this.compareValues(left, right, expr.getOperator()) ? Boolean.TRUE : Boolean.FALSE;
        this.stack.push(result);
        return this.stack.peek();
    }

    protected Object processOrExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        this.stack.push(left == Boolean.TRUE || right == Boolean.TRUE ? Boolean.TRUE : Boolean.FALSE);
        return this.stack.peek();
    }

    protected Object processGteqExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        Boolean result = this.compareValues(left, right, expr.getOperator()) ? Boolean.TRUE : Boolean.FALSE;
        this.stack.push(result);
        return this.stack.peek();
    }

    protected Object processGtExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        Boolean result = this.compareValues(left, right, expr.getOperator()) ? Boolean.TRUE : Boolean.FALSE;
        this.stack.push(result);
        return this.stack.peek();
    }

    protected Object processIsExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (!(right instanceof Class)) {
            throw new NucleusException("Attempt to invoke instanceof with argument of type " + right.getClass().getName() + " has to be Class");
        }
        try {
            Boolean result = ((Class)right).isAssignableFrom(left.getClass()) ? Boolean.TRUE : Boolean.FALSE;
            this.stack.push(result);
            return result;
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusException("Attempt to invoke instanceof with " + right + " yet class was not found!");
        }
    }

    protected Object processLteqExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        Boolean result = this.compareValues(left, right, expr.getOperator()) ? Boolean.TRUE : Boolean.FALSE;
        this.stack.push(result);
        return this.stack.peek();
    }

    protected Object processLtExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        Boolean result = this.compareValues(left, right, expr.getOperator()) ? Boolean.TRUE : Boolean.FALSE;
        this.stack.push(result);
        return this.stack.peek();
    }

    protected Object processAddExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        BigDecimal value = new BigDecimal(left.toString()).add(new BigDecimal(right.toString()));
        this.stack.push(value);
        return this.stack.peek();
    }

    protected Object processSubExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        BigDecimal value = new BigDecimal(left.toString()).subtract(new BigDecimal(right.toString()));
        this.stack.push(value);
        return this.stack.peek();
    }

    protected Object processDivExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        double firstValue = new BigDecimal(left.toString()).doubleValue();
        double secondValue = new BigDecimal(right.toString()).doubleValue();
        BigDecimal value = new BigDecimal(firstValue / secondValue);
        this.stack.push(value);
        return this.stack.peek();
    }

    protected Object processModExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        BigDecimal firstValue = new BigDecimal(left.toString());
        BigDecimal divisor = new BigDecimal(right.toString());
        BigDecimal value = firstValue.subtract(firstValue.divideToIntegralValue(divisor).multiply(divisor));
        this.stack.push(value);
        return this.stack.peek();
    }

    protected Object processMulExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        BigDecimal value = new BigDecimal(left.toString()).multiply(new BigDecimal(right.toString()));
        this.stack.push(value);
        return this.stack.peek();
    }

    protected Object processNegExpression(Expression expr) {
        Number val = null;
        if (expr.getLeft() instanceof PrimaryExpression) {
            val = (Number)this.getValueForPrimaryExpression((PrimaryExpression)expr.getLeft());
        } else if (expr.getLeft() instanceof ParameterExpression) {
            val = (Number)QueryUtils.getValueForParameterExpression(this.symtbl, (ParameterExpression)expr.getLeft());
        }
        if (val instanceof Integer) {
            this.stack.push(new Integer(-val.intValue()));
            return this.stack.peek();
        }
        if (val instanceof Long) {
            this.stack.push(new Long(-val.longValue()));
            return this.stack.peek();
        }
        if (val instanceof Short) {
            this.stack.push(new Short(-val.shortValue()));
            return this.stack.peek();
        }
        if (val instanceof BigInteger) {
            this.stack.push(new BigInteger("" + -val.longValue()));
            return this.stack.peek();
        }
        if (val instanceof Double) {
            this.stack.push(new Double(-val.doubleValue()));
            return this.stack.peek();
        }
        if (val instanceof Float) {
            this.stack.push(new Float(-val.floatValue()));
            return this.stack.peek();
        }
        if (val instanceof BigDecimal) {
            this.stack.push(new BigDecimal(-val.doubleValue()));
            return this.stack.peek();
        }
        throw new NucleusException("Attempt to negate value of type " + val + " not supported");
    }

    protected Object processComExpression(Expression expr) {
        PrimaryExpression primExpr = (PrimaryExpression)expr.getLeft();
        Object primVal = this.getValueForPrimaryExpression(primExpr);
        int val = -1;
        if (primVal instanceof Number) {
            val = ((Number)primVal).intValue();
        }
        Integer result = new Integer(~val);
        this.stack.push(result);
        return this.stack.peek();
    }

    protected Object processNotExpression(Expression expr) {
        Boolean left = (Boolean)this.stack.pop();
        Boolean result = left != false ? Boolean.FALSE : Boolean.TRUE;
        this.stack.push(result);
        return this.stack.peek();
    }

    protected Object processCreatorExpression(CreatorExpression expr) {
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < expr.getParameters().size(); ++i) {
            params.add(((Expression)expr.getParameters().get(i)).evaluate(this));
        }
        Class cls = this.imports.resolveClassDeclaration(expr.getId(), this.clr, null);
        Object value = QueryUtils.createResultObjectUsingArgumentedConstructor(cls, params.toArray());
        this.stack.push(value);
        return value;
    }

    protected Object processInvokeExpression(InvokeExpression expr) {
        Object result = this.getValueForInvokeExpression(expr);
        this.stack.push(result);
        return result;
    }

    protected Object processLiteral(Literal expr) {
        Object value = expr.getLiteral();
        this.stack.push(value);
        return value;
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        Object value = QueryUtils.getValueForParameterExpression(this.symtbl, expr);
        this.stack.push(value);
        return value;
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        Symbol primSym = this.symtbl.getSymbol(expr.getId());
        if (primSym != null) {
            Object value = primSym.getValue();
            this.stack.push(value);
            return value;
        }
        Object value = this.getValueForPrimaryExpression(expr);
        this.stack.push(value);
        return value;
    }

    public Object getValueForInvokeExpression(InvokeExpression invokeExpr) {
        String method = invokeExpr.getOperation();
        if (invokeExpr.getLeft() == null) {
            if (method.equals("count")) {
                Symbol symbol = this.symtbl.getSymbol("DATANUCLEUS_RESULTS_SET");
                HashSet coll = (HashSet)symbol.getValue();
                SetExpression setexpr = new SetExpression(coll, this.candidateAlias);
                Expression paramExpr = (Expression)invokeExpr.getParameters().get(0);
                if (paramExpr.getOperator() == Expression.OP_DISTINCT) {
                    HashSet processable;
                    coll = processable = new HashSet(coll);
                }
                return setexpr.count(paramExpr, this);
            }
            if (method.equals("sum")) {
                Symbol symbol = this.symtbl.getSymbol("DATANUCLEUS_RESULTS_SET");
                HashSet coll = (HashSet)symbol.getValue();
                SetExpression setexpr = new SetExpression(coll, this.candidateAlias);
                Expression paramExpr = (Expression)invokeExpr.getParameters().get(0);
                if (paramExpr.getOperator() == Expression.OP_DISTINCT) {
                    HashSet processable;
                    coll = processable = new HashSet(coll);
                }
                return setexpr.sum(paramExpr, this, this.symtbl);
            }
            if (method.equals("avg")) {
                Symbol symbol = this.symtbl.getSymbol("DATANUCLEUS_RESULTS_SET");
                HashSet coll = (HashSet)symbol.getValue();
                SetExpression setexpr = new SetExpression(coll, this.candidateAlias);
                Expression paramExpr = (Expression)invokeExpr.getParameters().get(0);
                if (paramExpr.getOperator() == Expression.OP_DISTINCT) {
                    HashSet processable;
                    coll = processable = new HashSet(coll);
                }
                return setexpr.avg(paramExpr, this, this.symtbl);
            }
            if (method.equals("min")) {
                Symbol symbol = this.symtbl.getSymbol("DATANUCLEUS_RESULTS_SET");
                HashSet coll = (HashSet)symbol.getValue();
                SetExpression setexpr = new SetExpression(coll, this.candidateAlias);
                Expression paramExpr = (Expression)invokeExpr.getParameters().get(0);
                if (paramExpr.getOperator() == Expression.OP_DISTINCT) {
                    HashSet processable;
                    coll = processable = new HashSet(coll);
                }
                return setexpr.min(paramExpr, this, this.symtbl);
            }
            if (method.equals("max")) {
                Symbol symbol = this.symtbl.getSymbol("DATANUCLEUS_RESULTS_SET");
                HashSet coll = (HashSet)symbol.getValue();
                SetExpression setexpr = new SetExpression(coll, this.candidateAlias);
                Expression paramExpr = (Expression)invokeExpr.getParameters().get(0);
                if (paramExpr.getOperator() == Expression.OP_DISTINCT) {
                    HashSet processable;
                    coll = processable = new HashSet(coll);
                }
                return setexpr.max(paramExpr, this, this.symtbl);
            }
            InvocationEvaluator methodEval = this.queryMgr.getInMemoryEvaluatorForMethod(null, method);
            if (methodEval != null) {
                return methodEval.evaluate(invokeExpr, null, this);
            }
            throw new NucleusException("Query contains call to static method " + method + " yet no support is available for in-memory evaluation of this");
        }
        if (invokeExpr.getLeft() instanceof PrimaryExpression) {
            Object invokedValue = this.getValueForPrimaryExpression((PrimaryExpression)invokeExpr.getLeft());
            InvocationEvaluator methodEval = this.queryMgr.getInMemoryEvaluatorForMethod(invokedValue.getClass(), method);
            if (methodEval != null) {
                return methodEval.evaluate(invokeExpr, invokedValue, this);
            }
            throw new NucleusException("Query contains call to method " + invokedValue.getClass().getName() + "." + method + " yet no support is available for this");
        }
        if (invokeExpr.getLeft() instanceof InvokeExpression) {
            Object invokedValue = this.getValueForInvokeExpression((InvokeExpression)invokeExpr.getLeft());
            InvocationEvaluator methodEval = this.queryMgr.getInMemoryEvaluatorForMethod(invokedValue.getClass(), method);
            if (methodEval != null) {
                return methodEval.evaluate(invokeExpr, invokedValue, this);
            }
            throw new NucleusException("Query contains call to method " + invokedValue.getClass().getName() + "." + method + " yet no support is available for this");
        }
        throw new NucleusException("No support is available for in-memory evaluation of methods invoked on expressions of type " + invokeExpr.getLeft().getClass().getName());
    }

    public int getIntegerForLiteral(Literal lit) {
        Object val = lit.getLiteral();
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).intValue();
        }
        if (val instanceof BigInteger) {
            return ((BigInteger)val).intValue();
        }
        if (val instanceof Long) {
            return ((Long)val).intValue();
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Short) {
            return ((Short)val).intValue();
        }
        throw new NucleusException("Attempt to convert literal with value " + val + " (" + val.getClass().getName() + ") into an int failed");
    }

    public Object getValueForPrimaryExpression(PrimaryExpression primExpr) {
        Symbol symbol = this.symtbl.getSymbol((String)primExpr.getTuples().get(0));
        if (symbol == null) {
            symbol = this.symtbl.getSymbol(this.candidateAlias);
        }
        Object value = symbol.getValue();
        for (int i = 0; i < primExpr.getTuples().size(); ++i) {
            String fieldName = (String)primExpr.getTuples().get(i);
            if (fieldName.equals(this.candidateAlias)) continue;
            value = this.getFieldValue(value, fieldName);
        }
        return value;
    }

    private boolean compareValues(Object left, Object right, Expression.Operator op) {
        if (left == null || right == null) {
            if (op == Expression.OP_GT) {
                throw new NucleusException("Impossible to evaluate greater_than expression between " + left + " and " + right + " due to presence of null!");
            }
            if (op == Expression.OP_LT) {
                throw new NucleusException("Impossible to evaluate less_than expression between " + left + " and " + right + " due to presence of null!");
            }
            if (op == Expression.OP_GTEQ) {
                if (left == right) {
                    return true;
                }
                throw new NucleusException("Impossible to evaluate greater_equals expression between " + left + " and " + right + " due to presence of null!");
            }
            if (op == Expression.OP_LTEQ) {
                if (left == right) {
                    return true;
                }
                throw new NucleusException("Impossible to evaluate less_equals expression between " + left + " and " + right + " due to presence of null!");
            }
            if (op == Expression.OP_EQ) {
                return left == right;
            }
            if (op == Expression.OP_NOTEQ) {
                return left != right;
            }
        } else if (left instanceof Float || left instanceof Double || left instanceof BigDecimal || right instanceof Float || right instanceof Double || right instanceof BigDecimal) {
            Double leftVal = null;
            Double rightVal = null;
            if (left instanceof BigDecimal) {
                leftVal = new Double(((BigDecimal)left).doubleValue());
            } else if (left instanceof Double) {
                leftVal = (Double)left;
            } else if (left instanceof Float) {
                leftVal = new Double(((Float)left).doubleValue());
            } else if (left instanceof BigInteger) {
                leftVal = new Double(((BigInteger)left).doubleValue());
            } else if (left instanceof Long) {
                leftVal = new Double(((Long)left).doubleValue());
            } else if (left instanceof Integer) {
                leftVal = new Double(((Integer)left).doubleValue());
            } else if (left instanceof Short) {
                leftVal = new Double(((Short)left).doubleValue());
            }
            if (right instanceof BigDecimal) {
                rightVal = new Double(((BigDecimal)right).doubleValue());
            } else if (right instanceof Double) {
                rightVal = (Double)right;
            } else if (right instanceof Float) {
                rightVal = new Double(((Float)right).doubleValue());
            } else if (right instanceof BigInteger) {
                rightVal = new Double(((BigInteger)right).doubleValue());
            } else if (right instanceof Long) {
                rightVal = new Double(((Long)right).doubleValue());
            } else if (right instanceof Integer) {
                rightVal = new Double(((Integer)right).doubleValue());
            } else if (right instanceof Short) {
                rightVal = new Double(((Short)right).doubleValue());
            }
            if (leftVal == null || rightVal == null) {
                throw new NucleusException("Attempt to evaluate relational expression between\"" + left + "\" (type=" + left.getClass().getName() + ") and" + "\"" + right + "\" (type=" + right.getClass().getName() + ") not possible due to types");
            }
            int comparison = leftVal.compareTo(rightVal);
            if (op == Expression.OP_GT) {
                return comparison > 0;
            }
            if (op == Expression.OP_LT) {
                return comparison < 0;
            }
            if (op == Expression.OP_GTEQ) {
                return comparison >= 0;
            }
            if (op == Expression.OP_LTEQ) {
                return comparison <= 0;
            }
            if (op == Expression.OP_EQ) {
                return comparison == 0;
            }
            if (op == Expression.OP_NOTEQ) {
                return comparison != 0;
            }
        } else if (left instanceof Short || left instanceof Integer || left instanceof Long || left instanceof BigInteger || right instanceof Short || right instanceof Integer || right instanceof Long || right instanceof BigInteger) {
            long leftVal = Long.MAX_VALUE;
            long rightVal = Long.MAX_VALUE;
            if (left instanceof BigInteger) {
                leftVal = ((BigInteger)left).longValue();
            } else if (left instanceof Long) {
                leftVal = (Long)left;
            } else if (left instanceof Integer) {
                leftVal = ((Integer)left).longValue();
            } else if (left instanceof Short) {
                leftVal = ((Short)left).longValue();
            } else if (left instanceof BigDecimal) {
                leftVal = ((BigDecimal)left).longValue();
            } else if (left instanceof Double) {
                leftVal = ((Double)left).longValue();
            } else if (left instanceof Float) {
                leftVal = ((Float)left).longValue();
            }
            if (right instanceof BigInteger) {
                rightVal = ((BigInteger)right).longValue();
            } else if (right instanceof Long) {
                rightVal = (Long)right;
            } else if (right instanceof Integer) {
                rightVal = ((Integer)right).longValue();
            } else if (right instanceof Short) {
                rightVal = ((Short)right).longValue();
            } else if (right instanceof BigDecimal) {
                rightVal = ((BigDecimal)right).longValue();
            } else if (right instanceof Double) {
                rightVal = ((Double)right).longValue();
            } else if (right instanceof Float) {
                rightVal = ((Float)right).longValue();
            }
            if (leftVal == Long.MAX_VALUE || rightVal == Long.MAX_VALUE) {
                throw new NucleusException("Attempt to evaluate relational expression between\"" + left + "\" (type=" + left.getClass().getName() + ") and" + "\"" + right + "\" (type=" + right.getClass().getName() + ") not possible due to types");
            }
            if (op == Expression.OP_GT) {
                return leftVal > rightVal;
            }
            if (op == Expression.OP_LT) {
                return leftVal < rightVal;
            }
            if (op == Expression.OP_GTEQ) {
                return leftVal >= rightVal;
            }
            if (op == Expression.OP_LTEQ) {
                return leftVal <= rightVal;
            }
            if (op == Expression.OP_EQ) {
                return leftVal == rightVal;
            }
            if (op == Expression.OP_NOTEQ) {
                return leftVal != rightVal;
            }
        } else {
            if (op == Expression.OP_EQ) {
                if (left == null) {
                    return right == null;
                }
                return left.equals(right);
            }
            if (op == Expression.OP_NOTEQ) {
                if (left == null) {
                    return right != null;
                }
                return !left.equals(right);
            }
            throw new NucleusException("Attempt to evaluate relational expression between\"" + left + "\" (type=" + left.getClass().getName() + ") and" + "\"" + right + "\" (type=" + right.getClass().getName() + ") not possible due to types");
        }
        throw new NucleusException("Attempt to evaluate relational expression between " + left + " and " + right + " with operation = " + op + " impossible to perform");
    }

    private Field getDeclaredFieldPrivileged(final Class clazz, final String fieldName) {
        if (clazz == null || fieldName == null) {
            return null;
        }
        return (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class seekingClass = clazz;
                do {
                    try {
                        return seekingClass.getDeclaredField(fieldName);
                    }
                    catch (SecurityException ex) {
                        throw new NucleusException("CannotGetDeclaredField", ex).setFatal();
                    }
                    catch (NoSuchFieldException ex) {
                    }
                    catch (LinkageError ex) {
                        throw new NucleusException("ClassLoadingError", ex).setFatal();
                    }
                } while ((seekingClass = seekingClass.getSuperclass()) != null);
                return null;
            }
        });
    }

    private Object getFieldValue(Object object, String fieldName) {
        Object fieldValue;
        if (object == null) {
            return null;
        }
        final Field field = this.getDeclaredFieldPrivileged(object.getClass(), fieldName);
        if (field == null) {
            throw new NucleusUserException("Cannot access field: " + fieldName + " in type " + object.getClass());
        }
        try {
            if (!field.isAccessible()) {
                try {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            ((AccessibleObject)field).setAccessible(true);
                            return null;
                        }
                    });
                }
                catch (SecurityException ex) {
                    throw new NucleusException("Cannot access field: " + fieldName, ex).setFatal();
                }
            }
            fieldValue = field.get(object);
        }
        catch (IllegalArgumentException e2) {
            throw new NucleusUserException("Cannot access field: " + fieldName, e2);
        }
        catch (IllegalAccessException e2) {
            throw new NucleusUserException("Cannot access field: " + fieldName, e2);
        }
        return fieldValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

