/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.store.query.QueryInvalidParametersException;
import org.datanucleus.util.Localiser;

public class QueryCompilation {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = QueryCompilation.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    protected Class candidateClass;
    protected String candidateAlias = "this";
    protected SymbolTable symtbl;
    protected Expression[] exprResult;
    protected Expression[] exprFrom;
    protected Expression exprFilter = null;
    protected Expression[] exprGrouping;
    protected Expression exprHaving;
    protected Expression[] exprOrdering;
    protected Map subqueryCompilations = null;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public QueryCompilation(Class candidateCls, String candidateAlias, SymbolTable symtbl, Expression[] results, Expression[] froms, Expression filter, Expression[] groupings, Expression having, Expression[] orderings) {
        this.candidateClass = candidateCls;
        this.candidateAlias = candidateAlias;
        this.symtbl = symtbl;
        this.exprResult = results;
        this.exprFrom = froms;
        this.exprFilter = filter;
        this.exprGrouping = groupings;
        this.exprHaving = having;
        this.exprOrdering = orderings;
    }

    public void addSubqueryCompilation(String alias, QueryCompilation compilation) {
        if (this.subqueryCompilations == null) {
            this.subqueryCompilations = new HashMap();
        }
        this.subqueryCompilations.put(alias, compilation);
    }

    public QueryCompilation getCompilationForSubquery(String alias) {
        return this.subqueryCompilations != null ? (QueryCompilation)this.subqueryCompilations.get(alias) : null;
    }

    public Class getCandidateClass() {
        return this.candidateClass;
    }

    public String getCandidateAlias() {
        return this.candidateAlias;
    }

    public SymbolTable getSymbolTable() {
        return this.symtbl;
    }

    public Expression[] getExprResult() {
        return this.exprResult;
    }

    public Expression[] getExprFrom() {
        return this.exprFrom;
    }

    public Expression getExprFilter() {
        return this.exprFilter;
    }

    public Expression[] getExprGrouping() {
        return this.exprGrouping;
    }

    public Expression getExprHaving() {
        return this.exprHaving;
    }

    public Expression[] getExprOrdering() {
        return this.exprOrdering;
    }

    public void bindParameterValuesToNames(Map parameters) {
        if (parameters != null) {
            Iterator it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String paramName = (String)entry.getKey();
                Symbol symbol = this.symtbl.getSymbol(paramName);
                if (symbol != null) {
                    symbol.setValue(entry.getValue());
                    continue;
                }
                throw new QueryInvalidParametersException(LOCALISER.msg("021116", (Object)paramName));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

