/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.util.Localiser;

public class MetaData
implements Serializable {
    protected static Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = MetaData.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    public static final int METADATA_CREATED_STATE = 0;
    public static final int METADATA_POPULATED_STATE = 1;
    public static final int METADATA_INITIALISED_STATE = 2;
    public static final int METADATA_USED_STATE = 3;
    protected int metaDataState = 0;
    protected MetaData parent;
    public static final String VENDOR_NAME = "datanucleus";
    public static final String VENDOR_NAME_OLD = "jpox";
    protected Collection extensions = null;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public MetaData(MetaData parent) {
        this.parent = parent;
    }

    public void initialise() {
        this.setInitialised();
    }

    public void setInitialised() {
        this.metaDataState = 2;
    }

    public void setPopulated() {
        this.metaDataState = 1;
    }

    public void setUsed() {
        this.metaDataState = 3;
    }

    public void setParent(MetaData md) {
        if (this.isPopulated() || this.isInitialised()) {
            throw new NucleusException("Cannot set parent of " + this + " since it is already populated/initialised");
        }
        this.parent = md;
    }

    public void addExtension(String vendor, String key, String value) {
        if (vendor == null || this.isSupportedVendor(vendor) && (key == null || value == null)) {
            throw new InvalidMetaDataException(LOCALISER, "044160", (Object)vendor, (Object)key, value);
        }
        if (this.isSupportedVendor(vendor) && this.hasExtension(key)) {
            this.removeExtension(key);
        }
        if (this.extensions == null) {
            this.extensions = new HashSet(2);
        }
        this.extensions.add(new ExtensionMetaData(vendor, key, value));
    }

    public void addExtension(String key, String value) {
        this.addExtension(VENDOR_NAME, key, value);
    }

    public void removeExtension(String key) {
        if (this.extensions == null) {
            return;
        }
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = (ExtensionMetaData)iter.next();
            if (!ex.getKey().equals(key) || !this.isSupportedVendor(ex.getVendorName())) continue;
            iter.remove();
            break;
        }
    }

    public MetaData getParent() {
        return this.parent;
    }

    public boolean isPopulated() {
        return this.metaDataState >= 1;
    }

    public boolean isInitialised() {
        return this.metaDataState >= 2;
    }

    public boolean isUsed() {
        return this.metaDataState == 3;
    }

    public int getNoOfExtensions() {
        if (this.extensions == null) {
            return 0;
        }
        return this.extensions.size();
    }

    public ExtensionMetaData[] getExtensions() {
        if (this.extensions == null || this.extensions.size() == 0) {
            return null;
        }
        return this.extensions.toArray(new ExtensionMetaData[this.extensions.size()]);
    }

    public boolean hasExtension(String key) {
        if (this.extensions == null || key == null) {
            return false;
        }
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = (ExtensionMetaData)iter.next();
            if (!ex.getKey().equals(key) || !this.isSupportedVendor(ex.getVendorName())) continue;
            return true;
        }
        return false;
    }

    public String getValueForExtension(String key) {
        if (this.extensions == null || key == null) {
            return null;
        }
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = (ExtensionMetaData)iter.next();
            if (!ex.getKey().equals(key) || !this.isSupportedVendor(ex.getVendorName())) continue;
            return ex.getValue();
        }
        return null;
    }

    public String[] getValuesForExtension(String key) {
        if (this.extensions == null || key == null) {
            return null;
        }
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = (ExtensionMetaData)iter.next();
            if (!ex.getKey().equals(key) || !this.isSupportedVendor(ex.getVendorName())) continue;
            return MetaDataUtils.getInstance().getValuesForCommaSeparatedAttribute(ex.getValue());
        }
        return null;
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        if (this.extensions == null || this.extensions.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = (ExtensionMetaData)iter.next();
            sb.append(prefix).append(ex.toString()).append("\n");
        }
        return sb.toString();
    }

    private boolean isSupportedVendor(String vendorName) {
        return vendorName.equalsIgnoreCase(VENDOR_NAME) || vendorName.equalsIgnoreCase(VENDOR_NAME_OLD);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

