/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.IndexedValue;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.util.StringUtils;

public class JoinMetaData
extends MetaData
implements ColumnMetaDataContainer {
    ForeignKeyMetaData foreignKeyMetaData;
    IndexMetaData indexMetaData;
    UniqueMetaData uniqueMetaData;
    protected PrimaryKeyMetaData primaryKeyMetaData;
    final List columns = new ArrayList();
    Boolean outer;
    String table;
    String catalog;
    String schema;
    String columnName;
    String foreignKey;
    protected IndexedValue indexed = null;
    protected final boolean uniqueConstraint;
    protected ColumnMetaData[] columnMetaData;

    public JoinMetaData(MetaData parent, JoinMetaData joinmd) {
        super(parent);
        this.table = joinmd.table;
        this.catalog = joinmd.catalog;
        this.schema = joinmd.schema;
        this.columnName = joinmd.columnName;
        this.outer = joinmd.outer;
        this.indexed = joinmd.indexed;
        this.uniqueConstraint = joinmd.uniqueConstraint;
        for (int i = 0; i < joinmd.columns.size(); ++i) {
            this.addColumn(new ColumnMetaData((MetaData)this, (ColumnMetaData)joinmd.columns.get(i)));
        }
    }

    public JoinMetaData(MetaData parent, String table, String catalog, String schema, String columnName, String outer, String fkDeleteAction, String indexed, String unique) {
        super(parent);
        if (table != null && parent instanceof AbstractMemberMetaData) {
            throw new InvalidMetaDataException(MetaData.LOCALISER, "044130", (Object)((AbstractMemberMetaData)parent).getFullFieldName());
        }
        this.table = StringUtils.isWhitespace(table) ? null : table;
        this.catalog = StringUtils.isWhitespace(catalog) ? null : catalog;
        this.schema = StringUtils.isWhitespace(schema) ? null : schema;
        String string = this.columnName = StringUtils.isWhitespace(columnName) ? null : columnName;
        if (outer != null) {
            if (outer.equalsIgnoreCase("true")) {
                this.outer = Boolean.TRUE;
            } else if (outer.equalsIgnoreCase("false")) {
                this.outer = Boolean.FALSE;
            }
        }
        if (!StringUtils.isWhitespace(fkDeleteAction)) {
            this.foreignKeyMetaData = new ForeignKeyMetaData(null, null, null, null, fkDeleteAction, null);
        }
        this.indexed = IndexedValue.getIndexedValue(indexed);
        this.uniqueConstraint = unique != null && unique.equalsIgnoreCase("true");
    }

    public void initialise() {
        int i;
        if (this.columns.size() == 0 && this.columnName != null) {
            this.columnMetaData = new ColumnMetaData[1];
            this.columnMetaData[0] = new ColumnMetaData((MetaData)this, this.columnName);
            this.columnMetaData[0].initialise();
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = (ColumnMetaData)this.columns.get(i);
                this.columnMetaData[i].initialise();
            }
        }
        if (this.foreignKeyMetaData != null) {
            this.foreignKeyMetaData.initialise();
        }
        if (this.indexMetaData == null && this.columnMetaData != null && this.indexed != null && this.indexed != IndexedValue.FALSE) {
            this.indexMetaData = new IndexMetaData(null, null, this.indexed == IndexedValue.UNIQUE ? "true" : "false");
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.indexMetaData.addColumn(this.columnMetaData[i]);
            }
        }
        if (this.indexMetaData != null) {
            this.indexMetaData.initialise();
        }
        if (this.uniqueMetaData == null && this.uniqueConstraint) {
            this.uniqueMetaData = new UniqueMetaData(null, this.columnName, null);
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.uniqueMetaData.addColumn(this.columnMetaData[i]);
            }
        }
        if (this.uniqueMetaData != null) {
            this.uniqueMetaData.initialise();
        }
        if (this.primaryKeyMetaData != null) {
            this.primaryKeyMetaData.initialise();
        }
        this.setInitialised();
    }

    public void addColumn(ColumnMetaData colmd) {
        this.columns.add(colmd);
        colmd.parent = this;
    }

    public final String getTable() {
        return this.table;
    }

    public final String getCatalog() {
        return this.catalog;
    }

    public final String getSchema() {
        return this.schema;
    }

    public final String getColumnName() {
        return this.columnName;
    }

    public final ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public final boolean isOuter() {
        if (this.outer == null) {
            return false;
        }
        return this.outer;
    }

    public final IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public final UniqueMetaData getUniqueMetaData() {
        return this.uniqueMetaData;
    }

    public final ForeignKeyMetaData getForeignKeyMetaData() {
        return this.foreignKeyMetaData;
    }

    public final PrimaryKeyMetaData getPrimaryKeyMetaData() {
        return this.primaryKeyMetaData;
    }

    public final void setForeignKeyMetaData(ForeignKeyMetaData foreignKeyMetaData) {
        this.foreignKeyMetaData = foreignKeyMetaData;
    }

    public final void setIndexMetaData(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
    }

    public final void setUniqueMetaData(UniqueMetaData uniqueMetaData) {
        this.uniqueMetaData = uniqueMetaData;
    }

    public final void setPrimaryKeyMetaData(PrimaryKeyMetaData primaryKeyMetaData) {
        this.primaryKeyMetaData = primaryKeyMetaData;
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<join");
        if (this.table != null) {
            sb.append(" table=\"" + this.table + "\"");
        }
        if (this.columnName != null) {
            sb.append(" column=\"" + this.columnName + "\"");
        }
        if (this.outer != null) {
            sb.append(" outer=\"" + this.outer + "\"");
        }
        sb.append(">\n");
        if (this.primaryKeyMetaData != null) {
            sb.append(this.primaryKeyMetaData.toString(prefix + indent, indent));
        }
        if (this.columnMetaData != null) {
            for (int i = 0; i < this.columnMetaData.length; ++i) {
                sb.append(this.columnMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.foreignKeyMetaData != null) {
            sb.append(this.foreignKeyMetaData.toString(prefix + indent, indent));
        }
        if (this.indexMetaData != null) {
            sb.append(this.indexMetaData.toString(prefix + indent, indent));
        }
        if (this.uniqueMetaData != null) {
            sb.append(this.uniqueMetaData.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</join>\n");
        return sb.toString();
    }
}

