/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jdo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.spi.JDOImplHelper;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ConnectionManagerImpl;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.jdo.AbstractPersistenceManagerFactory;
import org.datanucleus.jdo.JDOClassNameConstants;
import org.datanucleus.jdo.JDOPersistenceManager;
import org.datanucleus.jdo.LifecycleListenerForClass;
import org.datanucleus.jdo.NucleusJDOHelper;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class JDOPersistenceManagerFactory
extends AbstractPersistenceManagerFactory
implements PersistenceManagerFactory,
ObjectFactory,
Referenceable {
    static /* synthetic */ Class class$org$datanucleus$state$JDOStateManagerImpl;

    public static synchronized PersistenceManagerFactory getPersistenceManagerFactory(Properties overridingProps) {
        HashMap<String, String> overridingMap = new HashMap<String, String>();
        Enumeration<?> e = overridingProps.propertyNames();
        while (e.hasMoreElements()) {
            String param = (String)e.nextElement();
            overridingMap.put(param, overridingProps.getProperty(param));
        }
        JDOPersistenceManagerFactory pmf = JDOPersistenceManagerFactory.createInstance(overridingMap);
        pmf.freezeConfiguration();
        return pmf;
    }

    public static synchronized PersistenceManagerFactory getPersistenceManagerFactory(Map overridingProps) {
        HashMap<String, String> overridingMap = null;
        if (overridingProps instanceof Properties) {
            overridingMap = new HashMap<String, String>();
            Enumeration<?> e = ((Properties)((Object)overridingProps)).propertyNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                overridingMap.put(param, ((Properties)((Object)overridingProps)).getProperty(param));
            }
        } else {
            overridingMap = overridingProps;
        }
        JDOPersistenceManagerFactory pmf = JDOPersistenceManagerFactory.createInstance(overridingMap);
        pmf.freezeConfiguration();
        return pmf;
    }

    public static synchronized PersistenceManagerFactory getPersistenceManagerFactory(Map overrides, Map props) {
        HashMap<String, String> propsMap = null;
        if (props instanceof Properties) {
            propsMap = new HashMap<String, String>();
            Enumeration<?> e = ((Properties)((Object)props)).propertyNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                propsMap.put(param, ((Properties)((Object)props)).getProperty(param));
            }
        } else {
            propsMap = props;
        }
        HashMap<String, String> overridesMap = null;
        if (overrides instanceof Properties) {
            overridesMap = new HashMap<String, String>();
            Enumeration<?> e = ((Properties)((Object)overrides)).propertyNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                overridesMap.put(param, ((Properties)((Object)overrides)).getProperty(param));
            }
        } else {
            overridesMap = overrides;
        }
        HashMap<String, String> overallMap = null;
        overallMap = propsMap != null ? new HashMap(propsMap) : new HashMap<String, String>();
        if (overridesMap != null) {
            overallMap.putAll(overridesMap);
        }
        JDOPersistenceManagerFactory pmf = JDOPersistenceManagerFactory.createInstance(overallMap);
        pmf.freezeConfiguration();
        return pmf;
    }

    public JDOPersistenceManagerFactory() {
        this.initialiseProperties(null);
    }

    public JDOPersistenceManagerFactory(Map props) {
        this.initialiseProperties(props);
    }

    public static JDOPersistenceManagerFactory createInstance(Map props) {
        return new JDOPersistenceManagerFactory(props);
    }

    protected void initialiseProperties(Map props) {
        if (props != null) {
            HashMap startupProps = null;
            if (props.containsKey("datanucleus.plugin.pluginRegistryClassName")) {
                if (startupProps == null) {
                    startupProps = new HashMap();
                }
                startupProps.put("datanucleus.plugin.pluginRegistryClassName", props.get("datanucleus.plugin.pluginRegistryClassName"));
            }
            if (props.containsKey("datanucleus.plugin.pluginRegistryBundleCheck")) {
                if (startupProps == null) {
                    startupProps = new HashMap();
                }
                startupProps.put("datanucleus.plugin.pluginRegistryBundleCheck", props.get("datanucleus.plugin.pluginRegistryBundleCheck"));
            }
            if (props.containsKey("datanucleus.classLoaderResolverName")) {
                if (startupProps == null) {
                    startupProps = new HashMap();
                }
                startupProps.put("datanucleus.classLoaderResolverName", props.get("datanucleus.classLoaderResolverName"));
            }
            if (props.containsKey("datanucleus.persistenceXmlFilename")) {
                if (startupProps == null) {
                    startupProps = new HashMap();
                }
                startupProps.put("datanucleus.persistenceXmlFilename", props.get("datanucleus.persistenceXmlFilename"));
            }
            if (startupProps != null) {
                try {
                    this.setOptions(startupProps);
                }
                catch (NucleusException jpe) {
                    throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
                }
            }
        }
        this.initialiseOMFContext();
        this.omfContext.setConnectionManager(new ConnectionManagerImpl(this.omfContext));
        String api = "JDO";
        if (props != null && props.get("datanucleus.persistenceApiName") != null) {
            api = (String)props.get("datanucleus.persistenceApiName");
        }
        this.omfContext.setApi(api);
        this.setOptions(this.omfContext.getApiAdapter().getDefaultFactoryProperties());
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                JDOImplHelper.registerAuthorizedStateManagerClass((Class)(class$org$datanucleus$state$JDOStateManagerImpl == null ? (class$org$datanucleus$state$JDOStateManagerImpl = JDOPersistenceManagerFactory.class$("org.datanucleus.state.JDOStateManagerImpl")) : class$org$datanucleus$state$JDOStateManagerImpl));
                return null;
            }
        });
        HashMap<Object, Object> pmfProps = new HashMap<Object, Object>();
        PersistenceUnitMetaData pumd = null;
        if (props != null) {
            String persistenceUnitName = (String)props.get("datanucleus.PersistenceUnitName");
            if (persistenceUnitName == null) {
                persistenceUnitName = (String)props.get("javax.jdo.option.PersistenceUnitName");
            }
            if (persistenceUnitName != null) {
                this.setProperty("datanucleus.PersistenceUnitName", persistenceUnitName);
                try {
                    pumd = this.omfContext.getMetaDataManager().getMetaDataForPersistenceUnit(persistenceUnitName);
                    if (pumd != null) {
                        if (pumd.getProperties() != null) {
                            pmfProps.putAll(pumd.getProperties());
                        }
                    } else {
                        throw new JDOUserException(AbstractPersistenceManagerFactory.LOCALISER_JDO.msg("012004", (Object)persistenceUnitName));
                    }
                    if (this.omfContext.getApi().equalsIgnoreCase("JPA")) {
                        pumd.clearJarFiles();
                    }
                }
                catch (NucleusException jpe) {
                    throw new JDOUserException(AbstractPersistenceManagerFactory.LOCALISER_JDO.msg("012005", (Object)persistenceUnitName));
                }
            }
        }
        if (props != null) {
            pmfProps.putAll(props);
            if (!pmfProps.containsKey("datanucleus.TransactionType") && !pmfProps.containsKey("javax.jdo.option.TransactionType")) {
                pmfProps.put("datanucleus.TransactionType", TransactionType.RESOURCE_LOCAL.toString());
            }
        } else {
            pmfProps.put("datanucleus.TransactionType", TransactionType.RESOURCE_LOCAL.toString());
        }
        try {
            this.setOptions(pmfProps);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
        if (pumd != null) {
            try {
                this.omfContext.getMetaDataManager().initialise(pumd, this.omfContext.getClassLoaderResolver(null));
            }
            catch (NucleusException jpe) {
                throw new JDOException(jpe.getMessage(), (Throwable)jpe);
            }
        }
        if (props != null) {
            Iterator propsIter = props.keySet().iterator();
            while (propsIter.hasNext()) {
                String key = (String)propsIter.next();
                if (!key.startsWith("javax.jdo.listener.InstanceLifecycleListener")) continue;
                String listenerClsName = key.substring(45);
                String listenerClasses = (String)props.get(key);
                ClassLoaderResolver clr = this.omfContext.getClassLoaderResolver(null);
                Class listenerCls = null;
                try {
                    listenerCls = clr.classForName(listenerClsName);
                }
                catch (ClassNotResolvedException cnre) {
                    throw new JDOUserException(AbstractPersistenceManagerFactory.LOCALISER_JDO.msg("012022", (Object)listenerClsName));
                }
                InstanceLifecycleListener listener = null;
                Method method = ClassUtils.getMethodForClass(listenerCls, "getInstance", null);
                if (method != null) {
                    try {
                        listener = (InstanceLifecycleListener)method.invoke(null, null);
                    }
                    catch (Exception e) {
                        throw new JDOUserException(AbstractPersistenceManagerFactory.LOCALISER_JDO.msg("012021", (Object)listenerClsName), (Throwable)e);
                    }
                }
                try {
                    listener = (InstanceLifecycleListener)listenerCls.newInstance();
                }
                catch (Exception e) {
                    throw new JDOUserException(AbstractPersistenceManagerFactory.LOCALISER_JDO.msg("012020", (Object)listenerClsName), (Throwable)e);
                }
                Class[] classes = null;
                if (!StringUtils.isWhitespace(listenerClasses)) {
                    String[] classNames = StringUtils.split(listenerClasses, ",");
                    classes = new Class[classNames.length];
                    for (int i = 0; i < classNames.length; ++i) {
                        classes[i] = clr.classForName(classNames[i]);
                    }
                }
                this.addInstanceLifecycleListener(listener, classes);
            }
        }
    }

    protected void freezeConfiguration() {
        if (this.configurable) {
            if (this.omfContext == null) {
                this.initialiseOMFContext();
                this.omfContext.setConnectionManager(new ConnectionManagerImpl(this.omfContext));
            }
            super.freezeConfiguration();
        }
    }

    public synchronized PersistenceManager getPersistenceManager() {
        return this.getPersistenceManager(this.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionUserName"), this.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionPassword"));
    }

    public synchronized PersistenceManager getPersistenceManager(String userName, String password) {
        this.assertIsOpen();
        this.freezeConfiguration();
        JDOPersistenceManager pm = new JDOPersistenceManager(this, userName, password);
        if (this.lifecycleListeners != null) {
            Iterator listenerIter = this.lifecycleListeners.iterator();
            while (listenerIter.hasNext()) {
                LifecycleListenerForClass listener = (LifecycleListenerForClass)listenerIter.next();
                pm.addInstanceLifecycleListener(listener.getListener(), listener.getClasses());
            }
        }
        this.getPmCache().add(pm);
        return pm;
    }

    public synchronized boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JDOPersistenceManagerFactory)) {
            return false;
        }
        return super.equals(obj);
    }

    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        JDOPersistenceManagerFactory pmf = null;
        if (NucleusLogger.NAMING.isDebugEnabled()) {
            NucleusLogger.NAMING.debug("Creating PersistenceManagerFactory instance via JNDI with values [object] " + (obj == null ? "" : obj.toString()) + " " + "[name] " + (name == null ? "" : name.toString()) + " " + "[context] " + (ctx == null ? "" : ctx.toString()) + " " + "[env] " + (env == null ? "" : env.toString()) + " ");
        }
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            if (ref.getClassName().equals(JDOClassNameConstants.JDOPersistenceManagerFactory) || ref.getClassName().equals(JDOClassNameConstants.JAVAX_JDO_PersistenceManagerFactory)) {
                Properties p = new Properties();
                Enumeration<RefAddr> e = ref.getAll();
                while (e.hasMoreElements()) {
                    StringRefAddr sra = (StringRefAddr)e.nextElement();
                    p.setProperty(sra.getType(), (String)sra.getContent());
                }
                pmf = JDOPersistenceManagerFactory.createInstance(p);
                pmf.freezeConfiguration();
                if (NucleusLogger.NAMING.isDebugEnabled()) {
                    NucleusLogger.NAMING.debug(AbstractPersistenceManagerFactory.LOCALISER_JDO.msg("012006", (Object)name.toString()));
                }
            } else {
                NucleusLogger.NAMING.warn(AbstractPersistenceManagerFactory.LOCALISER_JDO.msg("012007", (Object)ref.getClassName(), (Object)JDOClassNameConstants.JDOPersistenceManagerFactory));
            }
        } else {
            NucleusLogger.NAMING.warn(AbstractPersistenceManagerFactory.LOCALISER_JDO.msg("012008", (Object)obj.getClass().getName()));
        }
        return pmf;
    }

    public Reference getReference() {
        Reference rc = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            rc = new Reference(JDOClassNameConstants.JAVAX_JDO_PersistenceManagerFactory, JDOClassNameConstants.JDOPersistenceManagerFactory, null);
            Map p = this.getOptions();
            Iterator i = p.keySet().iterator();
            while (i.hasNext()) {
                String value;
                String key = (String)i.next();
                if (p.get(key) instanceof String) {
                    value = (String)p.get(key);
                    rc.add(new StringRefAddr(key, value));
                    if (!NucleusLogger.NAMING.isDebugEnabled()) continue;
                    NucleusLogger.NAMING.debug(AbstractPersistenceManagerFactory.LOCALISER_JDO.msg("012009", (Object)key, (Object)value));
                    continue;
                }
                if (p.get(key) instanceof Long) {
                    value = "" + p.get(key);
                    rc.add(new StringRefAddr(key, value));
                    if (!NucleusLogger.NAMING.isDebugEnabled()) continue;
                    NucleusLogger.NAMING.debug(AbstractPersistenceManagerFactory.LOCALISER_JDO.msg("012009", (Object)key, (Object)value));
                    continue;
                }
                if (p.get(key) instanceof Integer) {
                    value = "" + p.get(key);
                    rc.add(new StringRefAddr(key, value));
                    if (!NucleusLogger.NAMING.isDebugEnabled()) continue;
                    NucleusLogger.NAMING.debug(AbstractPersistenceManagerFactory.LOCALISER_JDO.msg("012009", (Object)key, (Object)value));
                    continue;
                }
                if (p.get(key) instanceof Boolean) {
                    value = (Boolean)p.get(key) != false ? "true" : "false";
                    rc.add(new StringRefAddr(key, value));
                    if (!NucleusLogger.NAMING.isDebugEnabled()) continue;
                    NucleusLogger.NAMING.debug(AbstractPersistenceManagerFactory.LOCALISER_JDO.msg("012009", (Object)key, (Object)value));
                    continue;
                }
                NucleusLogger.NAMING.warn(AbstractPersistenceManagerFactory.LOCALISER_JDO.msg("012010", (Object)key));
            }
            if (NucleusLogger.NAMING.isDebugEnabled() && p.isEmpty()) {
                NucleusLogger.NAMING.debug(AbstractPersistenceManagerFactory.LOCALISER_JDO.msg("012011"));
            }
        }
        catch (IOException ex) {
            NucleusLogger.NAMING.error(ex.getMessage());
            throw new NucleusException(ex.getMessage(), ex);
        }
        return rc;
    }

    public PersistenceManager getPersistenceManagerProxy() {
        throw new UnsupportedOperationException("PMF.getPersistenceManagerProxy() not yet implemented");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

