/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jdo;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import javax.jdo.datastore.DataStoreCache;
import javax.jdo.datastore.Sequence;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.spi.JDOPermission;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchGroup;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.TransactionIsolationNotSupportedException;
import org.datanucleus.jdo.JDODataStoreCache;
import org.datanucleus.jdo.JDOFetchGroup;
import org.datanucleus.jdo.JDOPersistenceManager;
import org.datanucleus.jdo.LifecycleListenerForClass;
import org.datanucleus.jdo.NucleusJDOHelper;
import org.datanucleus.properties.CorePropertyValidator;
import org.datanucleus.store.StoreManager;
import org.datanucleus.util.Localiser;

public abstract class AbstractPersistenceManagerFactory
extends ObjectManagerFactoryImpl {
    protected static final Localiser LOCALISER_JDO = Localiser.getInstance("org.datanucleus.jdo.Localisation", (class$org$datanucleus$jdo$AbstractPersistenceManagerFactory == null ? (class$org$datanucleus$jdo$AbstractPersistenceManagerFactory = AbstractPersistenceManagerFactory.class$("org.datanucleus.jdo.AbstractPersistenceManagerFactory")) : class$org$datanucleus$jdo$AbstractPersistenceManagerFactory).getClassLoader());
    private static final String VERSION_NUMBER_PROPERTY = "VersionNumber";
    private static final String VENDOR_NAME_PROPERTY = "VendorName";
    private Set pmCache = new HashSet();
    protected List lifecycleListeners;
    private Map sequenceByFactoryClass;
    private DataStoreCache datastoreCache = null;
    private Set jdoFetchGroups = null;
    private static final String[] OPTION_ARRAY = new String[]{"javax.jdo.option.TransientTransactional", "javax.jdo.option.NontransactionalWrite", "javax.jdo.option.NontransactionalRead", "javax.jdo.option.RetainValues", "javax.jdo.option.Optimistic", "javax.jdo.option.ApplicationIdentity", "javax.jdo.option.DatastoreIdentity", "javax.jdo.option.NonDurableIdentity", "javax.jdo.option.BinaryCompatibility", "javax.jdo.option.GetDataStoreConnection", "javax.jdo.option.GetJDBCConnection", "javax.jdo.option.version.DateTime", "javax.jdo.option.PreDirtyEvent", "javax.jdo.option.ArrayList", "javax.jdo.option.LinkedList", "javax.jdo.option.TreeSet", "javax.jdo.option.TreeMap", "javax.jdo.option.Vector", "javax.jdo.option.List", "javax.jdo.option.Stack", "javax.jdo.option.Map", "javax.jdo.option.HashMap", "javax.jdo.option.Hashtable", "javax.jdo.option.SortedSet", "javax.jdo.option.SortedMap", "javax.jdo.option.Array", "javax.jdo.option.NullCollection", "javax.jdo.option.mapping.HeterogeneousObjectType", "javax.jdo.option.mapping.HeterogeneousInterfaceType", "javax.jdo.option.mapping.JoinedTablePerClass", "javax.jdo.option.mapping.JoinedTablePerConcreteClass", "javax.jdo.option.mapping.NonJoinedTablePerConcreteClass", "javax.jdo.query.SQL", "javax.jdo.query.JDOQL", "javax.jdo.option.UnconstrainedQueryVariables"};
    static /* synthetic */ Class class$org$datanucleus$jdo$AbstractPersistenceManagerFactory;
    static /* synthetic */ Class class$javax$jdo$PersistenceManager;
    static /* synthetic */ Class class$java$lang$Object;

    public AbstractPersistenceManagerFactory() {
        try {
            Class cls = class$javax$jdo$PersistenceManager == null ? (class$javax$jdo$PersistenceManager = AbstractPersistenceManagerFactory.class$("javax.jdo.PersistenceManager")) : class$javax$jdo$PersistenceManager;
            cls.getMethod("detachCopy", class$java$lang$Object == null ? (class$java$lang$Object = AbstractPersistenceManagerFactory.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (SecurityException e) {
            throw new JDOFatalUserException(LOCALISER_JDO.msg("012003"));
        }
        catch (NoSuchMethodException e) {
            throw new JDOFatalUserException(LOCALISER_JDO.msg("012003"));
        }
    }

    protected void freezeConfiguration() {
        if (this.configurable) {
            try {
                this.logConfiguration();
                ClassLoaderResolver clr = this.getOMFContext().getClassLoaderResolver(null);
                clr.registerUserClassLoader((ClassLoader)this.getProperty("datanucleus.primaryClassLoader"));
                this.initialiseStoreManager(clr);
                this.initialiseLevel2Cache();
                if (this.cache != null) {
                    this.datastoreCache = new JDODataStoreCache(this.cache);
                }
                this.configurable = false;
            }
            catch (TransactionIsolationNotSupportedException inse) {
                throw new JDOUnsupportedOptionException(inse.getMessage());
            }
            catch (NucleusException jpe) {
                throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
            }
        }
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.setProperty(VENDOR_NAME_PROPERTY, ObjectManagerFactoryImpl.getVendorName());
        props.setProperty(VERSION_NUMBER_PROPERTY, ObjectManagerFactoryImpl.getVersionNumber());
        return props;
    }

    public Collection supportedOptions() {
        ArrayList<String> options = new ArrayList<String>(Arrays.asList(OPTION_ARRAY));
        StoreManager storeMgr = this.getOMFContext().getStoreManager();
        if (storeMgr != null) {
            Collection storeMgrOptions = storeMgr.getSupportedOptions();
            if (!storeMgrOptions.contains("DatastoreIdentity")) {
                options.remove("javax.jdo.option.DatastoreIdentity");
            }
            if (!storeMgrOptions.contains("ApplicationIdentity")) {
                options.remove("javax.jdo.option.ApplicationIdentity");
            }
            if (!storeMgrOptions.contains("OptimisticTransaction")) {
                options.remove("javax.jdo.option.Optimistic");
            }
            if (!storeMgr.supportsQueryLanguage("JDOQL")) {
                options.remove("javax.jdo.query.JDOQL");
            }
            if (!storeMgr.supportsQueryLanguage("SQL")) {
                options.remove("javax.jdo.query.SQL");
            }
            if (storeMgrOptions.contains("TransactionIsolationLevel.read-committed")) {
                options.add("javax.jdo.option.TransactionIsolationLevel.read-committed");
            }
            if (storeMgrOptions.contains("TransactionIsolationLevel.read-uncommitted")) {
                options.add("javax.jdo.option.TransactionIsolationLevel.read-uncommitted");
            }
            if (storeMgrOptions.contains("TransactionIsolationLevel.repeatable-read")) {
                options.add("javax.jdo.option.TransactionIsolationLevel.repeatable-read");
            }
            if (storeMgrOptions.contains("TransactionIsolationLevel.serializable")) {
                options.add("javax.jdo.option.TransactionIsolationLevel.serializable");
            }
            if (storeMgrOptions.contains("TransactionIsolationLevel.snapshot")) {
                options.add("javax.jdo.option.TransactionIsolationLevel.snapshot");
            }
        }
        return Collections.unmodifiableList(options);
    }

    protected Set getPmCache() {
        return this.pmCache;
    }

    public void releasePersistenceManager(JDOPersistenceManager om) {
        this.getPmCache().remove(om);
    }

    protected void assertIsOpen() {
        try {
            super.assertIsOpen();
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public synchronized void close() {
        this.assertIsOpen();
        SecurityManager secmgr = System.getSecurityManager();
        if (secmgr != null) {
            secmgr.checkPermission((Permission)JDOPermission.CLOSE_PERSISTENCE_MANAGER_FACTORY);
        }
        Iterator pms = new HashSet(this.getPmCache()).iterator();
        HashSet<JDOUserException> exceptions = new HashSet<JDOUserException>();
        while (pms.hasNext()) {
            try {
                ((JDOPersistenceManager)pms.next()).close();
            }
            catch (JDOUserException ex) {
                exceptions.add(ex);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new JDOUserException(LOCALISER_JDO.msg("012002"), exceptions.toArray(new Throwable[exceptions.size()]));
        }
        if (this.jdoFetchGroups != null) {
            this.jdoFetchGroups.clear();
        }
        super.close();
    }

    public DataStoreCache getDataStoreCache() {
        this.freezeConfiguration();
        return this.datastoreCache;
    }

    public synchronized void setConnectionUserName(String userName) {
        this.assertConfigurable();
        this.setProperty("datanucleus.ConnectionUserName", userName);
    }

    public synchronized void setConnectionPassword(String password) {
        this.assertConfigurable();
        this.setProperty("datanucleus.ConnectionPassword", password);
    }

    public synchronized void setConnectionURL(String url) {
        this.assertConfigurable();
        this.setProperty("datanucleus.ConnectionURL", url);
    }

    public synchronized void setConnectionDriverName(String driverName) {
        this.assertConfigurable();
        this.setProperty("datanucleus.ConnectionDriverName", driverName);
    }

    public synchronized void setConnectionFactoryName(String connectionFactoryName) {
        this.assertConfigurable();
        this.setProperty("datanucleus.ConnectionFactoryName", connectionFactoryName);
    }

    public synchronized void setConnectionFactory(Object connectionFactory) {
        this.assertConfigurable();
        this.setProperty("datanucleus.ConnectionFactory", connectionFactory);
    }

    public synchronized void setConnectionFactory2Name(String connectionFactoryName) {
        this.assertConfigurable();
        this.setProperty("datanucleus.ConnectionFactory2Name", connectionFactoryName);
    }

    public synchronized void setConnectionFactory2(Object connectionFactory) {
        this.assertConfigurable();
        this.setProperty("datanucleus.ConnectionFactory2", connectionFactory);
    }

    public synchronized void setMultithreaded(boolean flag) {
        this.assertConfigurable();
        this.setProperty("datanucleus.Multithreaded", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setOptimistic(boolean flag) {
        this.assertConfigurable();
        this.setProperty("datanucleus.Optimistic", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setRetainValues(boolean flag) {
        this.assertConfigurable();
        this.setProperty("datanucleus.RetainValues", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setRestoreValues(boolean flag) {
        this.assertConfigurable();
        this.setProperty("datanucleus.RestoreValues", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setNontransactionalRead(boolean flag) {
        this.assertConfigurable();
        this.setProperty("datanucleus.NontransactionalRead", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setNontransactionalWrite(boolean flag) {
        this.assertConfigurable();
        this.setProperty("datanucleus.NontransactionalWrite", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setIgnoreCache(boolean flag) {
        this.assertConfigurable();
        this.setProperty("datanucleus.IgnoreCache", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setDetachAllOnCommit(boolean flag) {
        this.assertConfigurable();
        this.setProperty("datanucleus.DetachAllOnCommit", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setCopyOnAttach(boolean flag) {
        this.assertConfigurable();
        this.setProperty("datanucleus.CopyOnAttach", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setMapping(String mapping) {
        this.assertConfigurable();
        this.setProperty("datanucleus.Mapping", mapping);
    }

    public synchronized void setCatalog(String catalog) {
        this.assertConfigurable();
        this.setProperty("datanucleus.mapping.Catalog", catalog);
    }

    public synchronized void setSchema(String schema) {
        this.assertConfigurable();
        this.setProperty("datanucleus.mapping.Schema", schema);
    }

    public synchronized void setTransactionType(String type) {
        this.assertConfigurable();
        boolean validated = new CorePropertyValidator().validate("datanucleus.TransactionType", type);
        if (!validated) {
            throw new JDOUserException(PersistenceConfiguration.LOCALISER.msg("008012", (Object)"javax.jdo.option.TransactionType", (Object)type));
        }
        this.setProperty("datanucleus.TransactionType", type);
    }

    public synchronized void setPersistenceUnitName(String name) {
        this.assertConfigurable();
        this.setProperty("datanucleus.PersistenceUnitName", name);
    }

    public synchronized void setPersistenceXmlFilename(String name) {
        this.assertConfigurable();
        this.setProperty("datanucleus.persistenceXmlFilename", name);
    }

    public synchronized void setName(String name) {
        this.assertConfigurable();
        this.setProperty("datanucleus.Name", name);
    }

    public void setServerTimeZoneID(String id) {
        boolean validated = new CorePropertyValidator().validate("datanucleus.ServerTimeZoneID", id);
        if (!validated) {
            throw new JDOUserException("Invalid TimeZone ID specified");
        }
        this.setProperty("datanucleus.ServerTimeZoneID", id);
    }

    public synchronized void setReadOnly(boolean flag) {
        this.assertConfigurable();
        this.setProperty("datanucleus.ReadOnly", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setTransactionIsolationLevel(String level) {
        this.assertConfigurable();
        if (this.omfContext != null && this.omfContext.getStoreManager() != null && !this.omfContext.getStoreManager().getSupportedOptions().contains("TransactionIsolationLevel." + level)) {
            throw new JDOUnsupportedOptionException("Isolation level \"" + level + "\" is not supported for this datastore");
        }
        this.setProperty("datanucleus.transactionIsolation", level != null ? level : "read-committed");
    }

    public String getConnectionUserName() {
        return this.getStringProperty("datanucleus.ConnectionUserName");
    }

    public String getConnectionPassword() {
        return this.getStringProperty("datanucleus.ConnectionPassword");
    }

    public String getConnectionURL() {
        return this.getStringProperty("datanucleus.ConnectionURL");
    }

    public String getConnectionDriverName() {
        return this.getStringProperty("datanucleus.ConnectionDriverName");
    }

    public String getConnectionFactoryName() {
        return this.getStringProperty("datanucleus.ConnectionFactoryName");
    }

    public String getConnectionFactory2Name() {
        return this.getStringProperty("datanucleus.ConnectionFactory2Name");
    }

    public Object getConnectionFactory() {
        return this.getProperty("datanucleus.ConnectionFactory");
    }

    public Object getConnectionFactory2() {
        return this.getProperty("datanucleus.ConnectionFactory2");
    }

    public boolean getMultithreaded() {
        return this.getBooleanProperty("datanucleus.Multithreaded");
    }

    public boolean getOptimistic() {
        return this.getBooleanProperty("datanucleus.Optimistic");
    }

    public boolean getRetainValues() {
        return this.getBooleanProperty("datanucleus.RetainValues");
    }

    public boolean getRestoreValues() {
        return this.getBooleanProperty("datanucleus.RestoreValues");
    }

    public boolean getNontransactionalRead() {
        return this.getBooleanProperty("datanucleus.NontransactionalRead");
    }

    public boolean getNontransactionalWrite() {
        return this.getBooleanProperty("datanucleus.NontransactionalWrite");
    }

    public boolean getIgnoreCache() {
        return this.getBooleanProperty("datanucleus.IgnoreCache");
    }

    public boolean getDetachAllOnCommit() {
        return this.getBooleanProperty("datanucleus.DetachAllOnCommit");
    }

    public boolean getCopyOnAttach() {
        return this.getBooleanProperty("datanucleus.CopyOnAttach");
    }

    public String getMapping() {
        return this.getStringProperty("datanucleus.Mapping");
    }

    public String getCatalog() {
        return this.getStringProperty("datanucleus.mapping.Catalog");
    }

    public String getSchema() {
        return this.getStringProperty("datanucleus.mapping.Schema");
    }

    public String getName() {
        return this.getStringProperty("datanucleus.Name");
    }

    public String getPersistenceUnitName() {
        return this.getStringProperty("datanucleus.PersistenceUnitName");
    }

    public String getPersistenceXmlFilename() {
        return this.getStringProperty("datanucleus.persistenceXmlFilename");
    }

    public String getServerTimeZoneID() {
        return this.getStringProperty("datanucleus.ServerTimeZoneID");
    }

    public boolean getReadOnly() {
        return this.getBooleanProperty("datanucleus.ReadOnly");
    }

    public String getTransactionType() {
        return this.getStringProperty("datanucleus.TransactionType");
    }

    public String getTransactionIsolationLevel() {
        return this.getStringProperty("datanucleus.transactionIsolation");
    }

    protected void assertConfigurable() {
        if (!this.configurable) {
            throw new JDOUserException(PersistenceConfiguration.LOCALISER.msg("008016"));
        }
    }

    public List getLifecycleListenerSpecifications() {
        return this.lifecycleListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceLifecycleListener(InstanceLifecycleListener listener, Class[] classes) {
        if (listener == null) {
            return;
        }
        Set set = this.pmCache;
        synchronized (set) {
            Iterator pms = this.getPmCache().iterator();
            while (pms.hasNext()) {
                JDOPersistenceManager pm = (JDOPersistenceManager)pms.next();
                pm.addInstanceLifecycleListener(listener, classes);
            }
        }
        if (this.lifecycleListeners == null) {
            this.lifecycleListeners = new ArrayList(5);
        }
        this.lifecycleListeners.add(new LifecycleListenerForClass(listener, classes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceLifecycleListener(InstanceLifecycleListener listener) {
        if (listener == null || this.lifecycleListeners == null) {
            return;
        }
        Set set = this.pmCache;
        synchronized (set) {
            Iterator pms = this.getPmCache().iterator();
            while (pms.hasNext()) {
                JDOPersistenceManager pm = (JDOPersistenceManager)pms.next();
                pm.removeInstanceLifecycleListener(listener);
            }
        }
        Iterator iter = this.lifecycleListeners.iterator();
        while (iter.hasNext()) {
            LifecycleListenerForClass classListener = (LifecycleListenerForClass)iter.next();
            if (classListener.getListener() != listener) continue;
            iter.remove();
        }
    }

    public void addSequenceForFactoryClass(String factoryClassName, Sequence sequence) {
        if (this.sequenceByFactoryClass == null) {
            this.sequenceByFactoryClass = new HashMap();
        }
        this.sequenceByFactoryClass.put(factoryClassName, sequence);
    }

    public Sequence getSequenceForFactoryClass(String factoryClassName) {
        if (this.sequenceByFactoryClass == null) {
            return null;
        }
        return (Sequence)this.sequenceByFactoryClass.get(factoryClassName);
    }

    public Set getFetchGroups() {
        if (this.jdoFetchGroups == null) {
            return null;
        }
        return this.jdoFetchGroups;
    }

    public javax.jdo.FetchGroup getFetchGroup(Class cls, String name) {
        if (this.jdoFetchGroups == null) {
            this.jdoFetchGroups = new HashSet();
        }
        Iterator iter = this.jdoFetchGroups.iterator();
        while (iter.hasNext()) {
            JDOFetchGroup jdoGrp = (JDOFetchGroup)iter.next();
            if (!jdoGrp.getName().equals(name) || jdoGrp.getType() != cls) continue;
            return jdoGrp;
        }
        try {
            FetchGroup internalGrp = this.getInternalFetchGroup(cls, name);
            if (!internalGrp.isUnmodifiable()) {
                return new JDOFetchGroup(internalGrp);
            }
            internalGrp = this.createInternalFetchGroup(cls, name);
            this.addInternalFetchGroup(internalGrp);
            JDOFetchGroup jdoGrp = new JDOFetchGroup(internalGrp);
            return jdoGrp;
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public void addFetchGroups(javax.jdo.FetchGroup[] groups) {
        if (groups == null || groups.length == 0) {
            return;
        }
        if (this.jdoFetchGroups == null) {
            this.jdoFetchGroups = new HashSet();
        }
        for (int i = 0; i < groups.length; ++i) {
            this.addInternalFetchGroup(((JDOFetchGroup)groups[i]).getInternalFetchGroup());
            this.jdoFetchGroups.add(groups[i]);
        }
    }

    public void removeFetchGroups(javax.jdo.FetchGroup[] groups) {
        if (groups == null || groups.length == 0 || this.jdoFetchGroups == null) {
            return;
        }
        for (int i = 0; i < groups.length; ++i) {
            JDOFetchGroup jdoGrp = (JDOFetchGroup)groups[i];
            this.removeInternalFetchGroup(jdoGrp.getInternalFetchGroup());
            this.jdoFetchGroups.remove(jdoGrp);
        }
    }

    public void removeAllFetchGroups() {
        if (this.jdoFetchGroups != null) {
            Iterator iter = this.jdoFetchGroups.iterator();
            while (iter.hasNext()) {
                JDOFetchGroup jdoGrp = (JDOFetchGroup)iter.next();
                this.removeInternalFetchGroup(jdoGrp.getInternalFetchGroup());
            }
            this.jdoFetchGroups.clear();
            this.jdoFetchGroups = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

