/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.util;

import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ReadWriteLock {
    private static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = ReadWriteLock.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    private static final int WAIT_LOG_INTERVAL = 5000;
    private ThreadLocal readLocksByThread = new ThreadLocal(){

        public Object initialValue() {
            return new Count();
        }
    };
    private int readLocks = 0;
    private int writeLocks = 0;
    private Thread writeLockedBy = null;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public synchronized void readLock() throws InterruptedException {
        Thread me = Thread.currentThread();
        Count myReadLocks = (Count)this.readLocksByThread.get();
        if (this.writeLockedBy != me) {
            while (this.writeLocks > 0) {
                this.wait(5000L);
                if (this.writeLocks <= 0 || !NucleusLogger.GENERAL.isDebugEnabled()) continue;
                NucleusLogger.GENERAL.debug(LOCALISER.msg("030000", this), new InterruptedException());
            }
        }
        ++this.readLocks;
        ++myReadLocks.value;
    }

    public synchronized void writeLock() throws InterruptedException {
        Thread me = Thread.currentThread();
        Count myReadLocks = (Count)this.readLocksByThread.get();
        if (myReadLocks.value > 0) {
            throw new IllegalStateException(LOCALISER.msg("030001"));
        }
        if (this.writeLockedBy != me) {
            while (this.writeLocks > 0 || this.readLocks > 0) {
                this.wait(5000L);
                if (this.writeLocks <= 0 && this.readLocks <= 0 || !NucleusLogger.GENERAL.isDebugEnabled()) continue;
                NucleusLogger.GENERAL.debug(LOCALISER.msg("030002", this), new InterruptedException());
            }
            this.writeLockedBy = me;
        }
        ++this.writeLocks;
    }

    public synchronized void unlock() {
        Thread me = Thread.currentThread();
        Count myReadLocks = (Count)this.readLocksByThread.get();
        if (myReadLocks.value > 0) {
            --myReadLocks.value;
            --this.readLocks;
        } else if (this.writeLockedBy == me && this.writeLocks > 0 && --this.writeLocks == 0) {
            this.writeLockedBy = null;
        }
        this.notifyAll();
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString());
        s.append(": readLocks = ").append(this.readLocks).append(", writeLocks = ").append(this.writeLocks).append(", writeLockedBy = ").append(this.writeLockedBy);
        return s.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Count {
        public int value = 0;

        private Count() {
        }
    }
}

