/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.query.JDOQLSingleStringParser;
import org.datanucleus.query.compiler.JDOQLCompiler;
import org.datanucleus.query.compiler.JavaQueryCompiler;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractJDOQLQuery
extends AbstractJavaQuery {
    public AbstractJDOQLQuery(ObjectManager om) {
        super(om);
    }

    public AbstractJDOQLQuery(ObjectManager om, AbstractJDOQLQuery q) {
        this(om);
        if (q == null) {
            this.candidateClass = null;
            this.candidateClassName = null;
            this.filter = null;
            this.imports = null;
            this.explicitVariables = null;
            this.explicitParameters = null;
            this.grouping = null;
            this.ordering = null;
            this.result = null;
            this.resultClass = null;
            this.resultClassName = null;
            this.resultDistinct = false;
            this.range = null;
            this.fromInclNo = 0L;
            this.toExclNo = Long.MAX_VALUE;
        } else {
            this.candidateClass = q.candidateClass;
            this.candidateClassName = q.candidateClassName;
            this.filter = q.filter;
            this.imports = q.imports;
            this.explicitVariables = q.explicitVariables;
            this.explicitParameters = q.explicitParameters;
            this.grouping = q.grouping;
            this.ordering = q.ordering;
            this.result = q.result;
            this.resultClass = q.resultClass;
            this.resultClassName = q.resultClassName;
            this.resultDistinct = q.resultDistinct;
            this.range = q.range;
            this.fromInclNo = q.fromInclNo;
            this.toExclNo = q.toExclNo;
            this.ignoreCache = q.ignoreCache;
        }
    }

    public AbstractJDOQLQuery(ObjectManager om, String query) {
        this(om);
        new JDOQLSingleStringParser(this, query).parse();
        if (this.candidateClassName != null) {
            try {
                this.candidateClass = this.getParsedImports().resolveClassDeclaration(this.candidateClassName, om.getClassLoaderResolver(), null);
                this.candidateClassName = this.candidateClass.getName();
            }
            catch (ClassNotResolvedException e) {
                NucleusLogger.QUERY.warn("Candidate class for JDOQL single-string query (" + this.candidateClassName + ") could not be resolved", e);
            }
        }
    }

    public void setGrouping(String grouping) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.grouping = null;
        this.setHaving(null);
        if (grouping != null && grouping.length() > 0) {
            if (grouping.indexOf("HAVING") >= 0) {
                this.setHaving(grouping.substring(grouping.indexOf("HAVING") + 7));
                this.grouping = grouping.substring(0, grouping.indexOf("HAVING") - 1);
            } else if (grouping.indexOf("having") >= 0) {
                this.setHaving(grouping.substring(grouping.indexOf("having") + 7));
                this.grouping = grouping.substring(0, grouping.indexOf("having") - 1);
            } else {
                this.grouping = grouping.trim();
            }
        }
    }

    public void setResult(String result) {
        this.discardCompiled();
        this.assertIsModifiable();
        if (result == null) {
            this.result = null;
            this.resultDistinct = false;
            return;
        }
        String str = result.trim();
        if (str.startsWith("distinct ") || str.startsWith("DISTINCT ")) {
            this.resultDistinct = true;
            this.result = str.substring(8).trim();
        } else {
            this.resultDistinct = false;
            this.result = str;
        }
    }

    public String getSingleStringQuery() {
        if (this.singleString != null) {
            return this.singleString;
        }
        StringBuffer str = new StringBuffer("SELECT ");
        if (this.unique) {
            str.append("UNIQUE ");
        }
        if (this.result != null) {
            if (this.resultDistinct) {
                str.append("DISTINCT ");
            }
            str.append(this.result + " ");
        }
        if (this.resultClassName != null) {
            str.append("INTO " + this.resultClassName + " ");
        }
        if (this.from != null) {
            str.append("FROM " + this.from + " ");
        } else if (this.candidateClassName != null) {
            str.append("FROM " + this.candidateClassName + " ");
            if (!this.subclasses) {
                str.append("EXCLUDE SUBCLASSES ");
            }
        }
        if (this.filter != null) {
            str.append("WHERE " + this.filter + " ");
        }
        if (this.explicitVariables != null) {
            str.append("VARIABLES " + this.explicitVariables + " ");
        }
        if (this.explicitParameters != null) {
            str.append("PARAMETERS " + this.explicitParameters + " ");
        }
        if (this.imports != null) {
            str.append(this.imports + " ");
        }
        if (this.grouping != null) {
            str.append("GROUP BY " + this.grouping + " ");
        }
        if (this.having != null) {
            str.append("HAVING " + this.having + " ");
        }
        if (this.ordering != null) {
            str.append("ORDER BY " + this.ordering + " ");
        }
        if (this.range != null) {
            str.append("RANGE " + this.range);
        } else if (this.fromInclNo > 0L || this.toExclNo != Long.MAX_VALUE) {
            str.append("RANGE " + this.fromInclNo + "," + this.toExclNo);
        }
        this.singleString = str.toString().trim();
        return this.singleString;
    }

    protected void compileInternal(boolean forExecute, Map parameterValues) {
        if (this.compilation != null) {
            return;
        }
        QueryManager queryMgr = this.om.getOMFContext().getQueryManager();
        QueryCompilation cachedCompilation = queryMgr.getQueryCompilationForQuery("JDOQL", this.toString());
        if (cachedCompilation != null) {
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(Query.LOCALISER.msg("021079", (Object)this.toString(), (Object)"JDOQL"));
            }
            this.compilation = cachedCompilation;
            return;
        }
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug(Query.LOCALISER.msg("021044", (Object)"JDOQL", (Object)this.getSingleStringQuery(), (Object)(forExecute ? "execution" : "compile")));
        }
        JDOQLCompiler compiler = new JDOQLCompiler(this.om.getMetaDataManager(), this.om.getClassLoaderResolver(), null, this.candidateClass, this.candidateCollection, this.filter, this.getParsedImports(), this.ordering, this.result, this.grouping, this.having, this.explicitParameters, this.explicitVariables);
        this.compilation = ((JavaQueryCompiler)compiler).compile(parameterValues);
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug(Query.LOCALISER.msg("021045", (Object)"JDOQL", (Object)("" + (System.currentTimeMillis() - startTime))));
        }
        if (this.subqueries != null) {
            Iterator iter = this.subqueries.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Query.SubqueryDefinition subqueryDefinition = (Query.SubqueryDefinition)entry.getValue();
                Query subquery = subqueryDefinition.getQuery();
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    startTime = System.currentTimeMillis();
                    NucleusLogger.QUERY.debug(Query.LOCALISER.msg("021044", (Object)"JDOQL", (Object)((AbstractJDOQLQuery)subquery).getSingleStringQuery(), (Object)(forExecute ? "execution" : "compile")));
                }
                compiler = new JDOQLCompiler(this.om.getMetaDataManager(), this.om.getClassLoaderResolver(), null, subquery.candidateClass, null, subquery.filter, this.getParsedImports(), subquery.ordering, subquery.result, subquery.grouping, subquery.having, null, null);
                QueryCompilation subqueryCompilation = ((JavaQueryCompiler)compiler).compile(parameterValues);
                this.compilation.addSubqueryCompilation((String)entry.getKey(), subqueryCompilation);
                if (!NucleusLogger.QUERY.isDebugEnabled()) continue;
                NucleusLogger.QUERY.debug(Query.LOCALISER.msg("021045", (Object)"JDOQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
        }
        queryMgr.addQueryCompilation("JDOQL", this.toString(), this.compilation);
    }
}

