/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.FetchPlan;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.jdo.NucleusJDOHelper;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.sco.SCO;
import org.datanucleus.sco.SCOContainer;
import org.datanucleus.state.CacheState;
import org.datanucleus.state.JDOStateManagerImpl;
import org.datanucleus.store.fieldmanager.AbstractFetchFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class CachePopulateFieldManager
extends AbstractFetchFieldManager {
    CachedPC cachedPC;
    static /* synthetic */ Class class$java$util$List;

    public CachePopulateFieldManager(StateManager sm, boolean[] secondClassMutableFields, FetchPlan.FetchPlanForClass fpClass, CacheState state, CachedPC cacheable) {
        super(sm, secondClassMutableFields, fpClass, state);
        this.cachedPC = cacheable;
    }

    protected Object processPersistable(AbstractMemberMetaData mmd, Object pc) {
        if (pc == null) {
            return null;
        }
        ApiAdapter api = this.sm.getObjectManager().getApiAdapter();
        if (!api.isPersistable(pc)) {
            return pc;
        }
        if (api.isDetached(pc)) {
            NucleusLogger.CACHE.warn(">> CachePopulateFM.processPersistable this=" + StringUtils.toJVMIDString(this.sm.getObject()) + " field=" + mmd.getFullFieldName() + " pc=" + StringUtils.toJVMIDString(pc) + " state=" + NucleusJDOHelper.getObjectStateAsString(pc) + " IS DETACHED!");
            return null;
        }
        CacheState cacheState = (CacheState)this.state;
        if (cacheState.contains(api.getIdForObject(pc))) {
            CachedPC cachePC = cacheState.getCacheableObject(api.getIdForObject(pc));
            return cachePC.getPersistableObject();
        }
        StateManager pcSM = this.sm.getObjectManager().findStateManager(pc);
        if (pcSM != null) {
            return ((JDOStateManagerImpl)pcSM).cache(cacheState);
        }
        return null;
    }

    protected Object internalFetchObjectField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        Object value = sfv.fetchObjectField(fieldNumber);
        ApiAdapter api = this.sm.getObjectManager().getApiAdapter();
        if (value == null) {
            return null;
        }
        AbstractMemberMetaData fmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!fmd.isCacheable()) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return null;
        }
        if (api.isPersistable(value)) {
            if (fmd.isSerialized() || fmd.isEmbedded()) {
                this.cachedPC.getLoadedFields()[fieldNumber] = false;
                return null;
            }
            Object cachePC = this.processPersistable(fmd, value);
            if (cachePC == null) {
                this.cachedPC.getLoadedFields()[fieldNumber] = false;
                return null;
            }
            this.cachedPC.setRelationField(fmd.getName(), api.getIdForObject(value));
            return null;
        }
        if (value instanceof Collection) {
            if (MetaDataUtils.getInstance().storesPersistable(fmd, this.sm.getObjectManager().getClassLoaderResolver())) {
                if (fmd.isSerialized() || fmd.isEmbedded() || fmd.getCollection().isSerializedElement() || fmd.getCollection().isEmbeddedElement()) {
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return null;
                }
                Collection collValue = (Collection)value;
                if (collValue instanceof SCO && !((SCOContainer)value).isLoaded()) {
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return null;
                }
                Iterator collIter = collValue.iterator();
                Collection returnColl = null;
                try {
                    returnColl = value.getClass().isInterface() ? ((class$java$util$List == null ? (class$java$util$List = CachePopulateFieldManager.class$("java.util.List")) : class$java$util$List).isAssignableFrom(value.getClass()) || fmd.getOrderMetaData() != null ? new ArrayList() : new HashSet()) : (value instanceof SCO ? (Collection)((SCO)value).getValue().getClass().newInstance() : (ArrayList)value.getClass().newInstance());
                    while (collIter.hasNext()) {
                        Object elem = collIter.next();
                        this.processPersistable(fmd, elem);
                        returnColl.add(api.getIdForObject(elem));
                    }
                    this.cachedPC.setRelationField(fmd.getName(), returnColl);
                    return null;
                }
                catch (Exception e) {
                    throw new NucleusException("Unable to create object of type " + value.getClass().getName(), e);
                }
            }
            if (value instanceof SCOContainer) {
                if (((SCOContainer)value).isLoaded()) {
                    return ((SCO)value).getValue();
                }
                this.cachedPC.getLoadedFields()[fieldNumber] = false;
                return null;
            }
            return value;
        }
        if (value instanceof Map) {
            if (MetaDataUtils.getInstance().storesPersistable(fmd, this.sm.getObjectManager().getClassLoaderResolver())) {
                if (fmd.isSerialized() || fmd.isEmbedded() || fmd.getMap().isSerializedKey() || fmd.getMap().isEmbeddedKey() || fmd.getMap().isSerializedValue() || fmd.getMap().isEmbeddedValue()) {
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return null;
                }
                if (value instanceof SCO && !((SCOContainer)value).isLoaded()) {
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return null;
                }
                try {
                    Map returnMap = null;
                    returnMap = value.getClass().isInterface() ? new HashMap() : (value instanceof SCO ? (Map)((SCO)value).getValue().getClass().newInstance() : (Map)value.getClass().newInstance());
                    Iterator mapIter = ((Map)value).entrySet().iterator();
                    while (mapIter.hasNext()) {
                        Map.Entry entry = mapIter.next();
                        Object mapKey = null;
                        Object mapValue = null;
                        if (fmd.getMap().getKeyClassMetaData() != null) {
                            this.processPersistable(fmd, entry.getKey());
                            mapKey = api.getIdForObject(entry.getKey());
                        } else {
                            mapKey = entry.getKey();
                        }
                        if (fmd.getMap().getValueClassMetaData() != null) {
                            this.processPersistable(fmd, entry.getValue());
                            mapValue = api.getIdForObject(entry.getValue());
                        } else {
                            mapValue = entry.getValue();
                        }
                        returnMap.put(mapKey, mapValue);
                    }
                    this.cachedPC.setRelationField(fmd.getName(), returnMap);
                    return null;
                }
                catch (Exception e) {
                    throw new NucleusException("Unable to create object of type " + value.getClass().getName(), e);
                }
            }
            if (value instanceof SCOContainer) {
                if (((SCOContainer)value).isLoaded()) {
                    return ((SCO)value).getValue();
                }
                this.cachedPC.getLoadedFields()[fieldNumber] = false;
                return null;
            }
            return value;
        }
        if (value instanceof Object[]) {
            if (!api.isPersistable(fmd.getType().getComponentType())) {
                return value;
            }
            Object[] returnArr = new Object[Array.getLength(value)];
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object element = Array.get(value, i);
                this.processPersistable(fmd, element);
                returnArr[i] = api.getIdForObject(element);
            }
            this.cachedPC.setRelationField(fmd.getName(), returnArr);
            return null;
        }
        if (value instanceof SCO) {
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug("CachePopulateFM.fetchObjectField this=" + StringUtils.toJVMIDString(this.sm.getObject()) + " field=" + fieldNumber + " is having its SCO wrapper replaced prior to L2 caching.");
            }
            return ((SCO)value).getValue();
        }
        return value;
    }

    protected Object endOfGraphOperation(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        Object value = sfv.fetchObjectField(fieldNumber);
        AbstractMemberMetaData fmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        ApiAdapter api = this.sm.getObjectManager().getApiAdapter();
        CacheState cacheState = (CacheState)this.state;
        if (api.isPersistable(value) && cacheState.contains(api.getIdForObject(value))) {
            this.cachedPC.setRelationField(fmd.getName(), api.getIdForObject(value));
            return null;
        }
        this.cachedPC.getLoadedFields()[fieldNumber] = false;
        throw new AbstractFetchFieldManager.EndOfFetchPlanGraphException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

