/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query;

import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.JDOQLQueryHelper;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JDOQLSingleStringParser {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = JDOQLSingleStringParser.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    private Query query;
    private String queryString;
    int keywordPosition = -1;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;
    static /* synthetic */ Class class$org$datanucleus$ObjectManager;
    static /* synthetic */ Class class$java$lang$String;

    public JDOQLSingleStringParser(Query query, String queryString) {
        NucleusLogger.QUERY.debug(LOCALISER.msg("042010", (Object)queryString));
        this.query = query;
        this.queryString = queryString;
    }

    public void parse() {
        new Compiler(new Parser(this.queryString)).compile();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Parser {
        final String queryString;
        int queryStringPos = 0;
        final String[] tokens;
        final String[] keywords;
        int tokenIndex = -1;

        public Parser(String str) {
            this.queryString = str;
            StringTokenizer tokenizer = new StringTokenizer(str);
            this.tokens = new String[tokenizer.countTokens()];
            this.keywords = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                this.tokens[i] = tokenizer.nextToken();
                if (JDOQLQueryHelper.isKeyword(this.tokens[i])) {
                    this.keywords[i] = this.tokens[i];
                }
                ++i;
            }
        }

        public String parseContent(boolean allowSubentries) {
            String content = "";
            int level = 0;
            while (this.tokenIndex < this.tokens.length - 1) {
                ++this.tokenIndex;
                if (allowSubentries) {
                    for (int i = 0; i < this.tokens[this.tokenIndex].length(); ++i) {
                        char c = this.tokens[this.tokenIndex].charAt(i);
                        if (c == '(') {
                            ++level;
                            continue;
                        }
                        if (c != ')') continue;
                        --level;
                    }
                }
                if (level == 0 && JDOQLQueryHelper.isKeyword(this.tokens[this.tokenIndex])) {
                    --this.tokenIndex;
                    break;
                }
                int endPos = this.queryString.indexOf(this.tokens[this.tokenIndex], this.queryStringPos) + this.tokens[this.tokenIndex].length();
                String contentValue = this.queryString.substring(this.queryStringPos, endPos);
                this.queryStringPos = endPos;
                if (content.length() == 0) {
                    content = contentValue;
                    continue;
                }
                content = content + contentValue;
            }
            return content;
        }

        public boolean parseKeyword(String keyword) {
            if (this.tokenIndex < this.tokens.length - 1) {
                ++this.tokenIndex;
                if (this.keywords[this.tokenIndex] != null && this.keywords[this.tokenIndex].equals(keyword)) {
                    this.queryStringPos = this.queryString.indexOf(this.keywords[this.tokenIndex], this.queryStringPos) + this.keywords[this.tokenIndex].length() + 1;
                    return true;
                }
                --this.tokenIndex;
            }
            return false;
        }

        public String parseKeyword() {
            if (this.tokenIndex < this.tokens.length - 1) {
                ++this.tokenIndex;
                if (this.keywords[this.tokenIndex] != null) {
                    return this.keywords[this.tokenIndex];
                }
                --this.tokenIndex;
            }
            return null;
        }
    }

    private class Compiler {
        Parser tokenizer;

        Compiler(Parser tokenizer) {
            this.tokenizer = tokenizer;
        }

        private void compile() {
            this.compileSelect();
            String keyword = this.tokenizer.parseKeyword();
            if (keyword != null && JDOQLQueryHelper.isKeyword(keyword)) {
                throw new NucleusUserException(LOCALISER.msg("042011", (Object)keyword));
            }
        }

        private void compileSelect() {
            if (!this.tokenizer.parseKeyword("SELECT") && !this.tokenizer.parseKeyword("select")) {
                throw new NucleusUserException(LOCALISER.msg("042012"));
            }
            if (this.tokenizer.parseKeyword("UNIQUE") || this.tokenizer.parseKeyword("unique")) {
                this.compileUnique();
            }
            this.compileResult();
            if (this.tokenizer.parseKeyword("INTO") || this.tokenizer.parseKeyword("into")) {
                this.compileInto();
            }
            if (this.tokenizer.parseKeyword("FROM") || this.tokenizer.parseKeyword("from")) {
                this.compileFrom();
            }
            if (this.tokenizer.parseKeyword("WHERE") || this.tokenizer.parseKeyword("where")) {
                this.compileWhere();
            }
            if (this.tokenizer.parseKeyword("VARIABLES") || this.tokenizer.parseKeyword("variables")) {
                this.compileVariables();
            }
            if (this.tokenizer.parseKeyword("PARAMETERS") || this.tokenizer.parseKeyword("parameters")) {
                this.compileParameters();
            }
            if (this.tokenizer.parseKeyword("import")) {
                this.compileImport();
            }
            if (this.tokenizer.parseKeyword("GROUP") || this.tokenizer.parseKeyword("group")) {
                this.compileGroup();
            }
            if (this.tokenizer.parseKeyword("ORDER") || this.tokenizer.parseKeyword("order")) {
                this.compileOrder();
            }
            if (this.tokenizer.parseKeyword("RANGE") || this.tokenizer.parseKeyword("range")) {
                this.compileRange();
            }
        }

        private void compileUnique() {
            JDOQLSingleStringParser.this.query.setUnique(true);
        }

        private void compileResult() {
            String content = this.tokenizer.parseContent(false);
            if (content.length() > 0) {
                JDOQLSingleStringParser.this.query.setResult(content);
            }
        }

        private void compileInto() {
            String content = this.tokenizer.parseContent(false);
            if (content.length() == 0) {
                throw new NucleusUserException(LOCALISER.msg("042014", (Object)"INTO", (Object)"<result class>"));
            }
            JDOQLSingleStringParser.this.query.setResultClassName(content);
        }

        private void compileFrom() {
            String content = this.tokenizer.parseContent(false);
            if (content.length() == 0) {
                throw new NucleusUserException(LOCALISER.msg("042014", (Object)"FROM", (Object)"<candidate class>"));
            }
            if (content.indexOf(32) > 0) {
                JDOQLSingleStringParser.this.query.setFrom(content.trim());
            } else {
                JDOQLSingleStringParser.this.query.setCandidateClassName(content);
            }
            if (this.tokenizer.parseKeyword("EXCLUDE") || this.tokenizer.parseKeyword("exclude")) {
                if (!this.tokenizer.parseKeyword("SUBCLASSES") && !this.tokenizer.parseKeyword("subclasses")) {
                    throw new NucleusUserException(LOCALISER.msg("042015", (Object)"SUBCLASSES", (Object)"EXCLUDE"));
                }
                content = this.tokenizer.parseContent(false);
                if (content.length() > 0) {
                    throw new NucleusUserException(LOCALISER.msg("042013", (Object)"EXCLUDE SUBCLASSES", (Object)content));
                }
                JDOQLSingleStringParser.this.query.setSubclasses(false);
            }
        }

        private void compileWhere() {
            String content = this.tokenizer.parseContent(true);
            if (content.length() == 0) {
                throw new NucleusUserException(LOCALISER.msg("042014", (Object)"WHERE", (Object)"<filter>"));
            }
            if (content.indexOf("SELECT") > 0 || content.indexOf("select") > 0) {
                StringBuffer contentStr = new StringBuffer(content);
                boolean parsed = false;
                int currentPosition = 0;
                int subqueryNum = 1;
                block0: while (!parsed) {
                    int selectPos1 = contentStr.indexOf("SELECT", currentPosition);
                    int selectPos2 = contentStr.indexOf("select", currentPosition);
                    if (selectPos1 < 0 && selectPos2 < 0) {
                        parsed = true;
                        break;
                    }
                    if (selectPos1 > 0 && selectPos2 > 0) {
                        currentPosition = Math.min(selectPos1, selectPos2);
                    } else if (selectPos1 > 0 && selectPos2 < 0) {
                        currentPosition = selectPos1;
                    } else if (selectPos1 < 0 && selectPos2 > 0) {
                        currentPosition = selectPos2;
                    }
                    int startPosition = currentPosition;
                    for (int i = currentPosition - 1; i >= 0; --i) {
                        if (contentStr.charAt(i) != '(') continue;
                        startPosition = i;
                        break;
                    }
                    int level = 0;
                    for (int i = currentPosition; i < content.length(); ++i) {
                        if (contentStr.charAt(i) == '(') {
                            ++level;
                        } else if (contentStr.charAt(i) == ')') {
                            --level;
                        }
                        if (level != -1) continue;
                        String subqueryString = contentStr.substring(currentPosition, i);
                        String subqueryVarName = "DATANUCLEUS_SUBQUERY_" + subqueryNum;
                        Query subquery = (Query)ClassUtils.newInstance(JDOQLSingleStringParser.this.query.getClass(), new Class[]{class$org$datanucleus$ObjectManager == null ? JDOQLSingleStringParser.class$("org.datanucleus.ObjectManager") : class$org$datanucleus$ObjectManager, class$java$lang$String == null ? JDOQLSingleStringParser.class$("java.lang.String") : class$java$lang$String}, new Object[]{JDOQLSingleStringParser.this.query.getObjectManager(), subqueryString});
                        JDOQLSingleStringParser.this.query.addSubquery(subquery, "double " + subqueryVarName, null, null);
                        contentStr.replace(startPosition, i + 1, subqueryVarName);
                        ++subqueryNum;
                        continue block0;
                    }
                }
                JDOQLSingleStringParser.this.query.setFilter(contentStr.toString());
            } else {
                JDOQLSingleStringParser.this.query.setFilter(content);
            }
        }

        private void compileVariables() {
            String content = this.tokenizer.parseContent(false);
            if (content.length() == 0) {
                throw new NucleusUserException(LOCALISER.msg("042014", (Object)"VARIABLES", (Object)"<variable declarations>"));
            }
            JDOQLSingleStringParser.this.query.declareExplicitVariables(content);
        }

        private void compileParameters() {
            String content = this.tokenizer.parseContent(false);
            if (content.length() == 0) {
                throw new NucleusUserException(LOCALISER.msg("042014", (Object)"PARAMETERS", (Object)"<parameter declarations>"));
            }
            JDOQLSingleStringParser.this.query.declareExplicitParameters(content);
        }

        private void compileImport() {
            String content = "import " + this.tokenizer.parseContent(false);
            while (this.tokenizer.parseKeyword("import")) {
                content = content + "import " + this.tokenizer.parseContent(false);
            }
            JDOQLSingleStringParser.this.query.declareImports(content);
        }

        private void compileGroup() {
            String content = this.tokenizer.parseContent(false);
            if (!this.tokenizer.parseKeyword("BY") && !this.tokenizer.parseKeyword("by")) {
                throw new NucleusUserException(LOCALISER.msg("042015", (Object)"BY", (Object)"GROUP"));
            }
            content = this.tokenizer.parseContent(false);
            if (content.length() == 0) {
                throw new NucleusUserException(LOCALISER.msg("042014", (Object)"GROUP BY", (Object)"<grouping>"));
            }
            JDOQLSingleStringParser.this.query.setGrouping(content);
        }

        private void compileOrder() {
            String content = this.tokenizer.parseContent(false);
            if (!this.tokenizer.parseKeyword("BY") && !this.tokenizer.parseKeyword("by")) {
                throw new NucleusUserException(LOCALISER.msg("042015", (Object)"BY", (Object)"ORDER"));
            }
            content = this.tokenizer.parseContent(false);
            if (content.length() == 0) {
                throw new NucleusUserException(LOCALISER.msg("042014", (Object)"ORDER BY", (Object)"<ordering>"));
            }
            JDOQLSingleStringParser.this.query.setOrdering(content);
        }

        private void compileRange() {
            String content = this.tokenizer.parseContent(false);
            if (content.length() == 0) {
                throw new NucleusUserException(LOCALISER.msg("042014", (Object)"RANGE", (Object)"<range>"));
            }
            JDOQLSingleStringParser.this.query.setRange(content);
        }
    }
}

