/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ContainerComponent;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class MapMetaData
extends ContainerMetaData {
    protected ContainerComponent key;
    protected ContainerComponent value;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Object;

    public MapMetaData(AbstractMemberMetaData parent, MapMetaData mapmd) {
        super(parent);
        this.key = new ContainerComponent();
        this.key.embedded = mapmd.key.embedded;
        this.key.serialized = mapmd.key.serialized;
        this.key.dependent = mapmd.key.dependent;
        this.key.type = mapmd.key.type;
        this.key.classMetaData = mapmd.key.classMetaData;
        this.value = new ContainerComponent();
        this.value.embedded = mapmd.value.embedded;
        this.value.serialized = mapmd.value.serialized;
        this.value.dependent = mapmd.value.dependent;
        this.value.type = mapmd.value.type;
        this.value.classMetaData = mapmd.value.classMetaData;
    }

    public MapMetaData(AbstractMemberMetaData parent, String keyType, String embeddedKey, String dependentKey, String serializedKey, String valueType, String embeddedValue, String dependentValue, String serializedValue) {
        super(parent);
        if (!StringUtils.isWhitespace(keyType) && keyType.indexOf(44) > 0) {
            throw new InvalidMetaDataException(MetaData.LOCALISER, "044143", (Object)parent.getName(), parent.getClassName());
        }
        if (!StringUtils.isWhitespace(valueType) && valueType.indexOf(44) > 0) {
            throw new InvalidMetaDataException(MetaData.LOCALISER, "044144", (Object)parent.getName(), parent.getClassName());
        }
        this.key = new ContainerComponent(parent.getAbstractClassMetaData().getPackageName(), keyType, embeddedKey, serializedKey, dependentKey);
        this.value = new ContainerComponent(parent.getAbstractClassMetaData().getPackageName(), valueType, embeddedValue, serializedValue, dependentValue);
    }

    public void populate(ClassLoaderResolver clr, ClassLoader primary) {
        ValueMetaData valuemd;
        KeyMetaData keymd;
        Class field_type;
        ApiAdapter api = this.getMetaDataManager().getApiAdapter();
        if (!(class$java$util$Map == null ? (class$java$util$Map = MapMetaData.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(field_type = this.getMemberMetaData().getType())) {
            throw new InvalidMetaDataException(MetaData.LOCALISER, "044145", (Object)this.getFieldName(), this.getMemberMetaData().getClassName(false));
        }
        if (this.key.type == null) {
            throw new InvalidMetaDataException(MetaData.LOCALISER, "044146", (Object)this.getFieldName(), this.getMemberMetaData().getClassName(false));
        }
        Class keyTypeClass = null;
        try {
            keyTypeClass = clr.classForName(this.key.type, primary);
        }
        catch (ClassNotResolvedException cnre) {
            try {
                keyTypeClass = clr.classForName(ClassUtils.getJavaLangClassForType(this.key.type), primary);
            }
            catch (ClassNotResolvedException cnre2) {
                throw new InvalidMetaDataException(MetaData.LOCALISER, "044147", (Object)this.getFieldName(), (Object)this.getMemberMetaData().getClassName(false), this.key.type);
            }
        }
        if (!keyTypeClass.getName().equals(this.key.type)) {
            NucleusLogger.METADATA.info(MetaData.LOCALISER.msg("044148", (Object)this.getFieldName(), (Object)this.getMemberMetaData().getClassName(false), (Object)this.key.type, (Object)keyTypeClass.getName()));
            this.key.type = keyTypeClass.getName();
        }
        if (this.key.embedded == null) {
            this.key.embedded = this.getMetaDataManager().getOMFContext().getTypeManager().isDefaultEmbeddedType(keyTypeClass) ? Boolean.TRUE : (api.isPersistable(keyTypeClass) || (class$java$lang$Object == null ? (class$java$lang$Object = MapMetaData.class$("java.lang.Object")) : class$java$lang$Object).isAssignableFrom(keyTypeClass) || keyTypeClass.isInterface() ? Boolean.FALSE : Boolean.TRUE);
        }
        if (this.key.embedded == Boolean.FALSE && !api.isPersistable(keyTypeClass) && !keyTypeClass.isInterface() && keyTypeClass != (class$java$lang$Object == null ? (class$java$lang$Object = MapMetaData.class$("java.lang.Object")) : class$java$lang$Object)) {
            this.key.embedded = Boolean.TRUE;
        }
        if ((keymd = ((AbstractMemberMetaData)this.parent).getKeyMetaData()) != null && keymd.getEmbeddedMetaData() != null) {
            this.key.embedded = Boolean.TRUE;
        }
        if (this.value.type == null) {
            throw new InvalidMetaDataException(MetaData.LOCALISER, "044149", (Object)this.getFieldName(), this.getMemberMetaData().getClassName(false));
        }
        Class valueTypeClass = null;
        try {
            valueTypeClass = clr.classForName(this.value.type);
        }
        catch (ClassNotResolvedException cnre) {
            try {
                valueTypeClass = clr.classForName(ClassUtils.getJavaLangClassForType(this.value.type));
            }
            catch (ClassNotResolvedException cnre2) {
                throw new InvalidMetaDataException(MetaData.LOCALISER, "044150", (Object)this.getFieldName(), (Object)this.getMemberMetaData().getClassName(false), this.value.type);
            }
        }
        if (!valueTypeClass.getName().equals(this.value.type)) {
            NucleusLogger.METADATA.info(MetaData.LOCALISER.msg("044151", (Object)this.getFieldName(), (Object)this.getMemberMetaData().getClassName(false), (Object)this.value.type, (Object)valueTypeClass.getName()));
            this.value.type = valueTypeClass.getName();
        }
        if (this.value.embedded == null) {
            this.value.embedded = this.getMetaDataManager().getOMFContext().getTypeManager().isDefaultEmbeddedType(valueTypeClass) ? Boolean.TRUE : (api.isPersistable(valueTypeClass) || (class$java$lang$Object == null ? (class$java$lang$Object = MapMetaData.class$("java.lang.Object")) : class$java$lang$Object).isAssignableFrom(valueTypeClass) || valueTypeClass.isInterface() ? Boolean.FALSE : Boolean.TRUE);
        }
        if (this.value.embedded == Boolean.FALSE && !api.isPersistable(valueTypeClass) && !valueTypeClass.isInterface() && valueTypeClass != (class$java$lang$Object == null ? (class$java$lang$Object = MapMetaData.class$("java.lang.Object")) : class$java$lang$Object)) {
            this.value.embedded = Boolean.TRUE;
        }
        if ((valuemd = ((AbstractMemberMetaData)this.parent).getValueMetaData()) != null && valuemd.getEmbeddedMetaData() != null) {
            this.value.embedded = Boolean.TRUE;
        }
        this.key.classMetaData = this.getMemberMetaData().getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(keyTypeClass, clr);
        this.value.classMetaData = this.getMemberMetaData().getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(valueTypeClass, clr);
        if (keymd != null && keymd.mappedBy != null && keymd.mappedBy.equals("#PK")) {
            if (this.value.classMetaData.getNoOfPrimaryKeyMembers() != 1) {
                throw new NucleusUserException("JPOX does not support use of <map-key> with no name field when the value class has a composite primary key");
            }
            int[] valuePkFieldNums = this.value.classMetaData.getPKMemberPositions();
            keymd.mappedBy = this.value.classMetaData.getMetaDataForManagedMemberAtAbsolutePosition((int)valuePkFieldNums[0]).name;
        }
        this.setPopulated();
    }

    public String getKeyType() {
        return this.key.type;
    }

    public AbstractClassMetaData getKeyClassMetaData() {
        if (this.key.classMetaData != null && !this.key.classMetaData.isInitialised()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    MapMetaData.this.key.classMetaData.initialise();
                    return null;
                }
            });
        }
        return this.key.classMetaData;
    }

    public String getValueType() {
        return this.value.type;
    }

    public AbstractClassMetaData getValueClassMetaData() {
        if (this.value.classMetaData != null && !this.value.classMetaData.isInitialised()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    MapMetaData.this.value.classMetaData.initialise();
                    return null;
                }
            });
        }
        return this.value.classMetaData;
    }

    public boolean isEmbeddedKey() {
        if (this.key.embedded == null) {
            return false;
        }
        return this.key.embedded;
    }

    public boolean isEmbeddedValue() {
        if (this.value.embedded == null) {
            return false;
        }
        return this.value.embedded;
    }

    public boolean isSerializedKey() {
        if (this.key.serialized == null) {
            return false;
        }
        return this.key.serialized;
    }

    public boolean isSerializedValue() {
        if (this.value.serialized == null) {
            return false;
        }
        return this.value.serialized;
    }

    public boolean isDependentKey() {
        if (this.key.dependent == null) {
            return false;
        }
        if (this.key.classMetaData == null) {
            return false;
        }
        return this.key.dependent;
    }

    public boolean isDependentValue() {
        if (this.value.dependent == null) {
            return false;
        }
        if (this.value.classMetaData == null) {
            return false;
        }
        return this.value.dependent;
    }

    void getReferencedClassMetaData(List orderedCMDs, Set referencedCMDs, String dba_vendor_id, ClassLoaderResolver clr) {
        AbstractClassMetaData value_cmd;
        AbstractClassMetaData key_cmd = this.getMetaDataManager().getMetaDataForClass(this.key.type, clr);
        if (key_cmd != null) {
            key_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, clr);
        }
        if ((value_cmd = this.getMetaDataManager().getMetaDataForClass(this.value.type, clr)) != null) {
            value_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, clr);
        }
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<map key-type=\"").append(this.key.type).append("\" value-type=\"").append(this.value.type).append("\"");
        if (this.key.embedded != null) {
            sb.append(" embedded-key=\"").append(this.key.embedded).append("\"");
        }
        if (this.value.embedded != null) {
            sb.append(" embedded-value=\"").append(this.value.embedded).append("\"");
        }
        if (this.key.dependent != null) {
            sb.append(" dependent-key=\"").append(this.key.dependent).append("\"");
        }
        if (this.value.dependent != null) {
            sb.append(" dependent-value=\"").append(this.value.dependent).append("\"");
        }
        if (this.key.serialized != null) {
            sb.append(" serialized-key=\"").append(this.key.serialized).append("\"");
        }
        if (this.value.serialized != null) {
            sb.append(" serialized-value=\"").append(this.value.serialized).append("\"");
        }
        sb.append(">\n");
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</map>\n");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

