/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class EmbeddedMetaData
extends MetaData {
    protected final List members = new ArrayList();
    protected final String ownerMember;
    protected final String nullIndicatorColumn;
    protected final String nullIndicatorValue;
    protected AbstractMemberMetaData[] fieldMetaData;

    public EmbeddedMetaData(MetaData parent, EmbeddedMetaData embmd) {
        super(parent);
        this.ownerMember = embmd.ownerMember;
        this.nullIndicatorColumn = embmd.nullIndicatorColumn;
        this.nullIndicatorValue = embmd.nullIndicatorValue;
        for (int i = 0; i < embmd.members.size(); ++i) {
            if (embmd.members.get(i) instanceof FieldMetaData) {
                this.addMember(new FieldMetaData((MetaData)this, (AbstractMemberMetaData)embmd.members.get(i)));
                continue;
            }
            this.addMember(new PropertyMetaData((MetaData)this, (PropertyMetaData)embmd.members.get(i)));
        }
    }

    public EmbeddedMetaData(MetaData parent, String ownerField, String nullColumn, String nullValue) {
        super(parent);
        this.ownerMember = StringUtils.isWhitespace(ownerField) ? null : ownerField;
        this.nullIndicatorColumn = StringUtils.isWhitespace(nullColumn) ? null : nullColumn;
        this.nullIndicatorValue = StringUtils.isWhitespace(nullValue) ? null : nullValue;
    }

    public void populate(ClassLoaderResolver clr, ClassLoader primary) {
        int i;
        Class cls;
        MetaData md = this.getParent();
        AbstractMemberMetaData apmd = null;
        AbstractClassMetaData embCmd = null;
        String embeddedType = null;
        if (md instanceof AbstractMemberMetaData) {
            apmd = (AbstractMemberMetaData)md;
            embeddedType = apmd.getTypeName();
            MetaDataManager mmgr = apmd.getAbstractClassMetaData().getMetaDataManager();
            embCmd = mmgr.getMetaDataForClassInternal(apmd.getType(), clr);
            if (embCmd == null && apmd.getFieldTypes() != null && apmd.getFieldTypes().length == 1) {
                embCmd = mmgr.getMetaDataForClassInternal(clr.classForName(apmd.getFieldTypes()[0]), clr);
            }
            if (embCmd == null) {
                NucleusLogger.METADATA.error(MetaData.LOCALISER.msg("044121", (Object)apmd.getFullFieldName(), (Object)apmd.getTypeName()));
                throw new InvalidMetaDataException(MetaData.LOCALISER, "044121", (Object)apmd.getFullFieldName(), apmd.getTypeName());
            }
        } else if (md instanceof ElementMetaData) {
            ElementMetaData elemmd = (ElementMetaData)md;
            apmd = (AbstractMemberMetaData)elemmd.getParent();
            embeddedType = apmd.getCollection().getElementType();
            try {
                cls = clr.classForName(embeddedType, primary);
                embCmd = apmd.getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(cls, clr);
            }
            catch (ClassNotResolvedException cnre) {
                // empty catch block
            }
            if (embCmd == null) {
                NucleusLogger.METADATA.error(MetaData.LOCALISER.msg("044122", (Object)apmd.getFullFieldName(), (Object)apmd.getCollection().getElementType()));
                throw new InvalidMetaDataException(MetaData.LOCALISER, "044122", (Object)apmd.getFullFieldName(), apmd.getTypeName());
            }
        } else if (md instanceof KeyMetaData) {
            KeyMetaData keymd = (KeyMetaData)md;
            apmd = (AbstractMemberMetaData)keymd.getParent();
            embeddedType = apmd.getMap().getKeyType();
            try {
                cls = clr.classForName(embeddedType, primary);
                embCmd = apmd.getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(cls, clr);
            }
            catch (ClassNotResolvedException cnre) {
                // empty catch block
            }
            if (embCmd == null) {
                NucleusLogger.METADATA.error(MetaData.LOCALISER.msg("044123", (Object)apmd.getFullFieldName(), (Object)apmd.getMap().getKeyType()));
                throw new InvalidMetaDataException(MetaData.LOCALISER, "044123", (Object)apmd.getFullFieldName(), embeddedType);
            }
        } else if (md instanceof ValueMetaData) {
            ValueMetaData valuemd = (ValueMetaData)md;
            apmd = (AbstractMemberMetaData)valuemd.getParent();
            embeddedType = apmd.getMap().getValueType();
            try {
                cls = clr.classForName(embeddedType, primary);
                embCmd = apmd.getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(cls, clr);
            }
            catch (ClassNotResolvedException cnre) {
                // empty catch block
            }
            if (embCmd == null) {
                NucleusLogger.METADATA.error(MetaData.LOCALISER.msg("044124", (Object)apmd.getFullFieldName(), (Object)apmd.getMap().getValueType()));
                throw new InvalidMetaDataException(MetaData.LOCALISER, "044124", (Object)apmd.getFullFieldName(), embeddedType);
            }
        }
        Iterator memberIter = this.members.iterator();
        while (memberIter.hasNext()) {
            Object fld = memberIter.next();
            if (!(embCmd instanceof InterfaceMetaData) || !(fld instanceof FieldMetaData)) continue;
            throw new InvalidMetaDataException(MetaData.LOCALISER, "044129", (Object)apmd.getFullFieldName(), (Object)embCmd.getFullClassName(), ((AbstractMemberMetaData)fld).getName());
        }
        Class embeddedClass = null;
        Collections.sort(this.members);
        try {
            embeddedClass = clr.classForName(embeddedType, primary);
            Field[] cls_fields = embeddedClass.getDeclaredFields();
            for (i = 0; i < cls_fields.length; ++i) {
                if (!cls_fields[i].getDeclaringClass().getName().equals(embeddedType) || cls_fields[i].getName().startsWith("jdo") || ClassUtils.isInnerClass(cls_fields[i].getName()) || Modifier.isStatic(cls_fields[i].getModifiers()) || Collections.binarySearch(this.members, cls_fields[i].getName()) >= 0) continue;
                NucleusLogger.METADATA.debug(MetaData.LOCALISER.msg("044125", (Object)cls_fields[i].getName(), (Object)embeddedType, (Object)apmd.getClassName(true)));
                FieldMetaData omittedFmd = new FieldMetaData((MetaData)this, cls_fields[i].getName());
                this.members.add(omittedFmd);
                Collections.sort(this.members);
            }
        }
        catch (Exception e) {
            NucleusLogger.METADATA.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        }
        if (embCmd instanceof InterfaceMetaData) {
            try {
                Method[] clsMethods = embeddedClass.getDeclaredMethods();
                for (i = 0; i < clsMethods.length; ++i) {
                    String fieldName;
                    if (!clsMethods[i].getDeclaringClass().getName().equals(embeddedType) || !clsMethods[i].getName().startsWith("get") && !clsMethods[i].getName().startsWith("is") || ClassUtils.isInnerClass(clsMethods[i].getName()) || Collections.binarySearch(this.members, fieldName = ClassUtils.getFieldNameForJavaBeanGetter(clsMethods[i].getName())) >= 0) continue;
                    NucleusLogger.METADATA.debug(MetaData.LOCALISER.msg("044060", (Object)fieldName, (Object)apmd.getClassName(true)));
                    PropertyMetaData fmd = new PropertyMetaData((MetaData)this, fieldName);
                    this.members.add(fmd);
                    Collections.sort(this.members);
                }
            }
            catch (Exception e) {
                NucleusLogger.METADATA.error(e.getMessage(), e);
                throw new RuntimeException(e.getMessage());
            }
        }
        Collections.sort(this.members);
        memberIter = this.members.iterator();
        while (memberIter.hasNext()) {
            AbstractMemberMetaData fieldFmd = (AbstractMemberMetaData)memberIter.next();
            if (fieldFmd instanceof FieldMetaData) {
                Field cls_field = null;
                try {
                    cls_field = embeddedClass.getDeclaredField(fieldFmd.getName());
                }
                catch (Exception e) {
                    throw new InvalidMetaDataException(MetaData.LOCALISER, "044071", (Object)embeddedClass.getName(), fieldFmd.getFullFieldName());
                }
                fieldFmd.populate(clr, cls_field, null, primary);
                continue;
            }
            Method cls_method = null;
            try {
                try {
                    cls_method = embeddedClass.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(fieldFmd.getName(), true), null);
                }
                catch (Exception e) {
                    cls_method = embeddedClass.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(fieldFmd.getName(), false), null);
                }
            }
            catch (Exception e) {
                throw new InvalidMetaDataException(MetaData.LOCALISER, "044071", (Object)embeddedClass.getName(), fieldFmd.getFullFieldName());
            }
            fieldFmd.populate(clr, null, cls_method, primary);
        }
    }

    public void initialise() {
        this.fieldMetaData = new AbstractMemberMetaData[this.members.size()];
        for (int i = 0; i < this.fieldMetaData.length; ++i) {
            this.fieldMetaData[i] = (AbstractMemberMetaData)this.members.get(i);
            this.fieldMetaData[i].initialise();
        }
        this.setInitialised();
    }

    public final AbstractMemberMetaData[] getFieldMetaData() {
        return this.fieldMetaData;
    }

    public final String getOwnerMember() {
        return this.ownerMember;
    }

    public final String getNullIndicatorColumn() {
        return this.nullIndicatorColumn;
    }

    public final String getNullIndicatorValue() {
        return this.nullIndicatorValue;
    }

    public void addMember(AbstractMemberMetaData mmd) {
        if (mmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new RuntimeException(MetaData.LOCALISER.msg("044108", (Object)mmd.getName(), (Object)mmd.getAbstractClassMetaData().getFullClassName()));
        }
        Iterator iter = this.members.iterator();
        while (iter.hasNext()) {
            AbstractMemberMetaData md = (AbstractMemberMetaData)iter.next();
            if (!mmd.getName().equals(md.getName())) continue;
            throw new RuntimeException(MetaData.LOCALISER.msg("044112", (Object)mmd.getName(), (Object)mmd.getAbstractClassMetaData().getFullClassName()));
        }
        this.members.add(mmd);
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<embedded");
        if (this.ownerMember != null) {
            sb.append(" owner-field=\"" + this.ownerMember + "\"");
        }
        if (this.nullIndicatorColumn != null) {
            sb.append(" null-indicator-column=\"" + this.nullIndicatorColumn + "\"");
        }
        if (this.nullIndicatorValue != null) {
            sb.append(" null-indicator-value=\"" + this.nullIndicatorValue + "\"");
        }
        sb.append(">\n");
        for (int i = 0; i < this.members.size(); ++i) {
            AbstractMemberMetaData f = (AbstractMemberMetaData)this.members.get(i);
            sb.append(f.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix + "</embedded>\n");
        return sb.toString();
    }
}

