/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.io.PrintWriter;
import java.util.Set;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityReference;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.ActivityState;
import org.datanucleus.state.CacheState;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.AbstractFetchFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public abstract class AbstractStateManager
implements StateManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = AbstractStateManager.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    protected ObjectManager myOM;
    protected PersistenceCapable myPC;
    protected AbstractClassMetaData cmd;
    protected Object myInternalID;
    protected Object myID;
    protected LifeCycleState myLC;
    protected Object myVersion;
    protected Object transactionalVersion;
    protected FetchPlan.FetchPlanForClass myFP;
    protected boolean dirty = false;
    protected boolean[] dirtyFields;
    protected boolean[] loadedFields;
    protected boolean restoreValues = false;
    protected FieldManager currFM = null;
    protected Object currFMmonitor = new Object();
    protected int pcObjectType = 0;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public AbstractStateManager(ObjectManager om, AbstractClassMetaData cmd) {
        this.myOM = om;
        this.cmd = cmd;
        this.initialiseFieldInformation();
        this.myFP = this.myOM.getFetchPlan().manageFetchPlanForClass(cmd);
    }

    protected void initialiseFieldInformation() {
        int fieldCount = this.getHighestFieldNumber();
        this.dirtyFields = new boolean[fieldCount];
        this.loadedFields = new boolean[fieldCount];
    }

    protected CallbackHandler getCallbackHandler() {
        return this.myOM.getCallbackHandler();
    }

    protected boolean[] getSecondClassMutableFields() {
        return this.cmd.getSCOMutableMemberFlags();
    }

    protected boolean[] getNonPrimaryKeyFields() {
        return this.cmd.getNonPKMemberFlags();
    }

    protected int[] getAllFieldNumbers() {
        return this.cmd.getAllMemberPositions();
    }

    protected int[] getNonPrimaryKeyFieldNumbers() {
        return this.cmd.getNonPKMemberPositions();
    }

    protected int[] getSecondClassMutableFieldNumbers() {
        return this.cmd.getSCOMutableMemberPositions();
    }

    public StoreManager getStoreManager() {
        return this.myOM.getStoreManager();
    }

    public AbstractClassMetaData getClassMetaData() {
        return this.cmd;
    }

    public MetaDataManager getMetaDataManager() {
        return this.myOM.getMetaDataManager();
    }

    public ObjectManager getObjectManager() {
        return this.myOM;
    }

    public Object getObject() {
        return this.myPC;
    }

    public LifeCycleState getLifecycleState() {
        return this.myLC;
    }

    public boolean isRestoreValues() {
        return this.restoreValues;
    }

    protected void setRestoreValues(boolean restore_values) {
        this.restoreValues = restore_values;
    }

    public Object getInternalObjectId() {
        if (this.myID != null) {
            return this.myID;
        }
        if (this.myInternalID == null) {
            this.myInternalID = new IdentityReference(this);
            return this.myInternalID;
        }
        return this.myInternalID;
    }

    protected abstract boolean disconnectClone(PersistenceCapable var1);

    public boolean isDirty(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isDirty();
    }

    public boolean isTransactional(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isTransactional();
    }

    public boolean isPersistent(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isPersistent();
    }

    public boolean isNew(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isNew();
    }

    public boolean isDeleted(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isDeleted();
    }

    public Object getVersion(PersistenceCapable pc) {
        if (pc == this.myPC) {
            return this.transactionalVersion;
        }
        return null;
    }

    public void setTransactionalVersion(Object version) {
        this.transactionalVersion = version;
    }

    public Object getTransactionalVersion(Object pc) {
        return this.transactionalVersion;
    }

    public void setVersion(Object version) {
        this.myVersion = version;
        this.transactionalVersion = version;
    }

    public boolean isEmbedded() {
        return this.pcObjectType > 0;
    }

    public void setPcObjectType(int embeddedType) {
        this.pcObjectType = embeddedType;
    }

    public int getPcObjectType() {
        return this.pcObjectType;
    }

    public int getHighestFieldNumber() {
        return this.cmd.getMemberCount();
    }

    protected boolean isFetchPlanLoaded() {
        int[] fpFields = this.myFP.getFieldsInActualFetchPlan();
        for (int i = 0; i < fpFields.length; ++i) {
            if (this.loadedFields[fpFields[i]]) continue;
            return false;
        }
        return true;
    }

    protected boolean isDefaultFetchGroupLoaded() {
        int[] dfgFields = this.cmd.getDFGMemberPositions();
        for (int i = 0; i < dfgFields.length; ++i) {
            if (this.loadedFields[dfgFields[i]]) continue;
            return false;
        }
        return true;
    }

    public int[] getDirtyFieldNumbers() {
        return AbstractStateManager.getFlagsSetTo(this.dirtyFields, true);
    }

    public boolean[] getLoadedFields() {
        return (boolean[])this.loadedFields.clone();
    }

    public int[] getLoadedFieldNumbers() {
        return AbstractStateManager.getFlagsSetTo(this.loadedFields, true);
    }

    public String[] getDirtyFieldNames() {
        int[] dirtyFieldNumbers = AbstractStateManager.getFlagsSetTo(this.dirtyFields, true);
        if (dirtyFieldNumbers != null && dirtyFieldNumbers.length > 0) {
            String[] dirtyFieldNames = new String[dirtyFieldNumbers.length];
            for (int i = 0; i < dirtyFieldNumbers.length; ++i) {
                dirtyFieldNames[i] = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(dirtyFieldNumbers[i]).getName();
            }
            return dirtyFieldNames;
        }
        return null;
    }

    public String[] getLoadedFieldNames() {
        int[] loadedFieldNumbers = AbstractStateManager.getFlagsSetTo(this.loadedFields, true);
        if (loadedFieldNumbers != null && loadedFieldNumbers.length > 0) {
            String[] loadedFieldNames = new String[loadedFieldNumbers.length];
            for (int i = 0; i < loadedFieldNumbers.length; ++i) {
                loadedFieldNames[i] = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(loadedFieldNumbers[i]).getName();
            }
            return loadedFieldNames;
        }
        return null;
    }

    protected void clearDirtyFlags() {
        this.dirty = false;
        AbstractStateManager.clearFlags(this.dirtyFields);
    }

    protected void clearDirtyFlags(int[] fields) {
        this.dirty = false;
        AbstractStateManager.clearFlags(this.dirtyFields, fields);
    }

    public void providedBooleanField(PersistenceCapable pc, int field, boolean currentValue) {
        this.currFM.storeBooleanField(field, currentValue);
    }

    public void providedByteField(PersistenceCapable pc, int field, byte currentValue) {
        this.currFM.storeByteField(field, currentValue);
    }

    public void providedCharField(PersistenceCapable pc, int field, char currentValue) {
        this.currFM.storeCharField(field, currentValue);
    }

    public void providedDoubleField(PersistenceCapable pc, int field, double currentValue) {
        this.currFM.storeDoubleField(field, currentValue);
    }

    public void providedFloatField(PersistenceCapable pc, int field, float currentValue) {
        this.currFM.storeFloatField(field, currentValue);
    }

    public void providedIntField(PersistenceCapable pc, int field, int currentValue) {
        this.currFM.storeIntField(field, currentValue);
    }

    public void providedLongField(PersistenceCapable pc, int field, long currentValue) {
        this.currFM.storeLongField(field, currentValue);
    }

    public void providedShortField(PersistenceCapable pc, int field, short currentValue) {
        this.currFM.storeShortField(field, currentValue);
    }

    public void providedStringField(PersistenceCapable pc, int field, String currentValue) {
        this.currFM.storeStringField(field, currentValue);
    }

    public void providedObjectField(PersistenceCapable pc, int fieldNumber, Object currentValue) {
        this.currFM.storeObjectField(fieldNumber, currentValue);
    }

    public boolean replacingBooleanField(PersistenceCapable pc, int field) {
        boolean value = this.currFM.fetchBooleanField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public byte replacingByteField(PersistenceCapable obj, int field) {
        byte value = this.currFM.fetchByteField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public char replacingCharField(PersistenceCapable obj, int field) {
        char value = this.currFM.fetchCharField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public double replacingDoubleField(PersistenceCapable obj, int field) {
        double value = this.currFM.fetchDoubleField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public float replacingFloatField(PersistenceCapable obj, int field) {
        float value = this.currFM.fetchFloatField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public int replacingIntField(PersistenceCapable obj, int field) {
        int value = this.currFM.fetchIntField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public long replacingLongField(PersistenceCapable obj, int field) {
        long value = this.currFM.fetchLongField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public short replacingShortField(PersistenceCapable obj, int field) {
        short value = this.currFM.fetchShortField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public String replacingStringField(PersistenceCapable obj, int field) {
        String value = this.currFM.fetchStringField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public Object replacingObjectField(PersistenceCapable obj, int field) {
        try {
            Object value = this.currFM.fetchObjectField(field);
            this.loadedFields[field] = true;
            return value;
        }
        catch (AbstractFetchFieldManager.EndOfFetchPlanGraphException eodge) {
            return null;
        }
    }

    public boolean getBooleanField(PersistenceCapable pc, int field, boolean currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public byte getByteField(PersistenceCapable pc, int field, byte currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public char getCharField(PersistenceCapable pc, int field, char currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public double getDoubleField(PersistenceCapable pc, int field, double currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public float getFloatField(PersistenceCapable pc, int field, float currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public int getIntField(PersistenceCapable pc, int field, int currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public long getLongField(PersistenceCapable pc, int field, long currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public short getShortField(PersistenceCapable pc, int field, short currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public String getStringField(PersistenceCapable pc, int field, String currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public Object getObjectField(PersistenceCapable pc, int field, Object currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    protected static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    protected static void clearFlags(boolean[] flags) {
        for (int i = 0; i < flags.length; ++i) {
            flags[i] = false;
        }
    }

    protected static void clearFlags(boolean[] flags, int[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            flags[fields[i]] = false;
        }
    }

    public static int[] getFlagsSetTo(boolean[] flags, boolean state) {
        int[] temp = new int[flags.length];
        int j = 0;
        for (int i = 0; i < flags.length; ++i) {
            if (flags[i] != state) continue;
            temp[j++] = i;
        }
        if (j != 0) {
            int[] fieldNumbers = new int[j];
            System.arraycopy(temp, 0, fieldNumbers, 0, j);
            return fieldNumbers;
        }
        return null;
    }

    protected static int[] getFlagsSetTo(boolean[] flags, int[] indices, boolean state) {
        int[] temp = new int[indices.length];
        int j = 0;
        for (int i = 0; i < indices.length; ++i) {
            if (flags[indices[i]] != state) continue;
            temp[j++] = indices[i];
        }
        if (j != 0) {
            int[] fieldNumbers = new int[j];
            System.arraycopy(temp, 0, fieldNumbers, 0, j);
            return fieldNumbers;
        }
        return null;
    }

    protected static Object peekField(Object obj, String fieldName) {
        try {
            Object value = obj.getClass().getDeclaredField(fieldName).get(obj);
            if (value instanceof PersistenceCapable) {
                return StringUtils.toJVMIDString(value);
            }
            return value;
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public String toString() {
        return "StateManager[pc=" + StringUtils.toJVMIDString(this.myPC) + ", lifecycle=" + this.myLC + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ void setObjectField(PersistenceCapable var1, int var2, Object var3, Object var4);

    public abstract /* synthetic */ boolean isLoaded(PersistenceCapable var1, int var2);

    public abstract /* synthetic */ void replaceManagedPC(PersistenceCapable var1);

    public abstract /* synthetic */ Object getObjectId(PersistenceCapable var1);

    public abstract /* synthetic */ void dump(PrintWriter var1);

    public abstract /* synthetic */ void unloadField(String var1);

    public abstract /* synthetic */ boolean[] getDirtyFields();

    public abstract /* synthetic */ boolean getAllFieldsLoaded();

    public abstract /* synthetic */ void locate();

    public abstract /* synthetic */ boolean isUpdatingFieldForPostInsert();

    public abstract /* synthetic */ boolean isDirty();

    public abstract /* synthetic */ boolean isDetaching();

    public abstract /* synthetic */ boolean isDeleting();

    public abstract /* synthetic */ boolean isInserting();

    public abstract /* synthetic */ void loadFieldFromDatastore(int var1);

    public abstract /* synthetic */ Object getAssociatedValue(Object var1);

    public abstract /* synthetic */ void setAssociatedValue(Object var1, Object var2);

    public abstract /* synthetic */ void unsetStoringPC();

    public abstract /* synthetic */ void setStoringPC();

    public abstract /* synthetic */ StateManager[] getEmbeddedOwners();

    public abstract /* synthetic */ void retrieveDetachState(StateManager var1);

    public abstract /* synthetic */ void checkInheritance(FieldValues var1);

    public abstract /* synthetic */ void loadFieldValues(FieldValues var1);

    public abstract /* synthetic */ void addEmbeddedOwner(StateManager var1, int var2);

    public abstract /* synthetic */ void clearLoadedFlags();

    public abstract /* synthetic */ void registerTransactional();

    public abstract /* synthetic */ void clearFields();

    public abstract /* synthetic */ void saveFields();

    public abstract /* synthetic */ void restoreFields();

    public abstract /* synthetic */ void clearNonPrimaryKeyFields();

    public abstract /* synthetic */ void refreshFieldsInFetchPlan();

    public abstract /* synthetic */ void clearSavedFields();

    public abstract /* synthetic */ void refreshLoadedFields();

    public abstract /* synthetic */ void enlistInTransaction();

    public abstract /* synthetic */ void evictFromTransaction();

    public abstract /* synthetic */ void disconnect();

    public abstract /* synthetic */ void resetDetachState();

    public abstract /* synthetic */ void unloadNonFetchPlanFields();

    public abstract /* synthetic */ void loadUnloadedFields();

    public abstract /* synthetic */ void loadUnloadedFieldsOfClassInFetchPlan(FetchPlan var1);

    public abstract /* synthetic */ void loadFieldsInFetchPlan(FetchPlanState var1);

    public abstract /* synthetic */ void loadUnloadedFieldsInFetchPlan();

    public abstract /* synthetic */ void loadField(int var1);

    public abstract /* synthetic */ void nullifyFields();

    public abstract /* synthetic */ void setPostStoreNewObjectId(Object var1);

    public abstract /* synthetic */ boolean isWaitingToBeFlushedToDatastore();

    public abstract /* synthetic */ Object getReferencedPC();

    public abstract /* synthetic */ Object unwrapSCOField(int var1, Object var2, boolean var3);

    public abstract /* synthetic */ Object wrapSCOField(int var1, Object var2, boolean var3, boolean var4, boolean var5);

    public abstract /* synthetic */ void replaceAllLoadedSCOFieldsWithValues();

    public abstract /* synthetic */ void replaceAllLoadedSCOFieldsWithWrappers();

    public abstract /* synthetic */ void replaceNonLoadedFields(int[] var1, FieldManager var2);

    public abstract /* synthetic */ void replaceFields(int[] var1, FieldManager var2);

    public abstract /* synthetic */ void replaceFields(int[] var1, FieldManager var2, boolean var3);

    public abstract /* synthetic */ void replaceField(int var1, Object var2, boolean var3);

    public abstract /* synthetic */ void replaceFieldValue(int var1, Object var2);

    public abstract /* synthetic */ void provideFields(int[] var1, FieldManager var2);

    public abstract /* synthetic */ Object provideField(int var1);

    public abstract /* synthetic */ void clearManagedRelations();

    public abstract /* synthetic */ void processManagedRelations();

    public abstract /* synthetic */ void checkManagedRelations();

    public abstract /* synthetic */ RelationshipManager getRelationshipManager();

    public abstract /* synthetic */ void flush();

    public abstract /* synthetic */ void preRollback(Transaction var1);

    public abstract /* synthetic */ void postCommit(Transaction var1);

    public abstract /* synthetic */ void preBegin(Transaction var1);

    public abstract /* synthetic */ void retrieve(FetchPlan var1);

    public abstract /* synthetic */ void retrieve(boolean var1);

    public abstract /* synthetic */ void refresh();

    public abstract /* synthetic */ void evict();

    public abstract /* synthetic */ void validate();

    public abstract /* synthetic */ Object cache(CacheState var1);

    public abstract /* synthetic */ void detach(FetchPlanState var1);

    public abstract /* synthetic */ Object detachCopy(FetchPlanState var1);

    public abstract /* synthetic */ void attach(boolean var1);

    public abstract /* synthetic */ Object attachCopy(Object var1, boolean var2);

    public abstract /* synthetic */ void deletePersistent();

    public abstract /* synthetic */ void makePersistentTransactionalTransient();

    public abstract /* synthetic */ void makePersistent();

    public abstract /* synthetic */ void makeTransient(FetchPlanState var1);

    public abstract /* synthetic */ void makeNontransactional();

    public abstract /* synthetic */ void makeTransactional();

    public abstract /* synthetic */ void runReachability(Set var1);

    public abstract /* synthetic */ void changeActivityState(ActivityState var1);

    public abstract /* synthetic */ void updateFieldAfterInsert(Object var1, int var2);

    public abstract /* synthetic */ void makeDirty(int var1);

    public abstract /* synthetic */ Object getExternalObjectId(Object var1);

    public abstract /* synthetic */ void initialiseForPNewToBeDeleted(Object var1);

    public abstract /* synthetic */ void initialiseForCachedPC(CachedPC var1, Object var2, Class var3);

    public abstract /* synthetic */ void initialiseForDetached(Object var1, Object var2, Object var3);

    public abstract /* synthetic */ void initialiseForTransactionalTransient(Object var1);

    public abstract /* synthetic */ void initialiseForPersistentNew(Object var1, FieldValues var2);

    public abstract /* synthetic */ void initialiseForEmbedded(Object var1, boolean var2);

    public abstract /* synthetic */ void initialiseForPersistentClean(Object var1, Object var2);

    public abstract /* synthetic */ void initialiseForHollowPreConstructed(Object var1, Object var2);

    public abstract /* synthetic */ void initialiseForHollowAppId(FieldValues var1, Class var2);

    public abstract /* synthetic */ void initialiseForHollow(Object var1, FieldValues var2, Class var3);
}

