/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Stack;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.compiler.Lexer;
import org.datanucleus.query.compiler.Parser;
import org.datanucleus.query.node.Node;
import org.datanucleus.query.node.ParameterNode;
import org.datanucleus.store.query.QueryCompilerSyntaxException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class JDOQLParser
implements Parser {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = JDOQLParser.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    private static String[] jdoqlMethodNames = new String[]{"contains", "get", "containsKey", "containsValue", "isEmpty", "size", "toLowerCase", "toUpperCase", "indexOf", "matches", "substring", "startsWith", "endsWith", "Math.abs", "Math.sqrt", "JDOHelper.getObjectId", "JDOHelper.getVersion"};
    private String jdoqlMode = "DataNucleus";
    private Lexer p;
    private Stack stack = new Stack();
    private static String paramPrefixes = ":";
    int parameterPosition = 0;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public JDOQLParser(Map options) {
        if (options != null && options.containsKey("jdoql.level")) {
            this.jdoqlMode = (String)options.get("jdoql.level");
        }
    }

    public Node compile(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        return this.compileExpression();
    }

    public Node compileVariable(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        if (!this.compileIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
        }
        if (!this.compileIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
        }
        Node nodeVariable = (Node)this.stack.pop();
        Node nodeType = (Node)this.stack.pop();
        nodeType.appendChildNode(nodeVariable);
        return nodeType;
    }

    public Node[] compileFrom(String expression) {
        return null;
    }

    public Node[] compileOrder(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        return this.compileOrderExpression();
    }

    public Node[] compileTupple(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            this.compileExpression();
            Node expr = (Node)this.stack.pop();
            nodes.add(expr);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    public Node[][] compileVariables(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        do {
            this.compilePrimary();
            if (this.stack.isEmpty()) {
                throw new QueryCompilerSyntaxException("Parsing variable list and expected variable type", this.p.getIndex(), this.p.getInput());
            }
            if (!this.compileIdentifier()) {
                throw new QueryCompilerSyntaxException("Parsing variable list and expected variable name", this.p.getIndex(), this.p.getInput());
            }
            Node nodeVariable = (Node)this.stack.pop();
            String varName = (String)nodeVariable.getNodeValue();
            if (!StringUtils.isValidJavaIdentifierForJDOQL(varName)) {
                throw new NucleusUserException(LOCALISER.msg("021105", (Object)varName));
            }
            Node nodeType = (Node)this.stack.pop();
            nodes.add(new Node[]{nodeType, nodeVariable});
        } while (this.p.parseString(";"));
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    public Node[][] compileParameters(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        do {
            this.compilePrimary();
            if (this.stack.isEmpty()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            if (!this.compileIdentifier()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            Node nodeVariable = (Node)this.stack.pop();
            Node nodeType = (Node)this.stack.pop();
            nodes.add(new Node[]{nodeType, nodeVariable});
        } while (this.p.parseString(","));
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    private Node[] compileOrderExpression() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            Node expr;
            this.compileExpression();
            if (this.p.parseString("asc") || this.p.parseString("ascending") || this.p.parseString("ASC") || this.p.parseString("ASCENDING")) {
                expr = new Node(4, "ascending");
                this.stack.push(expr);
            } else if (this.p.parseString("desc") || this.p.parseString("descending") || this.p.parseString("DESC") || this.p.parseString("DESCENDING")) {
                expr = new Node(4, "descending");
                this.stack.push(expr);
            }
            expr = new Node(4, "order");
            expr.insertChildNode((Node)this.stack.pop());
            if (!this.stack.empty()) {
                expr.insertChildNode((Node)this.stack.pop());
            }
            nodes.add(expr);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    private Node compileExpression() {
        this.compileConditionalOrExpression();
        return (Node)this.stack.peek();
    }

    private void compileConditionalOrExpression() {
        this.compileConditionalAndExpression();
        while (this.p.parseString("||")) {
            this.compileConditionalAndExpression();
            Node expr = new Node(4, "||");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void compileConditionalAndExpression() {
        this.compileInclusiveOrExpression();
        while (this.p.parseString("&&")) {
            this.compileInclusiveOrExpression();
            Node expr = new Node(4, "&&");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void compileInclusiveOrExpression() {
        this.compileExclusiveOrExpression();
        while (this.p.parseChar('|', '|')) {
            this.compileExclusiveOrExpression();
            Node expr = new Node(4, "|");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void compileExclusiveOrExpression() {
        this.compileAndExpression();
        while (this.p.parseChar('^')) {
            this.compileAndExpression();
            Node expr = new Node(4, "^");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void compileAndExpression() {
        this.compileEqualityExpression();
        while (this.p.parseChar('&', '&')) {
            this.compileEqualityExpression();
            Node expr = new Node(4, "&");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void compileEqualityExpression() {
        this.compileRelationalExpression();
        while (true) {
            Node expr;
            if (this.p.parseString("==")) {
                this.compileRelationalExpression();
                expr = new Node(4, "==");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseString("!=")) break;
            this.compileRelationalExpression();
            expr = new Node(4, "!=");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
        if (this.p.parseString("=")) {
            throw new QueryCompilerSyntaxException("Invalid operator \"=\". Did you mean to use \"==\"?");
        }
    }

    private void compileRelationalExpression() {
        this.compileAdditiveExpression();
        while (true) {
            Node expr;
            if (this.p.parseString("<=")) {
                this.compileAdditiveExpression();
                expr = new Node(4, "<=");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseString(">=")) {
                this.compileAdditiveExpression();
                expr = new Node(4, ">=");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('<')) {
                this.compileAdditiveExpression();
                expr = new Node(4, "<");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('>')) {
                this.compileAdditiveExpression();
                expr = new Node(4, ">");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseString("instanceof")) break;
            this.compileAdditiveExpression();
            expr = new Node(4, "instanceof");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void compileAdditiveExpression() {
        this.compileMultiplicativeExpression();
        while (true) {
            Node expr;
            if (this.p.parseChar('+')) {
                this.compileMultiplicativeExpression();
                expr = new Node(4, "+");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseChar('-')) break;
            this.compileMultiplicativeExpression();
            expr = new Node(4, "-");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void compileMultiplicativeExpression() {
        this.compileUnaryExpression();
        while (true) {
            Node expr;
            if (this.p.parseChar('*')) {
                this.compileMultiplicativeExpression();
                expr = new Node(4, "*");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('/')) {
                this.compileMultiplicativeExpression();
                expr = new Node(4, "/");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseChar('%')) break;
            this.compileMultiplicativeExpression();
            expr = new Node(4, "%");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void compileUnaryExpression() {
        if (this.p.parseString("++")) {
            throw new QueryCompilerSyntaxException("Unsupported operator '++'");
        }
        if (this.p.parseString("--")) {
            throw new QueryCompilerSyntaxException("Unsupported operator '--'");
        }
        if (this.p.parseChar('+')) {
            this.compileUnaryExpression();
        } else if (this.p.parseChar('-')) {
            this.compileUnaryExpression();
            Node expr = new Node(4, "NEG");
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        } else {
            this.compileUnaryExpressionNotPlusMinus();
        }
    }

    protected void compileUnaryExpressionNotPlusMinus() {
        if (this.p.parseChar('~')) {
            this.compileUnaryExpression();
            Node expr = new Node(4, "~");
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        } else if (this.p.parseChar('!')) {
            this.compileUnaryExpression();
            Node expr = new Node(4, "!");
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        } else {
            this.compilePrimary();
        }
    }

    protected void compilePrimary() {
        if (this.p.parseStringIgnoreCase("DISTINCT")) {
            Node distinctNode = new Node(4, "DISTINCT");
            this.compileIdentifier();
            Node identifierNode = (Node)this.stack.pop();
            distinctNode.appendChildNode(identifierNode);
            this.stack.push(distinctNode);
            return;
        }
        if (this.compileCreator()) {
            return;
        }
        if (this.compileLiteral()) {
            return;
        }
        if (this.compileMethod()) {
            return;
        }
        if (this.p.parseChar('(')) {
            this.compileExpression();
            if (!this.p.parseChar(')')) {
                throw new QueryCompilerSyntaxException("expected ')'", this.p.getIndex(), this.p.getInput());
            }
            return;
        }
        if (!this.compileIdentifier()) {
            throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
        }
        int size = this.stack.size();
        while (this.p.parseChar('.')) {
            if (this.compileMethod() || this.compileIdentifier()) continue;
            throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
        }
        while (this.stack.size() > size) {
            Node top = (Node)this.stack.pop();
            Node peek = (Node)this.stack.peek();
            peek.insertChildNode(top);
        }
    }

    private boolean compileCreator() {
        if (this.p.parseString("new")) {
            int size = this.stack.size();
            if (!this.compileMethod()) {
                if (!this.compileIdentifier()) {
                    throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
                }
                while (this.p.parseChar('.')) {
                    if (this.compileMethod() || this.compileIdentifier()) continue;
                    throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
                }
            }
            while (this.stack.size() - 1 > size) {
                Node top = (Node)this.stack.pop();
                Node peek = (Node)this.stack.peek();
                peek.insertChildNode(top);
            }
            Node expr = (Node)this.stack.pop();
            Node newExpr = new Node(5);
            newExpr.insertChildNode(expr);
            this.stack.push(newExpr);
            return true;
        }
        return false;
    }

    private boolean compileMethod() {
        String method = this.p.parseMethod();
        if (method != null) {
            this.p.skipWS();
            this.p.parseChar('(');
            if (this.stack.size() > 0) {
                Node primExprNode = (Node)this.stack.peek();
                if (primExprNode != null && primExprNode.getNodeValue().equals("JDOHelper")) {
                    if (method.equals("getObjectId")) {
                        method = "JDOHelper.getObjectId";
                        this.stack.pop();
                    } else if (method.equals("getVersion")) {
                        method = "JDOHelper.getVersion";
                        this.stack.pop();
                    }
                }
                if (primExprNode != null && primExprNode.getNodeValue().equals("Math")) {
                    if (method.equals("abs")) {
                        method = "Math.abs";
                        this.stack.pop();
                    } else if (method.equals("sqrt")) {
                        method = "Math.sqrt";
                        this.stack.pop();
                    }
                }
            }
            if (this.jdoqlMode.equals("JDO2") && Arrays.binarySearch(jdoqlMethodNames, method) < 0) {
                throw new QueryCompilerSyntaxException("Query uses method \"" + method + "\" but this is not a standard JDOQL method name");
            }
            Node expr = new Node(1, method);
            if (!this.p.parseChar(')')) {
                int numArgs = 0;
                do {
                    this.compileExpression();
                    expr.addProperty((Node)this.stack.pop());
                    ++numArgs;
                } while (this.p.parseChar(','));
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
            }
            this.stack.push(expr);
            return true;
        }
        return false;
    }

    protected boolean compileLiteral() {
        Object litValue = null;
        boolean single_quote_next = this.p.nextIsSingleQuote();
        String sLiteral = this.p.parseStringLiteral();
        if (sLiteral != null) {
            litValue = sLiteral.length() == 1 && single_quote_next ? new Character(sLiteral.charAt(0)) : sLiteral;
        } else {
            BigDecimal fLiteral = this.p.parseFloatingPointLiteral();
            if (fLiteral != null) {
                litValue = fLiteral;
            } else {
                BigInteger iLiteral = this.p.parseIntegerLiteral();
                if (iLiteral != null) {
                    litValue = new Long(iLiteral.longValue());
                } else {
                    Boolean bLiteral = this.p.parseBooleanLiteral();
                    if (bLiteral != null) {
                        litValue = bLiteral;
                    } else if (this.p.parseNullLiteral()) {
                        litValue = null;
                    } else {
                        return false;
                    }
                }
            }
        }
        this.stack.push(new Node(0, litValue));
        return true;
    }

    private boolean compileIdentifier() {
        String id = this.p.parseIdentifier();
        if (id == null) {
            return false;
        }
        char first = id.charAt(0);
        if (paramPrefixes.indexOf(first) >= 0) {
            ParameterNode expr = new ParameterNode(8, id.substring(1), this.parameterPosition);
            ++this.parameterPosition;
            this.stack.push(expr);
            return true;
        }
        Node expr = new Node(3, id);
        this.stack.push(expr);
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

