/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ContainerComponent;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class CollectionMetaData
extends ContainerMetaData {
    protected ContainerComponent element;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Object;

    public CollectionMetaData(AbstractMemberMetaData parent, CollectionMetaData colmd) {
        super(parent);
        this.element = new ContainerComponent();
        this.element.embedded = colmd.element.embedded;
        this.element.serialized = colmd.element.serialized;
        this.element.dependent = colmd.element.dependent;
        this.element.type = colmd.element.type;
        this.element.classMetaData = colmd.element.classMetaData;
    }

    public CollectionMetaData(AbstractMemberMetaData parent, String elementType, String embeddedElement, String dependentElement, String serializedElement) {
        super(parent);
        if (!StringUtils.isWhitespace(elementType) && elementType.indexOf(44) > 0) {
            throw new InvalidMetaDataException(MetaData.LOCALISER, "044131", (Object)parent.getName(), parent.getClassName());
        }
        this.element = new ContainerComponent(parent.getAbstractClassMetaData().getPackageName(), elementType, embeddedElement, serializedElement, dependentElement);
    }

    public void populate(ClassLoaderResolver clr, ClassLoader primary) {
        ElementMetaData elemmd;
        Class field_type;
        ApiAdapter api = this.getMetaDataManager().getApiAdapter();
        if (!(class$java$util$Collection == null ? (class$java$util$Collection = CollectionMetaData.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(field_type = this.getMemberMetaData().getType())) {
            throw new InvalidMetaDataException(MetaData.LOCALISER, "044132", (Object)this.getFieldName(), this.getMemberMetaData().getClassName(false));
        }
        if (this.element.type == null) {
            throw new InvalidMetaDataException(MetaData.LOCALISER, "044133", (Object)this.getFieldName(), this.getMemberMetaData().getClassName(false));
        }
        Class elementTypeClass = null;
        try {
            elementTypeClass = clr.classForName(this.element.type, primary);
        }
        catch (ClassNotResolvedException cnre) {
            try {
                elementTypeClass = clr.classForName(ClassUtils.getJavaLangClassForType(this.element.type), primary);
            }
            catch (ClassNotResolvedException cnre2) {
                throw new InvalidMetaDataException(MetaData.LOCALISER, "044134", (Object)this.getFieldName(), (Object)this.getMemberMetaData().getClassName(false), this.element.type);
            }
        }
        if (!elementTypeClass.getName().equals(this.element.type)) {
            NucleusLogger.METADATA.info(MetaData.LOCALISER.msg("044135", (Object)this.getFieldName(), (Object)this.getMemberMetaData().getClassName(false), (Object)this.element.type, (Object)elementTypeClass.getName()));
            this.element.type = elementTypeClass.getName();
        }
        if (this.element.embedded == null) {
            this.element.embedded = this.getMetaDataManager().getOMFContext().getTypeManager().isDefaultEmbeddedType(elementTypeClass) ? Boolean.TRUE : (api.isPersistable(elementTypeClass) || (class$java$lang$Object == null ? (class$java$lang$Object = CollectionMetaData.class$("java.lang.Object")) : class$java$lang$Object).isAssignableFrom(elementTypeClass) || elementTypeClass.isInterface() ? Boolean.FALSE : Boolean.TRUE);
        }
        if (this.element.embedded == Boolean.FALSE && !api.isPersistable(elementTypeClass) && !elementTypeClass.isInterface() && elementTypeClass != (class$java$lang$Object == null ? (class$java$lang$Object = CollectionMetaData.class$("java.lang.Object")) : class$java$lang$Object)) {
            this.element.embedded = Boolean.TRUE;
        }
        if ((elemmd = ((AbstractMemberMetaData)this.parent).getElementMetaData()) != null && elemmd.getEmbeddedMetaData() != null) {
            this.element.embedded = Boolean.TRUE;
        }
        if (this.element.dependent == Boolean.TRUE && !api.isPersistable(elementTypeClass) && !elementTypeClass.isInterface() && elementTypeClass != (class$java$lang$Object == null ? (class$java$lang$Object = CollectionMetaData.class$("java.lang.Object")) : class$java$lang$Object)) {
            this.element.dependent = Boolean.FALSE;
        }
        this.element.classMetaData = this.getMemberMetaData().getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(elementTypeClass, clr);
        this.setPopulated();
    }

    public String getElementType() {
        return this.element.type;
    }

    public AbstractClassMetaData getElementClassMetaData() {
        if (this.element.classMetaData != null && !this.element.classMetaData.isInitialised()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CollectionMetaData.this.element.classMetaData.initialise();
                    return null;
                }
            });
        }
        return this.element.classMetaData;
    }

    public boolean isEmbeddedElement() {
        if (this.element.embedded == null) {
            return false;
        }
        return this.element.embedded;
    }

    public boolean isDependentElement() {
        if (this.element.dependent == null) {
            return false;
        }
        if (this.element.classMetaData == null) {
            return false;
        }
        return this.element.dependent;
    }

    public boolean isSerializedElement() {
        if (this.element.serialized == null) {
            return false;
        }
        return this.element.serialized;
    }

    void getReferencedClassMetaData(List orderedCMDs, Set referencedCMDs, String dba_vendor_id, ClassLoaderResolver clr) {
        AbstractClassMetaData element_cmd = this.getMetaDataManager().getMetaDataForClass(this.element.type, clr);
        if (element_cmd != null) {
            element_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, clr);
        }
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<collection element-type=\"").append(this.element.type).append("\"");
        if (this.element.embedded != null) {
            sb.append(" embedded-element=\"").append(this.element.embedded).append("\"");
        }
        if (this.element.dependent != null) {
            sb.append(" dependent-element=\"").append(this.element.dependent).append("\"");
        }
        if (this.element.serialized != null) {
            sb.append(" serialized-element=\"").append(this.element.serialized).append("\"");
        }
        sb.append(">\n");
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</collection>\n");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

